/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.constants.EnumAnimation;
import noppes.npcs.constants.EnumJobType;
import noppes.npcs.constants.EnumRoleType;
import noppes.npcs.controllers.Line;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.scripted.ScriptFaction;
import noppes.npcs.scripted.ScriptItemStack;
import noppes.npcs.scripted.ScriptLiving;
import noppes.npcs.scripted.ScriptLivingBase;
import noppes.npcs.scripted.ScriptPlayer;
import noppes.npcs.scripted.roles.ScriptJobBard;
import noppes.npcs.scripted.roles.ScriptJobConversation;
import noppes.npcs.scripted.roles.ScriptJobFollower;
import noppes.npcs.scripted.roles.ScriptJobGuard;
import noppes.npcs.scripted.roles.ScriptJobHealer;
import noppes.npcs.scripted.roles.ScriptJobInterface;
import noppes.npcs.scripted.roles.ScriptJobItemGiver;
import noppes.npcs.scripted.roles.ScriptJobSpawner;
import noppes.npcs.scripted.roles.ScriptRoleBank;
import noppes.npcs.scripted.roles.ScriptRoleFollower;
import noppes.npcs.scripted.roles.ScriptRoleInterface;
import noppes.npcs.scripted.roles.ScriptRoleMailman;
import noppes.npcs.scripted.roles.ScriptRoleTrader;
import noppes.npcs.scripted.roles.ScriptRoleTransporter;

public class ScriptNpc
extends ScriptLiving {
    protected EntityNPCInterface npc;

    public ScriptNpc(EntityNPCInterface npc) {
        super((EntityLiving)npc);
        this.npc = npc;
    }

    public int getSize() {
        return this.npc.display.modelSize;
    }

    public void setSize(int size) {
        if (size > 30) {
            size = 30;
        } else if (size < 1) {
            size = 1;
        }
        this.npc.display.modelSize = size;
        this.npc.script.needsUpdate = true;
    }

    public String getName() {
        return this.npc.display.name;
    }

    public void setName(String name) {
        this.npc.display.name = name;
        this.npc.script.needsUpdate = true;
    }

    public int getHomeX() {
        return this.npc.startPos[0];
    }

    public void setHomeX(int x) {
        this.npc.startPos[0] = x;
    }

    public int getHomeY() {
        return this.npc.startPos[1];
    }

    public void setHomeY(int y) {
        this.npc.startPos[1] = y;
    }

    public int getHomeZ() {
        return this.npc.startPos[2];
    }

    public void setHomeZ(int z) {
        this.npc.startPos[2] = z;
    }

    public void setHome(int x, int y, int z) {
        this.npc.startPos = new int[]{x, y, z};
    }

    public void setMaxHealth(int health) {
        this.npc.stats.setMaxHealth(health);
        this.npc.script.needsUpdate = true;
    }

    public void setReturnToHome(boolean bo) {
        this.npc.ai.returnToStart = bo;
    }

    public boolean getReturnToHome() {
        return this.npc.ai.returnToStart;
    }

    public ScriptFaction getFaction() {
        return new ScriptFaction(this.npc.getFaction());
    }

    public void setFaction(int id) {
        this.npc.setFaction(id);
    }

    @Override
    public int getType() {
        return 2;
    }

    public void shootItem(ScriptLivingBase target, ScriptItemStack item, int accuracy) {
        if (item == null) {
            return;
        }
        if (accuracy < 0) {
            accuracy = 0;
        } else if (accuracy > 100) {
            accuracy = 100;
        }
        this.npc.shoot(target.entity, accuracy, item.item, false);
    }

    public void say(String message) {
        this.npc.saySurrounding(new Line(message));
    }

    public void kill() {
        this.npc.func_70106_y();
    }

    public void reset() {
        this.npc.reset();
    }

    public ScriptRoleInterface getRole() {
        if (this.npc.advanced.role == EnumRoleType.Bank) {
            return new ScriptRoleBank(this.npc);
        }
        if (this.npc.advanced.role == EnumRoleType.Follower) {
            return new ScriptRoleFollower(this.npc);
        }
        if (this.npc.advanced.role == EnumRoleType.Postman) {
            return new ScriptRoleMailman(this.npc);
        }
        if (this.npc.advanced.role == EnumRoleType.Trader) {
            return new ScriptRoleTrader(this.npc);
        }
        if (this.npc.advanced.role == EnumRoleType.Transporter) {
            return new ScriptRoleTransporter(this.npc);
        }
        return new ScriptRoleInterface(this.npc);
    }

    public ScriptJobInterface getJob() {
        if (this.npc.advanced.job == EnumJobType.Bard) {
            return new ScriptJobBard(this.npc);
        }
        if (this.npc.advanced.job == EnumJobType.Conversation) {
            return new ScriptJobConversation(this.npc);
        }
        if (this.npc.advanced.job == EnumJobType.Follower) {
            return new ScriptJobFollower(this.npc);
        }
        if (this.npc.advanced.job == EnumJobType.Guard) {
            return new ScriptJobGuard(this.npc);
        }
        if (this.npc.advanced.job == EnumJobType.Healer) {
            return new ScriptJobHealer(this.npc);
        }
        if (this.npc.advanced.job == EnumJobType.ItemGiver) {
            return new ScriptJobItemGiver(this.npc);
        }
        if (this.npc.advanced.job == EnumJobType.Spawner) {
            return new ScriptJobSpawner(this.npc);
        }
        return new ScriptJobInterface(this.npc);
    }

    public ScriptItemStack getRightItem() {
        ItemStack item = this.npc.inventory.getWeapon();
        if (item == null || item.func_77973_b() == null) {
            return null;
        }
        return new ScriptItemStack(item);
    }

    public void setRightItem(ScriptItemStack item) {
        if (item == null) {
            this.npc.inventory.setWeapon(null);
        } else {
            this.npc.inventory.setWeapon(item.item);
        }
        this.npc.script.needsUpdate = true;
    }

    public ScriptItemStack getLefttItem() {
        ItemStack item = this.npc.getOffHand();
        if (item == null || item.func_77973_b() == null) {
            return null;
        }
        return new ScriptItemStack(item);
    }

    public void setLeftItem(ScriptItemStack item) {
        if (item == null) {
            this.npc.inventory.setOffHand(null);
        } else {
            this.npc.inventory.setOffHand(item.item);
        }
        this.npc.script.needsUpdate = true;
    }

    public ScriptItemStack getProjectileItem() {
        ItemStack item = this.npc.getOffHand();
        if (item == null || item.func_77973_b() == null) {
            return null;
        }
        return new ScriptItemStack(item);
    }

    public void setProjectileItem(ScriptItemStack item) {
        if (item == null) {
            this.npc.inventory.setProjectile(null);
        } else {
            this.npc.inventory.setProjectile(item.item);
        }
        this.npc.updateTasks();
    }

    public ScriptItemStack getArmor(int slot) {
        ItemStack item = this.npc.inventory.armor.get(slot);
        if (item == null) {
            return null;
        }
        return new ScriptItemStack(item);
    }

    public void setArmor(int slot, ScriptItemStack item) {
        if (item == null) {
            this.npc.inventory.armor.put(slot, null);
        } else {
            this.npc.inventory.armor.put(slot, item.item);
        }
        this.npc.script.needsUpdate = true;
    }

    public void setAnimation(int type) {
        if (type == 0) {
            this.npc.ai.animationType = EnumAnimation.NONE;
        } else if (type == 1) {
            this.npc.ai.animationType = EnumAnimation.SITTING;
        } else if (type == 5) {
            this.npc.ai.animationType = EnumAnimation.DANCING;
        } else if (type == 4) {
            this.npc.ai.animationType = EnumAnimation.SNEAKING;
        } else if (type == 2) {
            this.npc.ai.animationType = EnumAnimation.LYING;
        } else if (type == 3) {
            this.npc.ai.animationType = EnumAnimation.HUG;
        }
    }

    public void setVisibleType(int type) {
        this.npc.display.visible = type;
        this.npc.script.needsUpdate = true;
    }

    public int getVisibleType() {
        return this.npc.display.visible;
    }

    public void setShowName(int type) {
        this.npc.display.showName = type;
    }

    public int getShowName() {
        return this.npc.display.showName;
    }

    public int getMeleeStrength() {
        return this.npc.stats.attackStrength;
    }

    public void setMeleeStrength(int strength) {
        this.npc.stats.attackStrength = strength;
        this.npc.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)this.npc.stats.attackStrength);
    }

    public int getProjectileStrength() {
        return this.npc.stats.pDamage;
    }

    public void setProjectileStrength(int strength) {
        this.npc.stats.pDamage = strength;
    }

    public void giveItem(ScriptPlayer player, ScriptItemStack item) {
        this.npc.givePlayerItem((EntityPlayer)player.player, item.item);
    }

    public void executeCommand(String command) {
        NoppesUtilServer.runCommand((EntityLivingBase)this.npc, this.npc.func_70005_c_(), command, null);
    }
}

