/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.blocks.BlockRotated;
import noppes.npcs.blocks.tiles.TileColorable;

public abstract class BlockLightable
extends BlockRotated {
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");

    protected BlockLightable(Block block, boolean lit) {
        super(block);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(lit)));
        if (lit) {
            this.func_149715_a(1.0f);
        }
    }

    public abstract Block unlitBlock();

    public abstract Block litBlock();

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (this.litBlock() == this) {
            world.func_180501_a(pos, this.unlitBlock().func_176223_P().func_177226_a((IProperty)DAMAGE, state.func_177229_b((IProperty)DAMAGE)), 2);
        } else {
            world.func_180501_a(pos, this.litBlock().func_176223_P().func_177226_a((IProperty)DAMAGE, state.func_177229_b((IProperty)DAMAGE)), 2);
        }
        tile.func_145829_t();
        world.func_175690_a(pos, tile);
        return true;
    }

    @Override
    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{DAMAGE, LIT});
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.litBlock());
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_180665_b(World world, BlockPos pos) {
        return Item.func_150898_a((Block)this.litBlock());
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(this.litBlock());
    }

    public void onPostBlockPlaced(World world, BlockPos pos, IBlockState state, EntityPlayer player, ItemStack stack, EnumFacing facing) {
        TileColorable tile = (TileColorable)world.func_175625_s(pos);
        if (facing == EnumFacing.UP) {
            tile.color = 0;
        } else if (facing == EnumFacing.DOWN) {
            tile.color = 1;
        } else {
            tile.color = 2;
            if (facing == EnumFacing.NORTH) {
                tile.rotation = 0;
            } else if (facing == EnumFacing.EAST) {
                tile.rotation = 2;
            } else if (facing == EnumFacing.SOUTH) {
                tile.rotation = 4;
            } else if (facing == EnumFacing.WEST) {
                tile.rotation = 6;
            }
        }
    }
}

