/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import noppes.npcs.CustomItems;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.blocks.tiles.TileScripted;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.util.IPermission;

public class BlockScripted
extends BlockContainer
implements IPermission {
    public BlockScripted() {
        super(Material.field_151576_e);
        this.func_149676_a(0.001f, 0.001f, 0.001f, 0.998f, 0.998f, 0.998f);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileScripted();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (currentItem != null && (currentItem.func_77973_b() == CustomItems.wand || currentItem.func_77973_b() == CustomItems.scripter)) {
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.ScriptBlock, null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        return !EventHooks.onScriptBlockInteract(tile, player, side.func_176745_a(), hitX, hitY, hitZ);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        if (entity instanceof EntityPlayer && !world.field_72995_K) {
            NoppesUtilServer.sendOpenGui((EntityPlayer)entity, EnumGuiType.ScriptBlock, null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entityIn) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        EventHooks.onScriptBlockCollide(tile, entityIn);
    }

    public void func_176224_k(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        EventHooks.onScriptBlockRainFill(tile);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        fallDistance = EventHooks.onScriptBlockFallenUpon(tile, entity, fallDistance);
        super.func_180658_a(world, pos, entity, fallDistance);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        EventHooks.onScriptBlockClicked(tile, player);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        EventHooks.onScriptBlockBreak(tile);
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return super.removedByPlayer(world, pos, player, willHarvest);
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        if (EventHooks.onScriptBlockHarvest(tile, player)) {
            return false;
        }
        return super.removedByPlayer(world, pos, player, willHarvest);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        TileScripted tile;
        if (!world.field_72995_K && EventHooks.onScriptBlockExploded(tile = (TileScripted)world.func_175625_s(pos))) {
            return;
        }
        super.onBlockExploded(world, pos, explosion);
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        EventHooks.onScriptBlockNeighborChanged(tile);
        int power = 0;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            int p = world.func_175651_c(pos.func_177972_a(enumfacing), enumfacing);
            if (p <= power) continue;
            power = p;
        }
        if (tile.prevPower != power && tile.powering <= 0) {
            tile.newPower = power;
        }
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_180656_a(IBlockAccess worldIn, BlockPos pos, IBlockState state, EnumFacing side) {
        return this.func_176211_b(worldIn, pos, state, side);
    }

    public int func_176211_b(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        return ((TileScripted)world.func_175625_s((BlockPos)pos)).activePowering;
    }

    public boolean isLadder(IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return ((TileScripted)world.func_175625_s((BlockPos)pos)).isLadder;
    }

    public boolean canCreatureSpawn(IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return true;
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        if (tile == null) {
            return 0;
        }
        return tile.lightValue;
    }

    public boolean canEntityDestroy(IBlockAccess world, BlockPos pos, Entity entity) {
        return super.canEntityDestroy(world, pos, entity);
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return super.getEnchantPowerBonus(world, pos);
    }

    public float func_176195_g(World worldIn, BlockPos pos) {
        return this.field_149782_v;
    }

    @Override
    public boolean isAllowed(EnumPacketServer e) {
        return e == EnumPacketServer.SaveTileEntity || e == EnumPacketServer.ScriptBlockDataSave;
    }
}

