/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.util.HashMap;
import java.util.Vector;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.StatCollector;
import noppes.npcs.Schematic;
import noppes.npcs.blocks.tiles.TileBuilder;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.SubGuiNpcAvailability;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcButtonYesNo;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.constants.EnumPacketServer;

public class GuiBlockBuilder
extends GuiNPCInterface
implements IGuiData,
ICustomScrollListener,
IScrollData {
    private int x;
    private int y;
    private int z;
    private TileBuilder tile;
    private GuiCustomScroll scroll;
    private Schematic selected = null;

    public GuiBlockBuilder(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.setBackground("menubg.png");
        this.xSize = 256;
        this.ySize = 216;
        this.closeOnEsc = true;
        this.tile = (TileBuilder)this.player.field_70170_p.func_175625_s(new BlockPos(x, y, z));
    }

    @Override
    public void initPacket() {
        Client.sendData(EnumPacketServer.SchematicsTile, this.x, this.y, this.z);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(125, 208);
        }
        this.scroll.guiLeft = this.guiLeft + 4;
        this.scroll.guiTop = this.guiTop + 4;
        this.addScroll(this.scroll);
        if (this.selected != null) {
            int y = this.guiTop + 4;
            if (this.selected.size < 125000) {
                this.addButton(new GuiNpcButtonYesNo(3, this.guiLeft + 200, y, TileBuilder.DrawPos != null && this.tile.func_174877_v().equals((Object)TileBuilder.DrawPos)));
                this.addLabel(new GuiNpcLabel(3, "schematic.preview", this.guiLeft + 130, y + 5));
            }
            this.addLabel(new GuiNpcLabel(0, StatCollector.func_74838_a((String)"schematic.width") + ": " + this.selected.width, this.guiLeft + 130, y += 22));
            this.addLabel(new GuiNpcLabel(1, StatCollector.func_74838_a((String)"schematic.length") + ": " + this.selected.length, this.guiLeft + 130, y += 12));
            this.addLabel(new GuiNpcLabel(2, StatCollector.func_74838_a((String)"schematic.height") + ": " + this.selected.height, this.guiLeft + 130, y += 12));
            this.addButton(new GuiNpcButtonYesNo(4, this.guiLeft + 200, y += 16, this.tile.enabled));
            this.addLabel(new GuiNpcLabel(4, StatCollector.func_74838_a((String)"gui.enabled"), this.guiLeft + 130, y + 5));
            this.addButton(new GuiNpcButtonYesNo(7, this.guiLeft + 200, y += 23, this.tile.finished));
            this.addLabel(new GuiNpcLabel(7, StatCollector.func_74838_a((String)"gui.finished"), this.guiLeft + 130, y + 5));
            this.addButton(new GuiNpcButtonYesNo(8, this.guiLeft + 200, y += 23, this.tile.started));
            this.addLabel(new GuiNpcLabel(8, StatCollector.func_74838_a((String)"gui.started"), this.guiLeft + 130, y + 5));
            this.addTextField(new GuiNpcTextField(9, this, this.guiLeft + 200, y += 23, 50, 20, this.tile.yOffest + ""));
            this.addLabel(new GuiNpcLabel(9, StatCollector.func_74838_a((String)"gui.yoffset"), this.guiLeft + 130, y + 5));
            this.getTextField((int)9).numbersOnly = true;
            this.getTextField(9).setMinMaxDefault(-10, 10, 0);
            this.addButton(new GuiNpcButton(5, this.guiLeft + 200, y += 23, 50, 20, new String[]{"0", "90", "180", "270"}, this.tile.rotation));
            this.addLabel(new GuiNpcLabel(5, StatCollector.func_74838_a((String)"movement.rotation"), this.guiLeft + 130, y + 5));
            this.addButton(new GuiNpcButton(6, this.guiLeft + 130, y += 22, 120, 20, "availability.options"));
        }
    }

    @Override
    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton.field_146127_k == 3) {
            GuiNpcButtonYesNo button = (GuiNpcButtonYesNo)guibutton;
            if (button.getBoolean()) {
                TileBuilder.SetDrawPos(new BlockPos(this.x, this.y, this.z));
                this.tile.setDrawSchematic(this.selected);
            } else {
                TileBuilder.SetDrawPos(null);
                this.tile.setDrawSchematic(null);
            }
        }
        if (guibutton.field_146127_k == 4) {
            this.tile.enabled = ((GuiNpcButtonYesNo)guibutton).getBoolean();
        }
        if (guibutton.field_146127_k == 5) {
            this.tile.rotation = ((GuiNpcButton)guibutton).getValue();
        }
        if (guibutton.field_146127_k == 6) {
            this.setSubGui(new SubGuiNpcAvailability(this.tile.availability));
        }
        if (guibutton.field_146127_k == 7) {
            this.tile.finished = ((GuiNpcButtonYesNo)guibutton).getBoolean();
            Client.sendData(EnumPacketServer.SchematicsSet, this.x, this.y, this.z, this.scroll.getSelected());
        }
        if (guibutton.field_146127_k == 8) {
            this.tile.started = ((GuiNpcButtonYesNo)guibutton).getBoolean();
        }
    }

    @Override
    public void save() {
        if (this.getTextField(9) != null) {
            this.tile.yOffest = this.getTextField(9).getInteger();
        }
        Client.sendData(EnumPacketServer.SchematicsTileSave, this.x, this.y, this.z, this.tile.writePartNBT(new NBTTagCompound()));
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        if (compound.func_74764_b("Width")) {
            this.selected = new Schematic(compound.func_74779_i("SchematicName"));
            this.selected.load(compound);
            if (TileBuilder.DrawPos != null && TileBuilder.DrawPos.equals((Object)this.tile.func_174877_v())) {
                this.tile.setDrawSchematic(this.selected);
            }
            this.scroll.setSelected(this.selected.name);
            this.scroll.scrollTo(this.selected.name);
        } else {
            this.tile.readPartNBT(compound);
        }
        this.func_73866_w_();
    }

    @Override
    public void customScrollClicked(int i, int j, int k, GuiCustomScroll scroll) {
        if (!scroll.hasSelected()) {
            return;
        }
        if (this.selected != null) {
            this.getButton(3).setDisplay(0);
        }
        TileBuilder.SetDrawPos(null);
        this.tile.setDrawSchematic(null);
        Client.sendData(EnumPacketServer.SchematicsSet, this.x, this.y, this.z, scroll.getSelected());
    }

    @Override
    public void setData(Vector<String> list, HashMap<String, Integer> data) {
        this.scroll.setList(list);
        if (this.selected != null) {
            this.scroll.setSelected(this.selected.name);
        }
        this.func_73866_w_();
    }

    @Override
    public void setSelected(String selected) {
    }
}

