/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Schematic;

public class SchematicController {
    public static SchematicController Instance = new SchematicController();
    private Schematic building = null;
    private ICommandSender buildStarter = null;
    private int buildingPercentage = 0;
    public List<String> included = Arrays.asList("Archery_Range", "Bakery", "Barn", "Building_Site", "Chapel", "Church", "Gate", "Glassworks", "Guard_Tower", "Guild_House", "House", "House_Small", "Inn", "Library", "Lighthouse", "Mill", "Observatory", "Ship", "Shop", "Stall", "Stall2", "Stall3", "Tier_House1", "Tier_House2", "Tier_House3", "Tower", "Wall", "Wall_Corner");

    public List<String> list() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.included);
        for (File file : this.getDir().listFiles()) {
            String name = file.getName();
            if (!name.toLowerCase().endsWith(".schematic") || name.contains(" ")) continue;
            list.add(name.substring(0, name.length() - 10));
        }
        Collections.sort(list);
        return list;
    }

    public File getDir() {
        File dir = new File(CustomNpcs.getWorldSaveDirectory(), "schematics");
        if (!dir.exists()) {
            dir.mkdir();
        }
        return dir;
    }

    public void info(ICommandSender sender) {
        if (this.building == null) {
            this.sendMessage(sender, "Nothing is being build");
        } else {
            this.sendMessage(sender, "Already building: " + this.building.name + " - " + this.building.getPercentage() + "%");
            if (this.buildStarter != null) {
                this.sendMessage(sender, "Build started by: " + this.buildStarter.func_70005_c_());
            }
        }
    }

    private void sendMessage(ICommandSender sender, String message) {
        if (sender == null) {
            return;
        }
        sender.func_145747_a((IChatComponent)new ChatComponentText(message));
    }

    public void stop(ICommandSender sender) {
        if (this.building == null || !this.building.isBuilding) {
            this.sendMessage(sender, "Not building");
        } else {
            this.sendMessage(sender, "Stopped building: " + this.building.name);
            this.building = null;
        }
    }

    public void build(Schematic schem, ICommandSender sender) {
        if (this.building != null && this.building.isBuilding) {
            this.info(sender);
            return;
        }
        this.buildingPercentage = 0;
        this.building = schem;
        this.building.isBuilding = true;
        this.buildStarter = sender;
    }

    public void updateBuilding() {
        if (this.building == null) {
            return;
        }
        this.building.build();
        if (this.buildStarter != null && this.building.getPercentage() - this.buildingPercentage >= 10) {
            this.sendMessage(this.buildStarter, "Building at " + this.building.getPercentage() + "%");
            this.buildingPercentage = this.building.getPercentage();
        }
        if (!this.building.isBuilding) {
            if (this.buildStarter != null) {
                this.sendMessage(this.buildStarter, "Building finished");
            }
            this.building = null;
        }
    }

    public Schematic load(String name) {
        InputStream stream = null;
        if (this.included.contains(name)) {
            stream = MinecraftServer.class.getResourceAsStream("/assets/customnpcs/schematics/" + name + ".schematic");
        }
        if (stream == null) {
            File file = new File(this.getDir(), name + ".schematic");
            if (!file.exists()) {
                return null;
            }
            try {
                stream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        try {
            Schematic schema = new Schematic(name);
            schema.load(CompressedStreamTools.func_74796_a(stream));
            stream.close();
            return schema;
        }
        catch (IOException e) {
            LogWriter.except(e);
            return null;
        }
    }

    public void save(ICommandSender sender, String name, BlockPos pos, short height, short width, short length) {
        if (this.included.contains(name = name.replace(" ", "_"))) {
            return;
        }
        Schematic schema = new Schematic(name);
        schema.height = height;
        schema.width = width;
        schema.length = length;
        schema.size = height * width * length;
        schema.blockArray = new short[schema.size];
        schema.blockDataArray = new byte[schema.size];
        NoppesUtilServer.NotifyOPs("Creating schematic at: " + pos + " might lag slightly", new Object[0]);
        World world = sender.func_130014_f_();
        schema.tileList = new NBTTagList();
        for (int i = 0; i < schema.size; ++i) {
            int x = i % width;
            int z = (i - x) / width % length;
            int y = ((i - x) / width - z) / length;
            IBlockState state = world.func_180495_p(pos.func_177982_a(x, y, z));
            if (state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c() == CustomItems.copy) continue;
            schema.blockArray[i] = (short)Block.field_149771_c.func_148757_b((Object)state.func_177230_c());
            schema.blockDataArray[i] = (byte)state.func_177230_c().func_176201_c(state);
            if (!(state.func_177230_c() instanceof ITileEntityProvider)) continue;
            TileEntity tile = world.func_175625_s(pos.func_177982_a(x, y, z));
            NBTTagCompound compound = new NBTTagCompound();
            tile.func_145841_b(compound);
            compound.func_74768_a("x", x);
            compound.func_74768_a("y", y);
            compound.func_74768_a("z", z);
            schema.tileList.func_74742_a((NBTBase)compound);
        }
        File file = new File(this.getDir(), name + ".schematic");
        NoppesUtilServer.NotifyOPs("Schematic " + name + " succesfully created", new Object[0]);
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)schema.save(), (OutputStream)new FileOutputStream(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

