/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.DataWatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.IChatMessages;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcDamageSource;
import noppes.npcs.Server;
import noppes.npcs.VersionCompatibility;
import noppes.npcs.ai.EntityAIAmbushTarget;
import noppes.npcs.ai.EntityAIAnimation;
import noppes.npcs.ai.EntityAIAttackTarget;
import noppes.npcs.ai.EntityAIAvoidTarget;
import noppes.npcs.ai.EntityAIBustDoor;
import noppes.npcs.ai.EntityAIDodgeShoot;
import noppes.npcs.ai.EntityAIFindShade;
import noppes.npcs.ai.EntityAIFollow;
import noppes.npcs.ai.EntityAIJob;
import noppes.npcs.ai.EntityAILook;
import noppes.npcs.ai.EntityAIMoveIndoors;
import noppes.npcs.ai.EntityAIMovingPath;
import noppes.npcs.ai.EntityAIOrbitTarget;
import noppes.npcs.ai.EntityAIPanic;
import noppes.npcs.ai.EntityAIPounceTarget;
import noppes.npcs.ai.EntityAIRangedAttack;
import noppes.npcs.ai.EntityAIReturn;
import noppes.npcs.ai.EntityAIRole;
import noppes.npcs.ai.EntityAISprintToTarget;
import noppes.npcs.ai.EntityAIStalkTarget;
import noppes.npcs.ai.EntityAITransform;
import noppes.npcs.ai.EntityAIWander;
import noppes.npcs.ai.EntityAIWatchClosest;
import noppes.npcs.ai.EntityAIWaterNav;
import noppes.npcs.ai.EntityAIWorldLines;
import noppes.npcs.ai.EntityAIZigZagTarget;
import noppes.npcs.ai.FlyingMoveHelper;
import noppes.npcs.ai.PathNavigateFlying;
import noppes.npcs.ai.selector.NPCAttackSelector;
import noppes.npcs.ai.target.EntityAIClearTarget;
import noppes.npcs.ai.target.EntityAIClosestTarget;
import noppes.npcs.ai.target.EntityAIOwnerHurtByTarget;
import noppes.npcs.ai.target.EntityAIOwnerHurtTarget;
import noppes.npcs.api.IItemStack;
import noppes.npcs.api.constants.PotionEffectType;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.event.NpcEvent;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.api.wrapper.NPCWrapper;
import noppes.npcs.client.EntityUtil;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.DataTransform;
import noppes.npcs.controllers.Dialog;
import noppes.npcs.controllers.DialogOption;
import noppes.npcs.controllers.Faction;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.Line;
import noppes.npcs.controllers.LinkedNpcController;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.controllers.QuestData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityProjectile;
import noppes.npcs.entity.data.DataAI;
import noppes.npcs.entity.data.DataAdvanced;
import noppes.npcs.entity.data.DataDisplay;
import noppes.npcs.entity.data.DataInventory;
import noppes.npcs.entity.data.DataScript;
import noppes.npcs.entity.data.DataStats;
import noppes.npcs.entity.data.DataTimers;
import noppes.npcs.items.ItemSoulstoneFilled;
import noppes.npcs.roles.JobBard;
import noppes.npcs.roles.JobFollower;
import noppes.npcs.roles.JobInterface;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleFollower;
import noppes.npcs.roles.RoleInterface;
import noppes.npcs.util.GameProfileAlt;
import noppes.npcs.util.IProjectileCallback;

public abstract class EntityNPCInterface
extends EntityCreature
implements IEntityAdditionalSpawnData,
ICommandSender,
IRangedAttackMob,
IBossDisplayData {
    public static final int DWRole = 16;
    public static final int DWJob = 17;
    public static final int DWBool = 25;
    private static final GameProfileAlt chateventProfile = new GameProfileAlt();
    private static FakePlayer chateventPlayer;
    public ICustomNpc wrappedNPC;
    public DataDisplay display;
    public DataStats stats;
    public DataAI ai;
    public DataAdvanced advanced;
    public DataInventory inventory;
    public DataScript script;
    public DataTransform transform;
    public DataTimers timers;
    public String linkedName = "";
    public long linkedLast = 0L;
    public LinkedNpcController.LinkedData linkedData;
    public float baseHeight = 1.8f;
    public float scaleX;
    public float scaleY;
    public float scaleZ;
    private boolean wasKilled = false;
    public RoleInterface roleInterface;
    public JobInterface jobInterface;
    public HashMap<Integer, DialogOption> dialogs;
    public boolean hasDied = false;
    public long killedtime = 0L;
    public long totalTicksAlive = 0L;
    private int taskCount = 1;
    public int lastInteract = 0;
    public Faction faction;
    private EntityAIRangedAttack aiRange;
    private EntityAIBase aiAttackTarget;
    public EntityAILook lookAi;
    public EntityAIAnimation animateAi;
    public List<EntityLivingBase> interactingEntities = new ArrayList<EntityLivingBase>();
    public ResourceLocation textureLocation = null;
    public ResourceLocation textureGlowLocation = null;
    public ResourceLocation textureCloakLocation = null;
    public int currentAnimation = 0;
    public int animationStart = 0;
    public int npcVersion = VersionCompatibility.ModRev;
    public IChatMessages messages;
    public boolean updateClient = false;
    public boolean updateAI = false;
    public double field_20066_r;
    public double field_20065_s;
    public double field_20064_t;
    public double field_20063_u;
    public double field_20062_v;
    public double field_20061_w;
    private double startYPos = -1.0;

    public EntityNPCInterface(World world) {
        super(world);
        if (!this.isRemote()) {
            this.wrappedNPC = new NPCWrapper<EntityNPCInterface>(this);
        }
        this.dialogs = new HashMap();
        if (!CustomNpcs.DefaultInteractLine.isEmpty()) {
            this.advanced.interactLines.lines.put(0, new Line(CustomNpcs.DefaultInteractLine));
        }
        this.field_70728_aV = 0;
        this.scaleZ = 0.9375f;
        this.scaleY = 0.9375f;
        this.scaleX = 0.9375f;
        this.faction = this.getFaction();
        this.setFaction(this.faction.id);
        this.func_70105_a(1.0f, 1.0f);
        this.updateAI = true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.display = new DataDisplay(this);
        this.stats = new DataStats(this);
        this.ai = new DataAI(this);
        this.advanced = new DataAdvanced(this);
        this.inventory = new DataInventory(this);
        this.transform = new DataTransform(this);
        this.script = new DataScript(this);
        this.timers = new DataTimers((Object)this);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.stats.maxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)CustomNpcs.NpcNavRange);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.getSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)this.stats.melee.getStrength());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(13, (Object)String.valueOf(""));
        this.field_70180_af.func_75682_a(14, (Object)0);
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(16, (Object)String.valueOf(""));
        this.field_70180_af.func_75682_a(17, (Object)String.valueOf(""));
    }

    public boolean func_70089_S() {
        return super.func_70089_S() && !this.isKilled();
    }

    public void func_70071_h_() {
        this.startYPos = this.calculateStartYPos(this.ai.startPos()) + 1.0;
        if (this.startYPos < 0.0 && !this.isRemote()) {
            this.func_70106_y();
        }
        super.func_70071_h_();
        if (this.field_70173_aa % 10 == 0) {
            EventHooks.onNPCTick(this);
        }
        this.timers.update();
    }

    public boolean func_70652_k(Entity par1Entity) {
        boolean var4;
        float f = this.stats.melee.getStrength();
        if (this.stats.melee.getDelay() < 10) {
            par1Entity.field_70172_ad = 0;
        }
        if (par1Entity instanceof EntityLivingBase) {
            NpcEvent.MeleeAttackEvent event = new NpcEvent.MeleeAttackEvent(this.wrappedNPC, (EntityLivingBase)par1Entity, f);
            if (EventHooks.onNPCAttacksMelee(this, event)) {
                return false;
            }
            f = event.damage;
        }
        if (var4 = par1Entity.func_70097_a((DamageSource)new NpcDamageSource("mob", (Entity)this), f)) {
            if (this.getOwner() instanceof EntityPlayer) {
                EntityUtil.setRecentlyHit((EntityLivingBase)par1Entity);
            }
            if (this.stats.melee.getKnockback() > 0) {
                par1Entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)this.stats.melee.getKnockback() * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)this.stats.melee.getKnockback() * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if (this.advanced.role == 6) {
                ((RoleCompanion)this.roleInterface).attackedEntity(par1Entity);
            }
        }
        if (this.stats.melee.getEffectType() != 0) {
            if (this.stats.melee.getEffectType() != 1) {
                ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(PotionEffectType.getMCType((int)this.stats.melee.getEffectType()).field_76415_H, this.stats.melee.getEffectTime() * 20, this.stats.melee.getEffectStrength()));
            } else {
                par1Entity.func_70015_d(this.stats.melee.getEffectTime());
            }
        }
        return var4;
    }

    public void func_70636_d() {
        float f;
        if (CustomNpcs.FreezeNPCs) {
            return;
        }
        ++this.totalTicksAlive;
        this.func_82168_bl();
        if (this.field_70173_aa % 20 == 0) {
            this.faction = this.getFaction();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (!this.isKilled() && this.field_70173_aa % 20 == 0) {
                this.advanced.scenes.update();
                if (this.func_110143_aJ() < this.func_110138_aP()) {
                    if (this.stats.healthRegen > 0 && !this.isAttacking()) {
                        this.func_70691_i(this.stats.healthRegen);
                    }
                    if (this.stats.combatRegen > 0 && this.isAttacking()) {
                        this.func_70691_i(this.stats.combatRegen);
                    }
                }
                if (this.faction.getsAttacked && !this.isAttacking()) {
                    List list = this.field_70170_p.func_72872_a(EntityMob.class, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0));
                    for (EntityMob mob : list) {
                        if (mob.func_70638_az() != null || !this.canSee((Entity)mob)) continue;
                        if (mob instanceof EntityZombie && !mob.getEntityData().func_74764_b("AttackNpcs")) {
                            mob.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)mob, EntityLivingBase.class, 1.0, false));
                            mob.getEntityData().func_74757_a("AttackNpcs", true);
                        }
                        mob.func_70624_b((EntityLivingBase)this);
                    }
                }
                if (this.linkedData != null && this.linkedData.time > this.linkedLast) {
                    LinkedNpcController.Instance.loadNpcData(this);
                }
                if (this.updateClient) {
                    NBTTagCompound compound = this.writeSpawnData();
                    compound.func_74768_a("EntityId", this.func_145782_y());
                    Server.sendAssociatedData((Entity)this, EnumPacketClient.UPDATE_NPC, compound);
                    this.updateClient = false;
                }
                if (this.updateAI) {
                    this.updateTasks();
                    this.updateAI = false;
                }
            }
            if (this.func_110143_aJ() <= 0.0f) {
                this.func_70674_bp();
                this.setBoolFlag(true, 8);
            }
            this.setBoolFlag(this.func_70638_az() != null, 4);
            this.setBoolFlag(!this.func_70661_as().func_75500_f(), 1);
            this.setBoolFlag(this.isInteracting(), 2);
            this.onCollide();
        }
        if (this.wasKilled != this.isKilled() && this.wasKilled) {
            this.reset();
        }
        this.wasKilled = this.isKilled();
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && this.stats.burnInSun && (f = this.func_70013_c(1.0f)) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175710_j(new BlockPos((Entity)this))) {
            this.func_70015_d(8);
        }
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.roleInterface != null) {
                this.roleInterface.clientUpdate();
            }
            if (this.textureCloakLocation != null) {
                this.cloakUpdate();
            }
            if (this.currentAnimation != this.field_70180_af.func_75679_c(14)) {
                this.currentAnimation = this.field_70180_af.func_75679_c(14);
                this.animationStart = this.field_70173_aa;
                this.updateHitbox();
            }
            if (this.advanced.job == 1) {
                ((JobBard)this.jobInterface).onLivingUpdate();
            }
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (currentItem != null) {
            Item item = currentItem.func_77973_b();
            if (item == CustomItems.cloner || item == CustomItems.wand || item == CustomItems.mount || item == CustomItems.scripter) {
                this.func_70624_b(null);
                this.func_70604_c(null);
                return true;
            }
            if (item == CustomItems.moving) {
                this.func_70624_b(null);
                currentItem.func_77983_a("NPCID", (NBTBase)new NBTTagInt(this.func_145782_y()));
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("Registered " + this.func_70005_c_() + " to your NPC Pather", new Object[0]));
                return true;
            }
        }
        if (EventHooks.onNPCInteract(this, player)) {
            return false;
        }
        this.addInteract((EntityLivingBase)player);
        Dialog dialog = this.getDialog(player);
        PlayerQuestData playerdata = PlayerDataController.instance.getPlayerData((EntityPlayer)player).questData;
        QuestData data = playerdata.getQuestCompletion(player, this);
        if (data != null) {
            Server.sendData((EntityPlayerMP)player, EnumPacketClient.QUEST_COMPLETION, data.quest.writeToNBT(new NBTTagCompound()));
        } else if (dialog != null) {
            NoppesUtilServer.openDialog(player, this, dialog);
        } else if (this.roleInterface != null) {
            this.roleInterface.interact(player);
        } else {
            this.say(player, this.advanced.getInteractLine());
        }
        return true;
    }

    public void addInteract(EntityLivingBase entity) {
        if (!this.ai.stopAndInteract || this.isAttacking() || !entity.func_70089_S() || this.func_175446_cd()) {
            return;
        }
        if (this.field_70173_aa - this.lastInteract < 180) {
            this.interactingEntities.clear();
        }
        this.func_70661_as().func_75499_g();
        this.lastInteract = this.field_70173_aa;
        if (!this.interactingEntities.contains(entity)) {
            this.interactingEntities.add(entity);
        }
    }

    public boolean isInteracting() {
        if (this.field_70173_aa - this.lastInteract < 40 || this.isRemote() && this.getBoolFlag(2)) {
            return true;
        }
        return this.ai.stopAndInteract && !this.interactingEntities.isEmpty() && this.field_70173_aa - this.lastInteract < 180;
    }

    private Dialog getDialog(EntityPlayer player) {
        for (DialogOption option : this.dialogs.values()) {
            if (option == null || !option.hasDialog()) continue;
            Dialog dialog = option.getDialog();
            if (!dialog.availability.isAvailable(player)) continue;
            return dialog;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K || CustomNpcs.FreezeNPCs || damagesource.field_76373_n.equals("inWall")) {
            return false;
        }
        if (damagesource.field_76373_n.equals("outOfWorld") && this.isKilled()) {
            this.reset();
        }
        i = this.stats.resistances.applyResistance(damagesource, i);
        if ((float)this.field_70172_ad > (float)this.field_70771_an / 2.0f && i <= this.field_110153_bc) {
            return false;
        }
        Entity entity = damagesource.func_76364_f();
        EntityLivingBase attackingEntity = null;
        if (entity instanceof EntityLivingBase) {
            attackingEntity = (EntityLivingBase)entity;
        }
        if (entity instanceof EntityArrow && ((EntityArrow)entity).field_70250_c instanceof EntityLivingBase) {
            attackingEntity = (EntityLivingBase)((EntityArrow)entity).field_70250_c;
        } else if (entity instanceof EntityThrowable) {
            attackingEntity = ((EntityThrowable)entity).func_85052_h();
        }
        if (attackingEntity != null && attackingEntity == this.getOwner()) {
            return false;
        }
        if (attackingEntity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)attackingEntity;
            if (npc.faction.id == this.faction.id) {
                return false;
            }
            if (npc.getOwner() instanceof EntityPlayer) {
                this.field_70718_bc = 100;
            }
        } else if (attackingEntity instanceof EntityPlayer && this.faction.isFriendlyToPlayer((EntityPlayer)attackingEntity)) {
            return false;
        }
        NpcEvent.DamagedEvent event = new NpcEvent.DamagedEvent(this.wrappedNPC, attackingEntity, i, damagesource);
        if (EventHooks.onNPCDamaged(this, event)) {
            return false;
        }
        i = event.damage;
        if (this.isKilled()) {
            return false;
        }
        if (attackingEntity == null) {
            return super.func_70097_a(damagesource, i);
        }
        try {
            if (this.isAttacking()) {
                if (this.func_70638_az() != null && attackingEntity != null && this.func_70068_e((Entity)this.func_70638_az()) > this.func_70068_e((Entity)attackingEntity)) {
                    this.func_70624_b(attackingEntity);
                }
                boolean bl = super.func_70097_a(damagesource, i);
                return bl;
            }
            if (i > 0.0f) {
                List inRange = this.field_70170_p.func_72872_a(EntityNPCInterface.class, this.func_174813_aQ().func_72314_b(32.0, 16.0, 32.0));
                for (EntityNPCInterface npc : inRange) {
                    if (npc.isKilled() || !npc.advanced.defendFaction || npc.faction.id != this.faction.id || !npc.canSee((Entity)this) && !npc.ai.directLOS && !npc.canSee((Entity)attackingEntity)) continue;
                    npc.onAttack(attackingEntity);
                }
                this.func_70624_b(attackingEntity);
            }
            boolean bl = super.func_70097_a(damagesource, i);
            return bl;
        }
        finally {
            if (event.clearTarget) {
                this.func_70624_b(null);
                this.func_70604_c(null);
            }
        }
    }

    public void onAttack(EntityLivingBase entity) {
        if (entity == null || entity == this || this.isAttacking() || this.ai.onAttack == 3 || entity == this.getOwner()) {
            return;
        }
        super.func_70624_b(entity);
    }

    public void func_70624_b(EntityLivingBase entity) {
        Line line;
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75102_a || entity != null && entity == this.getOwner() || this.func_70638_az() == entity) {
            return;
        }
        if (entity != null) {
            NpcEvent.TargetEvent event = new NpcEvent.TargetEvent(this.wrappedNPC, (EntityLivingBase)entity);
            if (EventHooks.onNPCTarget(this, event)) {
                return;
            }
            entity = event.entity == null ? null : event.entity.getMCEntity();
        } else if (EventHooks.onNPCTargetLost(this, this.func_70638_az())) {
            return;
        }
        if (entity != null && entity != this && this.ai.onAttack != 3 && !this.isAttacking() && !this.isRemote() && (line = this.advanced.getAttackLine()) != null) {
            this.saySurrounding(line.formatTarget((EntityLivingBase)entity));
        }
        super.func_70624_b(entity);
    }

    public void func_82196_d(EntityLivingBase entity, float f) {
        final ItemStack proj = ItemStackWrapper.MCItem(this.inventory.getProjectile());
        if (proj == null) {
            this.updateAI = true;
            return;
        }
        NpcEvent.RangedLaunchedEvent event = new NpcEvent.RangedLaunchedEvent(this.wrappedNPC, entity, this.stats.ranged.getStrength());
        if (EventHooks.onNPCRangedLaunched(this, event)) {
            return;
        }
        for (int i = 0; i < this.stats.ranged.getShotCount(); ++i) {
            EntityProjectile projectile = this.shoot(entity, this.stats.ranged.getAccuracy(), proj, f == 1.0f);
            projectile.damage = event.damage;
            projectile.callback = new IProjectileCallback(){

                @Override
                public boolean onImpact(EntityProjectile projectile, BlockPos pos, Entity entity) {
                    Entity e;
                    if (proj.func_77973_b() == CustomItems.soulstoneFull && (e = ItemSoulstoneFilled.Spawn(null, proj, EntityNPCInterface.this.field_70170_p, pos)) instanceof EntityLivingBase && entity instanceof EntityLivingBase) {
                        if (e instanceof EntityLiving) {
                            ((EntityLiving)e).func_70624_b((EntityLivingBase)entity);
                        } else {
                            ((EntityLivingBase)e).func_70604_c((EntityLivingBase)entity);
                        }
                    }
                    projectile.func_85030_a(EntityNPCInterface.this.stats.ranged.getSound(entity != null ? 1 : 2), 1.0f, 1.2f / (EntityNPCInterface.this.func_70681_au().nextFloat() * 0.2f + 0.9f));
                    return false;
                }
            };
        }
        this.func_85030_a(this.stats.ranged.getSound(0), 2.0f, 1.0f);
    }

    public EntityProjectile shoot(EntityLivingBase entity, int accuracy, ItemStack proj, boolean indirect) {
        return this.shoot(entity.field_70165_t, entity.func_174813_aQ().field_72338_b + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v, accuracy, proj, indirect);
    }

    public EntityProjectile shoot(double x, double y, double z, int accuracy, ItemStack proj, boolean indirect) {
        EntityProjectile projectile = new EntityProjectile(this.field_70170_p, (EntityLivingBase)this, proj.func_77946_l(), true);
        double varX = x - this.field_70165_t;
        double varY = y - (this.field_70163_u + (double)this.func_70047_e());
        double varZ = z - this.field_70161_v;
        float varF = projectile.hasGravity() ? MathHelper.func_76133_a((double)(varX * varX + varZ * varZ)) : 0.0f;
        float angle = projectile.getAngleForXYZ(varX, varY, varZ, varF, indirect);
        float acc = 20.0f - (float)MathHelper.func_76141_d((float)((float)accuracy / 5.0f));
        projectile.func_70186_c(varX, varY, varZ, angle, acc);
        this.field_70170_p.func_72838_d((Entity)projectile);
        return projectile;
    }

    private void clearTasks(EntityAITasks tasks) {
        Iterator iterator = tasks.field_75782_a.iterator();
        ArrayList list = new ArrayList(tasks.field_75782_a);
        for (EntityAITasks.EntityAITaskEntry entityaitaskentry : list) {
            this.field_70714_bg.func_85156_a(entityaitaskentry.field_75733_a);
        }
        tasks.field_75782_a = new ArrayList();
    }

    private void updateTasks() {
        if (this.field_70170_p == null || this.field_70170_p.field_72995_K) {
            return;
        }
        this.clearTasks(this.field_70714_bg);
        this.clearTasks(this.field_70715_bh);
        NPCAttackSelector attackEntitySelector = new NPCAttackSelector(this);
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIClearTarget(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIClosestTarget(this, EntityLivingBase.class, 4, this.ai.directLOS, false, attackEntitySelector));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIOwnerHurtTarget(this));
        if (this.canFly()) {
            this.field_70765_h = new FlyingMoveHelper(this);
            this.field_70699_by = new PathNavigateFlying((EntityLiving)this, this.field_70170_p);
        } else {
            this.field_70765_h = new EntityMoveHelper((EntityLiving)this);
            this.field_70699_by = new PathNavigateGround((EntityLiving)this, this.field_70170_p);
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIWaterNav(this));
        }
        this.taskCount = 1;
        this.addRegularEntries();
        this.doorInteractType();
        this.seekShelter();
        this.setResponse();
        this.setMoveType();
    }

    private void setResponse() {
        this.aiRange = null;
        this.aiAttackTarget = null;
        if (this.ai.canSprint) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAISprintToTarget(this));
        }
        if (this.ai.onAttack == 1) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIPanic(this, 1.2f));
        } else if (this.ai.onAttack == 2) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIAvoidTarget(this));
        } else if (this.ai.onAttack == 0) {
            if (this.ai.canLeap) {
                this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIPounceTarget(this));
            }
            if (this.inventory.getProjectile() == null) {
                switch (this.ai.tacticalVariant) {
                    case 1: {
                        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIZigZagTarget(this, 1.3));
                        break;
                    }
                    case 2: {
                        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIOrbitTarget(this, 1.3, true));
                        break;
                    }
                    case 3: {
                        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIAvoidTarget(this));
                        break;
                    }
                    case 4: {
                        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIAmbushTarget(this, 1.2));
                        break;
                    }
                    case 5: {
                        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIStalkTarget(this));
                        break;
                    }
                }
            } else {
                switch (this.ai.tacticalVariant) {
                    case 1: {
                        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIDodgeShoot(this));
                        break;
                    }
                    case 2: {
                        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIOrbitTarget(this, 1.3, false));
                        break;
                    }
                    case 3: {
                        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIAvoidTarget(this));
                        break;
                    }
                    case 4: {
                        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIAmbushTarget(this, 1.3));
                        break;
                    }
                    case 5: {
                        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIStalkTarget(this));
                        break;
                    }
                }
            }
            this.aiAttackTarget = new EntityAIAttackTarget(this);
            this.field_70714_bg.func_75776_a(this.taskCount, this.aiAttackTarget);
            ((EntityAIAttackTarget)this.aiAttackTarget).navOverride(this.ai.tacticalVariant == 6);
            if (this.inventory.getProjectile() != null) {
                this.aiRange = new EntityAIRangedAttack(this);
                this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)this.aiRange);
                this.aiRange.navOverride(this.ai.tacticalVariant == 6);
            }
        } else if (this.ai.onAttack == 3) {
            // empty if block
        }
    }

    public boolean canFly() {
        return false;
    }

    public void setMoveType() {
        if (this.ai.getMovingType() == 1) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIWander(this));
        }
        if (this.ai.getMovingType() == 2) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIMovingPath(this));
        }
    }

    public void doorInteractType() {
        if (this.canFly()) {
            return;
        }
        Object aiDoor = null;
        if (this.ai.doorInteract == 1) {
            aiDoor = new EntityAIOpenDoor((EntityLiving)this, true);
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)aiDoor);
        } else if (this.ai.doorInteract == 0) {
            aiDoor = new EntityAIBustDoor((EntityLiving)this);
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)aiDoor);
        }
        if (this.func_70661_as() instanceof PathNavigateGround) {
            ((PathNavigateGround)this.func_70661_as()).func_179688_b(aiDoor != null);
        }
    }

    public void seekShelter() {
        if (this.ai.findShelter == 0) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIMoveIndoors(this));
        } else if (this.ai.findShelter == 1) {
            if (!this.canFly()) {
                this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
            }
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIFindShade(this));
        }
    }

    public void addRegularEntries() {
        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIReturn(this));
        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIFollow(this));
        if (this.ai.getStandingType() != 1 && this.ai.getStandingType() != 3) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIWatchClosest(this, EntityLivingBase.class, 5.0f));
        }
        this.lookAi = new EntityAILook(this);
        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)this.lookAi);
        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIWorldLines(this));
        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIJob(this));
        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAIRole(this));
        this.animateAi = new EntityAIAnimation(this);
        this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)this.animateAi);
        if (this.transform.isValid()) {
            this.field_70714_bg.func_75776_a(this.taskCount++, (EntityAIBase)new EntityAITransform(this));
        }
    }

    public float getSpeed() {
        return (float)this.ai.getWalkingSpeed() / 20.0f;
    }

    public float func_180484_a(BlockPos pos) {
        float weight = this.field_70170_p.func_175724_o(pos) - 0.5f;
        Block block = this.field_70170_p.func_180495_p(pos).func_177230_c();
        if (block.func_149662_c()) {
            weight += 10.0f;
        }
        return weight;
    }

    protected int func_70682_h(int par1) {
        if (!this.stats.canDrown) {
            return par1;
        }
        return super.func_70682_h(par1);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return this.stats.creatureType;
    }

    public int func_70627_aG() {
        return 160;
    }

    protected String func_70639_aQ() {
        if (!this.func_70089_S()) {
            return null;
        }
        return this.advanced.getSound(this.func_70638_az() != null ? 1 : 0);
    }

    public String func_70621_aR() {
        return this.advanced.getSound(2);
    }

    public String func_70673_aS() {
        return this.advanced.getSound(3);
    }

    protected float func_70647_i() {
        if (this.advanced.disablePitch) {
            return 1.0f;
        }
        return super.func_70647_i();
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        String sound = this.advanced.getSound(4);
        if (sound != null) {
            this.func_85030_a(sound, 0.15f, 1.0f);
        } else {
            super.func_180429_a(pos, block);
        }
    }

    public EntityPlayerMP getFakePlayer() {
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        if (chateventPlayer == null) {
            chateventPlayer = new FakePlayer((WorldServer)this.field_70170_p, (GameProfile)chateventProfile);
        }
        EntityUtil.Copy((EntityLivingBase)this, (EntityLivingBase)chateventPlayer);
        EntityNPCInterface.chateventProfile.npc = this;
        chateventPlayer.refreshDisplayName();
        return chateventPlayer;
    }

    public void saySurrounding(Line line) {
        if (line == null || line.text == null) {
            return;
        }
        ServerChatEvent event = new ServerChatEvent(this.getFakePlayer(), line.text, new ChatComponentTranslation(line.text.replace("%", "%%"), new Object[0]));
        if (MinecraftForge.EVENT_BUS.post((Event)event) || event.component == null) {
            return;
        }
        line.text = event.component.func_150260_c().replace("%%", "%");
        List inRange = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(20.0, 20.0, 20.0));
        for (EntityPlayer player : inRange) {
            this.say(player, line);
        }
    }

    public void say(EntityPlayer player, Line line) {
        if (line == null || !this.canSee((Entity)player) || line.text == null) {
            return;
        }
        if (!line.sound.isEmpty()) {
            Server.sendData((EntityPlayerMP)player, EnumPacketClient.PLAY_SOUND, line.sound, Float.valueOf((float)this.field_70165_t), Float.valueOf((float)this.field_70163_u), Float.valueOf((float)this.field_70161_v));
        }
        Server.sendData((EntityPlayerMP)player, EnumPacketClient.CHATBUBBLE, this.func_145782_y(), line.text, !line.hideText);
    }

    public boolean func_94059_bO() {
        return true;
    }

    public void func_70024_g(double d, double d1, double d2) {
        if (this.isWalking() && !this.isKilled()) {
            super.func_70024_g(d, d1, d2);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.npcVersion = compound.func_74762_e("ModRev");
        VersionCompatibility.CheckNpcCompatibility(this, compound);
        this.display.readToNBT(compound);
        this.stats.readToNBT(compound);
        this.ai.readToNBT(compound);
        this.script.readFromNBT(compound);
        this.timers.readFromNBT(compound);
        this.advanced.readToNBT(compound);
        if (this.advanced.role != 0 && this.roleInterface != null) {
            this.roleInterface.readFromNBT(compound);
        }
        if (this.advanced.job != 0 && this.jobInterface != null) {
            this.jobInterface.readFromNBT(compound);
        }
        this.inventory.readEntityFromNBT(compound);
        this.transform.readToNBT(compound);
        this.killedtime = compound.func_74763_f("KilledTime");
        this.totalTicksAlive = compound.func_74763_f("TotalTicksAlive");
        this.linkedName = compound.func_74779_i("LinkedNpcName");
        if (!this.isRemote()) {
            LinkedNpcController.Instance.loadNpcData(this);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)CustomNpcs.NpcNavRange);
        this.updateAI = true;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        this.display.writeToNBT(compound);
        this.stats.writeToNBT(compound);
        this.ai.writeToNBT(compound);
        this.script.writeToNBT(compound);
        this.timers.writeToNBT(compound);
        this.advanced.writeToNBT(compound);
        if (this.advanced.role != 0 && this.roleInterface != null) {
            this.roleInterface.writeToNBT(compound);
        }
        if (this.advanced.job != 0 && this.jobInterface != null) {
            this.jobInterface.writeToNBT(compound);
        }
        this.inventory.writeEntityToNBT(compound);
        this.transform.writeToNBT(compound);
        compound.func_74772_a("KilledTime", this.killedtime);
        compound.func_74772_a("TotalTicksAlive", this.totalTicksAlive);
        compound.func_74768_a("ModRev", this.npcVersion);
        compound.func_74778_a("LinkedNpcName", this.linkedName);
    }

    public void updateHitbox() {
        if (this.currentAnimation == 2 || this.currentAnimation == 7) {
            this.field_70130_N = 0.8f;
            this.field_70131_O = 0.4f;
        } else if (this.func_70115_ae()) {
            this.field_70130_N = 0.6f;
            this.field_70131_O = this.baseHeight * 0.77f;
        } else {
            this.field_70130_N = 0.6f;
            this.field_70131_O = this.baseHeight;
        }
        this.field_70130_N = this.field_70130_N / 5.0f * (float)this.display.getSize();
        this.field_70131_O = this.field_70131_O / 5.0f * (float)this.display.getSize();
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void func_70609_aI() {
        if (this.stats.spawnCycle == 3) {
            super.func_70609_aI();
            return;
        }
        ++this.field_70725_aQ;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.hasDied) {
            this.func_70106_y();
        }
        if (this.killedtime < System.currentTimeMillis() && (this.stats.spawnCycle == 0 || this.field_70170_p.func_72935_r() && this.stats.spawnCycle == 1 || !this.field_70170_p.func_72935_r() && this.stats.spawnCycle == 2)) {
            this.reset();
        }
    }

    public void reset() {
        this.hasDied = false;
        this.field_70128_L = false;
        this.wasKilled = false;
        this.func_70031_b(false);
        this.func_70606_j(this.func_110138_aP());
        this.field_70180_af.func_75692_b(14, (Object)0);
        this.field_70180_af.func_75692_b(25, (Object)0);
        this.func_70624_b(null);
        this.func_70604_c(null);
        this.field_70725_aQ = 0;
        if (this.ai.returnToStart && !this.hasOwner() && !this.isRemote()) {
            this.func_70012_b(this.getStartXPos(), this.getStartYPos(), this.getStartZPos(), this.field_70177_z, this.field_70125_A);
        }
        this.killedtime = 0L;
        this.func_70066_B();
        this.func_70674_bp();
        this.func_70612_e(0.0f, 0.0f);
        this.field_70140_Q = 0.0f;
        this.func_70661_as().func_75499_g();
        this.currentAnimation = 0;
        this.updateHitbox();
        this.updateAI = true;
        this.ai.movingPos = 0;
        if (this.getOwner() != null) {
            this.getOwner().func_130011_c(null);
        }
        if (this.jobInterface != null) {
            this.jobInterface.reset();
        }
        EventHooks.onNPCInit(this);
    }

    public void onCollide() {
        if (!this.func_70089_S() || this.field_70173_aa % 4 != 0 || this.field_70170_p.field_72995_K) {
            return;
        }
        AxisAlignedBB axisalignedbb = null;
        axisalignedbb = this.field_70154_o != null && this.field_70154_o.func_70089_S() ? this.func_174813_aQ().func_111270_a(this.field_70154_o.func_174813_aQ()).func_72314_b(1.0, 0.0, 1.0) : this.func_174813_aQ().func_72314_b(1.0, 0.5, 1.0);
        List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == this || !entity.func_70089_S()) continue;
            EventHooks.onNPCCollide(this, entity);
        }
    }

    public void func_181015_d(BlockPos pos) {
    }

    public void cloakUpdate() {
        this.field_20066_r = this.field_20063_u;
        this.field_20065_s = this.field_20062_v;
        this.field_20064_t = this.field_20061_w;
        double d = this.field_70165_t - this.field_20063_u;
        double d1 = this.field_70163_u - this.field_20062_v;
        double d2 = this.field_70161_v - this.field_20061_w;
        double d3 = 10.0;
        if (d > d3) {
            this.field_20066_r = this.field_20063_u = this.field_70165_t;
        }
        if (d2 > d3) {
            this.field_20064_t = this.field_20061_w = this.field_70161_v;
        }
        if (d1 > d3) {
            this.field_20065_s = this.field_20062_v = this.field_70163_u;
        }
        if (d < -d3) {
            this.field_20066_r = this.field_20063_u = this.field_70165_t;
        }
        if (d2 < -d3) {
            this.field_20064_t = this.field_20061_w = this.field_70161_v;
        }
        if (d1 < -d3) {
            this.field_20065_s = this.field_20062_v = this.field_70163_u;
        }
        this.field_20063_u += d * 0.25;
        this.field_20061_w += d2 * 0.25;
        this.field_20062_v += d1 * 0.25;
    }

    protected boolean func_70692_ba() {
        return this.stats.spawnCycle == 4;
    }

    public ItemStack func_70694_bm() {
        if (this.inventory.renderOffhand != null) {
            return this.inventory.renderOffhand;
        }
        IItemStack item = null;
        item = this.isAttacking() ? this.inventory.getRightHand() : (this.advanced.role == 6 ? ((RoleCompanion)this.roleInterface).getHeldItem() : (this.jobInterface != null && this.jobInterface.overrideMainHand ? this.jobInterface.getMainhand() : this.inventory.getRightHand()));
        return ItemStackWrapper.MCItem(item);
    }

    public ItemStack func_71124_b(int slot) {
        if (slot == 0) {
            return ItemStackWrapper.MCItem(this.inventory.weapons.get(0));
        }
        return ItemStackWrapper.MCItem(this.inventory.getArmor(4 - slot));
    }

    public ItemStack func_82169_q(int slot) {
        return ItemStackWrapper.MCItem(this.inventory.getArmor(3 - slot));
    }

    public void func_70062_b(int slot, ItemStack item) {
        if (slot == 0) {
            this.inventory.weapons.put(0, item == null ? null : new ItemStackWrapper(item));
        } else {
            this.inventory.armor.put(4 - slot, item == null ? null : new ItemStackWrapper(item));
        }
    }

    public ItemStack[] func_70035_c() {
        ItemStack[] inv = new ItemStack[5];
        for (int i = 0; i < 5; ++i) {
            inv[i] = this.func_71124_b(i);
        }
        return inv;
    }

    protected void func_82160_b(boolean p_82160_1_, int p_82160_2_) {
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
    }

    public ItemStack getOffHand() {
        IItemStack item = null;
        item = this.isAttacking() ? this.inventory.getLeftHand() : (this.jobInterface != null && this.jobInterface.overrideOffHand ? this.jobInterface.getOffhand() : this.inventory.getLeftHand());
        return ItemStackWrapper.MCItem(item);
    }

    public void func_70645_a(DamageSource damagesource) {
        this.func_70031_b(false);
        this.func_70661_as().func_75499_g();
        this.func_70066_B();
        this.func_70674_bp();
        if (!this.isRemote()) {
            Entity attackingEntity = damagesource.func_76364_f();
            if (attackingEntity instanceof EntityArrow && ((EntityArrow)attackingEntity).field_70250_c instanceof EntityLivingBase) {
                attackingEntity = (EntityLivingBase)((EntityArrow)attackingEntity).field_70250_c;
            } else if (attackingEntity instanceof EntityThrowable) {
                attackingEntity = ((EntityThrowable)attackingEntity).func_85052_h();
            }
            if (EventHooks.onNPCDied(this, attackingEntity, damagesource)) {
                return;
            }
            this.inventory.dropStuff(attackingEntity, damagesource);
            Line line = this.advanced.getKilledLine();
            if (line != null) {
                this.saySurrounding(line.formatTarget(attackingEntity instanceof EntityLivingBase ? (EntityLivingBase)attackingEntity : null));
            }
        }
        super.func_70645_a(damagesource);
    }

    public void func_70106_y() {
        this.hasDied = true;
        if (this.field_70170_p.field_72995_K || this.stats.spawnCycle == 3) {
            this.func_70656_aK();
            this.delete();
        } else {
            if (this.field_70153_n != null) {
                this.field_70153_n.func_70078_a(null);
            }
            if (this.field_70154_o != null) {
                this.func_70078_a(null);
            }
            this.func_70606_j(-1.0f);
            this.func_70031_b(false);
            this.func_70661_as().func_75499_g();
            this.setCurrentAnimation(2);
            this.updateHitbox();
            if (this.killedtime <= 0L) {
                this.killedtime = (long)(this.stats.respawnTime * 1000) + System.currentTimeMillis();
            }
            if (this.advanced.role != 0 && this.roleInterface != null) {
                this.roleInterface.killed();
            }
            if (this.advanced.job != 0 && this.jobInterface != null) {
                this.jobInterface.killed();
            }
        }
    }

    public void delete() {
        if (this.advanced.role != 0 && this.roleInterface != null) {
            this.roleInterface.delete();
        }
        if (this.advanced.job != 0 && this.jobInterface != null) {
            this.jobInterface.delete();
        }
        super.func_70106_y();
    }

    public float getStartXPos() {
        return (float)this.ai.startPos().func_177958_n() + this.ai.bodyOffsetX / 10.0f;
    }

    public float getStartZPos() {
        return (float)this.ai.startPos().func_177952_p() + this.ai.bodyOffsetZ / 10.0f;
    }

    public boolean isVeryNearAssignedPlace() {
        double xx = this.field_70165_t - (double)this.getStartXPos();
        double zz = this.field_70161_v - (double)this.getStartZPos();
        if (xx < -0.2 || xx > 0.2) {
            return false;
        }
        return !(zz < -0.2) && !(zz > 0.2);
    }

    public double getStartYPos() {
        if (this.startYPos < 0.0) {
            return this.calculateStartYPos(this.ai.startPos());
        }
        return this.startYPos;
    }

    private double calculateStartYPos(BlockPos pos) {
        while (pos.func_177956_o() > 0) {
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            AxisAlignedBB bb = state.func_177230_c().func_180640_a(this.field_70170_p, pos, state);
            if (bb != null) {
                return bb.field_72337_e;
            }
            pos = pos.func_177977_b();
        }
        return 0.0;
    }

    private BlockPos calculateTopPos(BlockPos pos) {
        BlockPos check = pos;
        while (check.func_177956_o() > 0) {
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            AxisAlignedBB bb = state.func_177230_c().func_180640_a(this.field_70170_p, pos, state);
            if (bb != null) {
                return check;
            }
            check = check.func_177977_b();
        }
        return pos;
    }

    public boolean isInRange(Entity entity, double range) {
        return this.isInRange(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, range);
    }

    public boolean isInRange(double posX, double posY, double posZ, double range) {
        double x = this.field_70165_t - posX;
        double y = this.field_70163_u - posY;
        double z = this.field_70161_v - posZ;
        if (x < 0.0) {
            x = -x;
        }
        if (z < 0.0) {
            z = -z;
        }
        if (y < 0.0) {
            y = -y;
        }
        if (posY >= 0.0 && y > range) {
            return false;
        }
        return x <= range && z <= range;
    }

    public void givePlayerItem(EntityPlayer player, ItemStack item) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        item = item.func_77946_l();
        float f = 0.7f;
        double d = (double)(this.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f);
        double d1 = (double)(this.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f);
        double d2 = (double)(this.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f);
        EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + d, this.field_70163_u + d1, this.field_70161_v + d2, item);
        entityitem.func_174867_a(2);
        this.field_70170_p.func_72838_d((Entity)entityitem);
        int i = item.field_77994_a;
        if (player.field_71071_by.func_70441_a(item)) {
            this.field_70170_p.func_72956_a((Entity)entityitem, "random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.func_71001_a((Entity)entityitem, i);
            if (item.field_77994_a <= 0) {
                entityitem.func_70106_y();
            }
        }
    }

    public boolean func_70608_bn() {
        return this.currentAnimation == 2 && !this.isAttacking();
    }

    public boolean func_70115_ae() {
        return this.currentAnimation == 1 && !this.isAttacking() || this.field_70154_o != null;
    }

    public boolean isWalking() {
        return this.ai.getMovingType() != 0 || this.isAttacking() || this.isFollower() || this.getBoolFlag(1);
    }

    public void setBoolFlag(boolean bo, int id) {
        int i = this.field_70180_af.func_75679_c(25);
        if (bo && (i & id) == 0) {
            this.field_70180_af.func_75692_b(25, (Object)(i | id));
        }
        if (!bo && (i & id) != 0) {
            this.field_70180_af.func_75692_b(25, (Object)(i - id));
        }
    }

    public boolean getBoolFlag(int id) {
        return (this.field_70180_af.func_75679_c(25) & id) != 0;
    }

    public boolean func_70093_af() {
        return this.currentAnimation == 4;
    }

    public void func_70653_a(Entity par1Entity, float par2, double par3, double par5) {
        if (this.stats.resistances.knockback >= 2.0f) {
            return;
        }
        this.field_70160_al = true;
        float f1 = MathHelper.func_76133_a((double)(par3 * par3 + par5 * par5));
        float f2 = 0.5f * (2.0f - this.stats.resistances.knockback);
        this.field_70159_w /= 2.0;
        this.field_70181_x /= 2.0;
        this.field_70179_y /= 2.0;
        this.field_70159_w -= par3 / (double)f1 * (double)f2;
        this.field_70181_x += 0.2 + (double)(f2 / 2.0f);
        this.field_70179_y -= par5 / (double)f1 * (double)f2;
        if (this.field_70181_x > (double)0.4f) {
            this.field_70181_x = 0.4f;
        }
    }

    public Faction getFaction() {
        String[] split = this.field_70180_af.func_75681_e(13).split(":");
        int faction = 0;
        if (this.field_70170_p == null || split.length <= 1 && this.field_70170_p.field_72995_K) {
            return new Faction();
        }
        if (split.length > 1) {
            faction = Integer.parseInt(split[0]);
        }
        if (this.field_70170_p.field_72995_K) {
            Faction fac = new Faction();
            fac.id = faction;
            fac.color = Integer.parseInt(split[1]);
            fac.name = split[2];
            return fac;
        }
        Faction fac = FactionController.getInstance().getFaction(faction);
        if (fac == null) {
            faction = FactionController.getInstance().getFirstFactionId();
            fac = FactionController.getInstance().getFaction(faction);
        }
        return fac;
    }

    public boolean isRemote() {
        return this.field_70170_p == null || this.field_70170_p.field_72995_K;
    }

    public void setFaction(int integer) {
        if (integer < 0 || this.isRemote()) {
            return;
        }
        Faction faction = FactionController.getInstance().getFaction(integer);
        if (faction == null) {
            return;
        }
        String str = faction.id + ":" + faction.color + ":" + faction.name;
        if (str.length() > 64) {
            str = str.substring(0, 64);
        }
        this.field_70180_af.func_75692_b(13, (Object)str);
    }

    public boolean func_70687_e(PotionEffect effect) {
        if (this.stats.potionImmune) {
            return false;
        }
        if (this.func_70668_bt() == EnumCreatureAttribute.ARTHROPOD && effect.func_76456_a() == Potion.field_76436_u.field_76415_H) {
            return false;
        }
        return super.func_70687_e(effect);
    }

    public boolean isAttacking() {
        return this.getBoolFlag(4);
    }

    public boolean isKilled() {
        return this.getBoolFlag(8) || this.field_70128_L;
    }

    public void writeSpawnData(ByteBuf buffer) {
        try {
            Server.writeNBT(buffer, this.writeSpawnData());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public NBTTagCompound writeSpawnData() {
        NBTTagCompound bard;
        NBTTagCompound compound = new NBTTagCompound();
        this.display.writeToNBT(compound);
        compound.func_74768_a("MaxHealth", this.stats.maxHealth);
        compound.func_74782_a("Armor", (NBTBase)NBTTags.nbtIItemStackMap(this.inventory.armor));
        compound.func_74782_a("Weapons", (NBTBase)NBTTags.nbtIItemStackMap(this.inventory.weapons));
        compound.func_74768_a("Speed", this.ai.getWalkingSpeed());
        compound.func_74757_a("DeadBody", this.stats.hideKilledBody);
        compound.func_74768_a("StandingState", this.ai.getStandingType());
        compound.func_74768_a("MovingState", this.ai.getMovingType());
        compound.func_74768_a("Orientation", this.ai.orientation);
        compound.func_74768_a("Role", this.advanced.role);
        compound.func_74768_a("Job", this.advanced.job);
        if (this.advanced.job == 1) {
            bard = new NBTTagCompound();
            this.jobInterface.writeToNBT(bard);
            compound.func_74782_a("Bard", (NBTBase)bard);
        }
        if (this.advanced.job == 9) {
            bard = new NBTTagCompound();
            this.jobInterface.writeToNBT(bard);
            compound.func_74782_a("Puppet", (NBTBase)bard);
        }
        if (this.advanced.role == 6) {
            bard = new NBTTagCompound();
            this.roleInterface.writeToNBT(bard);
            compound.func_74782_a("Companion", (NBTBase)bard);
        }
        if (this instanceof EntityCustomNpc) {
            compound.func_74782_a("ModelData", (NBTBase)((EntityCustomNpc)this).modelData.writeToNBT());
        }
        return compound;
    }

    public void readSpawnData(ByteBuf buf) {
        try {
            this.readSpawnData(Server.readNBT(buf));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void readSpawnData(NBTTagCompound compound) {
        NBTTagCompound puppet;
        this.stats.maxHealth = compound.func_74762_e("MaxHealth");
        this.ai.setWalkingSpeed(compound.func_74762_e("Speed"));
        this.stats.hideKilledBody = compound.func_74767_n("DeadBody");
        this.ai.setStandingType(compound.func_74762_e("StandingState"));
        this.ai.setMovingType(compound.func_74762_e("MovingState"));
        this.ai.orientation = compound.func_74762_e("Orientation");
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.stats.maxHealth);
        this.inventory.armor = NBTTags.getIItemStackMap(compound.func_150295_c("Armor", 10));
        this.inventory.weapons = NBTTags.getIItemStackMap(compound.func_150295_c("Weapons", 10));
        this.advanced.setRole(compound.func_74762_e("Role"));
        this.advanced.setJob(compound.func_74762_e("Job"));
        if (this.advanced.job == 1) {
            NBTTagCompound bard = compound.func_74775_l("Bard");
            this.jobInterface.readFromNBT(bard);
        }
        if (this.advanced.job == 9) {
            puppet = compound.func_74775_l("Puppet");
            this.jobInterface.readFromNBT(puppet);
        }
        if (this.advanced.role == 6) {
            puppet = compound.func_74775_l("Companion");
            this.roleInterface.readFromNBT(puppet);
        }
        if (this instanceof EntityCustomNpc) {
            ((EntityCustomNpc)this).modelData.readFromNBT(compound.func_74775_l("ModelData"));
        }
        this.display.readToNBT(compound);
    }

    public String func_70005_c_() {
        return this.display.getName();
    }

    public boolean func_70003_b(int var1, String var2) {
        if (CustomNpcs.NpcUseOpCommands) {
            return true;
        }
        return var1 <= 2;
    }

    public BlockPos func_180425_c() {
        return new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public Vec3 func_174791_d() {
        return new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public boolean func_70686_a(Class par1Class) {
        return EntityBat.class != par1Class;
    }

    public void setImmuneToFire(boolean immuneToFire) {
        this.field_70178_ae = immuneToFire;
        this.stats.immuneToFire = immuneToFire;
    }

    public void func_180430_e(float distance, float modifier) {
        if (!this.stats.noFallDamage) {
            super.func_180430_e(distance, modifier);
        }
    }

    public void func_70110_aj() {
        if (!this.stats.ignoreCobweb) {
            super.func_70110_aj();
        }
    }

    public boolean func_70067_L() {
        return !this.isKilled();
    }

    public EntityAIRangedAttack getRangedTask() {
        return this.aiRange;
    }

    public String getRoleDataWatcher() {
        return this.field_70180_af.func_75681_e(16);
    }

    public void setRoleDataWatcher(String s) {
        this.field_70180_af.func_75692_b(16, (Object)s);
    }

    public World func_130014_f_() {
        return this.field_70170_p;
    }

    public boolean func_98034_c(EntityPlayer player) {
        return this.display.getVisible() == 1 && (player.func_70694_bm() == null || player.func_70694_bm().func_77973_b() != CustomItems.wand);
    }

    public boolean func_82150_aj() {
        return this.display.getVisible() != 0;
    }

    public void func_145747_a(IChatComponent var1) {
    }

    public void setCurrentAnimation(int animation) {
        this.currentAnimation = animation;
        this.field_70180_af.func_75692_b(14, (Object)animation);
    }

    public boolean canSee(Entity entity) {
        return this.func_70635_at().func_75522_a(entity);
    }

    public boolean isFollower() {
        if (this.advanced.scenes.getOwner() != null) {
            return true;
        }
        return this.advanced.role == 2 && ((RoleFollower)this.roleInterface).isFollowing() || this.advanced.role == 6 && ((RoleCompanion)this.roleInterface).isFollowing() || this.advanced.job == 5 && ((JobFollower)this.jobInterface).isFollowing();
    }

    public EntityLivingBase getOwner() {
        if (this.advanced.scenes.getOwner() != null) {
            return this.advanced.scenes.getOwner();
        }
        if (this.advanced.role == 2 && this.roleInterface instanceof RoleFollower) {
            return ((RoleFollower)this.roleInterface).owner;
        }
        if (this.advanced.role == 6 && this.roleInterface instanceof RoleCompanion) {
            return ((RoleCompanion)this.roleInterface).owner;
        }
        if (this.advanced.job == 5 && this.jobInterface instanceof JobFollower) {
            return ((JobFollower)this.jobInterface).following;
        }
        return null;
    }

    public boolean hasOwner() {
        if (this.advanced.scenes.getOwner() != null) {
            return true;
        }
        return this.advanced.role == 2 && ((RoleFollower)this.roleInterface).hasOwner() || this.advanced.role == 6 && ((RoleCompanion)this.roleInterface).hasOwner() || this.advanced.job == 5 && ((JobFollower)this.jobInterface).hasOwner();
    }

    public int followRange() {
        if (this.advanced.scenes.getOwner() != null) {
            return 4;
        }
        if (this.advanced.role == 2 && ((RoleFollower)this.roleInterface).isFollowing()) {
            return 6;
        }
        if (this.advanced.role == 6 && ((RoleCompanion)this.roleInterface).isFollowing()) {
            return 4;
        }
        if (this.advanced.job == 5 && ((JobFollower)this.jobInterface).isFollowing()) {
            return 4;
        }
        return 15;
    }

    public void func_175449_a(BlockPos pos, int range) {
        super.func_175449_a(pos, range);
        this.ai.setStartPos(pos);
    }

    protected float func_70655_b(DamageSource source, float damage) {
        if (this.advanced.role == 6) {
            damage = ((RoleCompanion)this.roleInterface).applyArmorCalculations(source, damage);
        }
        return damage;
    }

    public boolean func_142014_c(EntityLivingBase entity) {
        if (!this.isRemote()) {
            if (entity instanceof EntityPlayer && this.getFaction().isFriendlyToPlayer((EntityPlayer)entity)) {
                return true;
            }
            if (entity == this.getOwner()) {
                return true;
            }
            if (entity instanceof EntityNPCInterface && ((EntityNPCInterface)entity).faction.id == this.faction.id) {
                return true;
            }
        }
        return super.func_142014_c(entity);
    }

    public void setDataWatcher(DataWatcher dataWatcher) {
        this.field_70180_af = dataWatcher;
    }

    public void func_70612_e(float p_70612_1_, float p_70612_2_) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        super.func_70612_e(p_70612_1_, p_70612_2_);
        if (this.advanced.role == 6 && !this.isRemote()) {
            ((RoleCompanion)this.roleInterface).addMovementStat(this.field_70165_t - d0, this.field_70163_u - d1, this.field_70161_v - d2);
        }
    }

    public boolean func_110164_bC() {
        return false;
    }

    public boolean func_110167_bD() {
        return false;
    }

    public boolean nearPosition(BlockPos pos) {
        BlockPos npcpos = this.func_180425_c();
        float x = npcpos.func_177958_n() - pos.func_177958_n();
        float z = npcpos.func_177952_p() - pos.func_177952_p();
        float y = npcpos.func_177956_o() - pos.func_177956_o();
        float height = MathHelper.func_76143_f((double)(this.field_70131_O + 1.0f)) * MathHelper.func_76143_f((double)(this.field_70131_O + 1.0f));
        return (double)(x * x + z * z) < 2.5 && (double)(y * y) < (double)height + 2.5;
    }

    public void tpTo(EntityLivingBase owner) {
        if (owner == null) {
            return;
        }
        EnumFacing facing = owner.func_174811_aO().func_176734_d();
        BlockPos pos = new BlockPos(owner.field_70165_t, owner.func_174813_aQ().field_72338_b, owner.field_70161_v);
        pos = pos.func_177982_a(facing.func_82601_c(), 0, facing.func_82599_e());
        pos = this.calculateTopPos(pos);
        block0: for (int i = -1; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                BlockPos check = facing.func_82601_c() == 0 ? pos.func_177982_a(i, 0, j * facing.func_82599_e()) : pos.func_177982_a(j * facing.func_82601_c(), 0, i);
                if (this.field_70170_p.func_180495_p(check = this.calculateTopPos(check)).func_177230_c().func_149730_j() || this.field_70170_p.func_180495_p(check.func_177984_a()).func_177230_c().func_149730_j()) continue;
                this.func_70012_b((float)check.func_177958_n() + 0.5f, check.func_177956_o(), (float)check.func_177952_p() + 0.5f, this.field_70177_z, this.field_70125_A);
                this.func_70661_as().func_75499_g();
                continue block0;
            }
        }
    }
}

