/*
 * Decompiled with CFR 0.152.
 */
package foxz.command;

import foxz.commandhelper.ChMcLogger;
import foxz.commandhelper.annotations.Command;
import foxz.commandhelper.annotations.SubCommand;
import foxz.commandhelper.permissions.OpOnly;
import foxz.commandhelper.permissions.ParamCheck;
import foxz.utils.Utils;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import noppes.npcs.Schematic;
import noppes.npcs.controllers.SchematicController;

@Command(name="schema", desc="Schematic operation")
public class CmdSchematics
extends ChMcLogger {
    public CmdSchematics(Object sender) {
        super(sender);
    }

    @SubCommand(desc="Build the schematic", usage="<name> [rotation] [[world:]x,y,z]]", permissions={OpOnly.class, ParamCheck.class})
    public void build(String[] args) {
        String name = args[0];
        Schematic schem = SchematicController.Instance.load(name);
        if (schem == null) {
            this.sendMessage("Unknown schematic: " + name);
            return;
        }
        this.sendMessage("width: " + schem.width + ", length: " + schem.length + ", height: " + schem.height);
        BlockPos pos = this.pcParam.func_180425_c();
        World world = this.pcParam.func_130014_f_();
        int rotation = 0;
        if (args.length > 1) {
            try {
                rotation = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (args.length > 2) {
            String[] par;
            String location = args[2];
            if (location.contains(":")) {
                par = location.split(":");
                location = par[1];
                world = Utils.getWorld(par[0]);
                if (world == null) {
                    this.sendMessage(String.format("'%s' is an unknown world", par[0]));
                    return;
                }
            }
            if (location.contains(",")) {
                par = location.split(",");
                if (par.length != 3) {
                    this.sendMessage("Location need be x,y,z");
                    return;
                }
                try {
                    pos = CommandBase.func_175757_a((ICommandSender)this.pcParam, (String[])par, (int)0, (boolean)false);
                }
                catch (NumberInvalidException e) {
                    this.sendMessage("Location should be in numbers");
                    return;
                }
            }
        }
        if (pos.func_177958_n() == 0 && pos.func_177956_o() == 0 && pos.func_177952_p() == 0) {
            this.sendMessage("Location needed");
            return;
        }
        schem.init(pos, world, rotation);
        SchematicController.Instance.build(schem, this.pcParam);
    }

    @SubCommand(desc="Stops the current build", permissions={OpOnly.class})
    public void stop(String[] args) {
        SchematicController.Instance.stop(this.pcParam);
    }

    @SubCommand(desc="Gives info about the current build", permissions={OpOnly.class})
    public void info(String[] args) {
        SchematicController.Instance.info(this.pcParam);
    }

    @SubCommand(desc="Lists available schematics", permissions={OpOnly.class})
    public void list(String[] args) {
        List<String> list = SchematicController.Instance.list();
        if (list.isEmpty()) {
            this.sendMessage("No available schematics");
            return;
        }
        String s = "";
        for (String file : list) {
            s = s + file + ", ";
        }
        this.sendMessage(s);
    }

    @Override
    public List addTabCompletion(ICommandSender par1, String[] args) {
        if (args[0].equalsIgnoreCase("build") && args.length == 2) {
            List<String> list = SchematicController.Instance.list();
            return CommandBase.func_71530_a((String[])args, (String[])list.toArray(new String[list.size()]));
        }
        return super.addTabCompletion(par1, args);
    }
}

