/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringUtils;
import noppes.npcs.api.entity.data.INPCDisplay;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.ValueUtil;

public class DataDisplay
implements INPCDisplay {
    EntityNPCInterface npc;
    private String name;
    private String title = "";
    public byte skinType = 0;
    private String url = "";
    public GameProfile playerProfile;
    private String texture = "customnpcs:textures/entity/humanmale/Steve.png";
    private String cloakTexture = "";
    private String glowTexture = "";
    private int visible = 0;
    private int modelSize = 5;
    private int showName = 0;
    private int skinColor = 0xFFFFFF;
    private boolean disableLivingAnimation = false;
    private byte showBossBar = 0;

    public DataDisplay(EntityNPCInterface npc) {
        this.npc = npc;
        String[] names = new String[]{"Noppes", "Noppes", "Noppes", "Noppes", "Atesson", "Rothcersul", "Achdranys", "Pegato", "Chald", "Gareld", "Nalworche", "Ineald", "Tia'kim", "Torerod", "Turturdar", "Ranler", "Dyntan", "Oldrake", "Gharis", "Elmn", "Tanal", "Waran-ess", "Ach-aldhat", "Athi", "Itageray", "Tasr", "Ightech", "Gakih", "Adkal", "Qua'an", "Sieq", "Urnp", "Rods", "Vorbani", "Smaik", "Fian", "Hir", "Ristai", "Kineth", "Naif", "Issraya", "Arisotura", "Honf", "Rilfom", "Estz", "Ghatroth", "Yosil", "Darage", "Aldny", "Tyltran", "Armos", "Loxiku", "Burhat", "Tinlt", "Ightyd", "Mia", "Ken", "Karla", "Lily", "Carina", "Daniel", "Slater", "Zidane", "Valentine", "Eirina", "Carnow", "Grave", "Shadow", "Drakken", "Kaoz", "Silk", "Drake", "Oldam", "Lynxx", "Lenyx", "Winter", "Seth", "Apolitho", "Amethyst", "Ankin", "Seinkan", "Ayumu", "Sakamoto", "Divina", "Div", "Magia", "Magnus", "Tiakono", "Ruin", "Hailinx", "Ethan", "Wate", "Carter", "William", "Brion", "Sparrow", "Basrrelen", "Gyaku", "Claire", "Crowfeather", "Blackwell", "Raven", "Farcri", "Lucas", "Bangheart", "Kamoku", "Kyoukan", "Blaze", "Benjamin", "Larianne", "Kakaragon", "Melancholy", "Epodyno", "Thanato", "Mika", "Dacks", "Ylander", "Neve", "Meadow", "Cuero", "Embrera", "Eldamore", "Faolan", "Chim", "Nasu", "Kathrine", "Ariel", "Arei", "Demytrix", "Kora", "Ava", "Larson", "Leonardo", "Wyrl", "Sakiama", "Lambton", "Kederath", "Malus", "Riplette", "Andern", "Ezall", "Lucien", "Droco", "Cray", "Tymen", "Zenix", "Entranger", "Saenorath", "Chris", "Christine", "Marble", "Mable", "Ross", "Rose", "Xalgan ", "Kennet"};
        this.name = names[new Random().nextInt(names.length)];
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74778_a("Name", this.name);
        nbttagcompound.func_74778_a("Title", this.title);
        nbttagcompound.func_74778_a("SkinUrl", this.url);
        nbttagcompound.func_74778_a("Texture", this.texture);
        nbttagcompound.func_74778_a("CloakTexture", this.cloakTexture);
        nbttagcompound.func_74778_a("GlowTexture", this.glowTexture);
        nbttagcompound.func_74774_a("UsingSkinUrl", this.skinType);
        if (this.playerProfile != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            NBTUtil.func_180708_a((NBTTagCompound)nbttagcompound1, (GameProfile)this.playerProfile);
            nbttagcompound.func_74782_a("SkinUsername", (NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74768_a("Size", this.modelSize);
        nbttagcompound.func_74768_a("ShowName", this.showName);
        nbttagcompound.func_74768_a("SkinColor", this.skinColor);
        nbttagcompound.func_74768_a("NpcVisible", this.visible);
        nbttagcompound.func_74757_a("NoLivingAnimation", this.disableLivingAnimation);
        nbttagcompound.func_74774_a("BossBar", this.showBossBar);
        return nbttagcompound;
    }

    public void readToNBT(NBTTagCompound nbttagcompound) {
        this.name = nbttagcompound.func_74779_i("Name");
        this.title = nbttagcompound.func_74779_i("Title");
        this.url = nbttagcompound.func_74779_i("SkinUrl");
        byte prevSkinType = this.skinType;
        String prevTexture = this.texture;
        this.skinType = nbttagcompound.func_74771_c("UsingSkinUrl");
        this.texture = nbttagcompound.func_74779_i("Texture");
        this.cloakTexture = nbttagcompound.func_74779_i("CloakTexture");
        this.glowTexture = nbttagcompound.func_74779_i("GlowTexture");
        this.playerProfile = null;
        if (this.skinType == 1) {
            if (nbttagcompound.func_150297_b("SkinUsername", 10)) {
                this.playerProfile = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.func_74775_l("SkinUsername"));
            } else if (nbttagcompound.func_150297_b("SkinUsername", 8) && !StringUtils.func_151246_b((String)nbttagcompound.func_74779_i("SkinUsername"))) {
                this.playerProfile = new GameProfile(null, nbttagcompound.func_74779_i("SkinUsername"));
            }
            this.loadProfile();
        }
        this.modelSize = ValueUtil.CorrectInt(nbttagcompound.func_74762_e("Size"), 1, 30);
        this.showName = nbttagcompound.func_74762_e("ShowName");
        if (nbttagcompound.func_74764_b("SkinColor")) {
            this.skinColor = nbttagcompound.func_74762_e("SkinColor");
        }
        this.visible = nbttagcompound.func_74762_e("NpcVisible");
        this.disableLivingAnimation = nbttagcompound.func_74767_n("NoLivingAnimation");
        this.showBossBar = nbttagcompound.func_74771_c("BossBar");
        if (prevSkinType != this.skinType || !this.texture.equals(prevTexture)) {
            this.npc.textureLocation = null;
        }
        this.npc.textureGlowLocation = null;
        this.npc.textureCloakLocation = null;
        this.npc.updateHitbox();
    }

    public void loadProfile() {
        GameProfile gameprofile;
        if (!(this.playerProfile == null || StringUtils.func_151246_b((String)this.playerProfile.getName()) || MinecraftServer.func_71276_C() == null || this.playerProfile.isComplete() && this.playerProfile.getProperties().containsKey((Object)"textures") || (gameprofile = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(this.playerProfile.getName())) == null)) {
            Property property = (Property)Iterables.getFirst((Iterable)gameprofile.getProperties().get((Object)"textures"), null);
            if (property == null) {
                gameprofile = MinecraftServer.func_71276_C().func_147130_as().fillProfileProperties(gameprofile, true);
            }
            this.playerProfile = gameprofile;
        }
    }

    public boolean showName() {
        if (this.npc.isKilled()) {
            return false;
        }
        return this.showName == 0 || this.showName == 2 && this.npc.isAttacking();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.name.equals(name)) {
            return;
        }
        this.name = name;
        this.npc.updateClient = true;
    }

    @Override
    public int getShowName() {
        return this.showName;
    }

    @Override
    public void setShowName(int type) {
        if (type == this.showName) {
            return;
        }
        this.showName = ValueUtil.CorrectInt(type, 0, 2);
        this.npc.updateClient = true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        if (this.title.equals(title)) {
            return;
        }
        this.title = title;
        this.npc.updateClient = true;
    }

    @Override
    public String getSkinUrl() {
        return this.url;
    }

    @Override
    public void setSkinUrl(String url) {
        if (this.url.equals(url)) {
            return;
        }
        this.url = url;
        this.skinType = url.isEmpty() ? (byte)0 : (byte)2;
        this.npc.updateClient = true;
    }

    @Override
    public String getSkinPlayer() {
        return this.playerProfile == null ? "" : this.playerProfile.getName();
    }

    @Override
    public void setSkinPlayer(String name) {
        if (name == null || name.isEmpty()) {
            this.playerProfile = null;
            this.skinType = 0;
        } else {
            this.playerProfile = new GameProfile(null, name);
            this.skinType = 1;
        }
        this.npc.updateClient = true;
    }

    @Override
    public String getSkinTexture() {
        return this.texture;
    }

    @Override
    public void setSkinTexture(String texture) {
        if (this.texture.equals(texture)) {
            return;
        }
        this.texture = texture;
        this.npc.textureLocation = null;
        this.skinType = 0;
        this.npc.updateClient = true;
    }

    @Override
    public String getOverlayTexture() {
        return this.glowTexture;
    }

    @Override
    public void setOverlayTexture(String texture) {
        if (this.glowTexture.equals(texture)) {
            return;
        }
        this.glowTexture = texture;
        this.npc.textureGlowLocation = null;
        this.npc.updateClient = true;
    }

    @Override
    public String getCapeTexture() {
        return this.cloakTexture;
    }

    @Override
    public void setCapeTexture(String texture) {
        if (this.cloakTexture.equals(texture)) {
            return;
        }
        this.cloakTexture = texture;
        this.npc.textureCloakLocation = null;
        this.npc.updateClient = true;
    }

    @Override
    public boolean getHasLivingAnimation() {
        return !this.disableLivingAnimation;
    }

    @Override
    public void setHashLivingAnimation(boolean enabled) {
        this.disableLivingAnimation = !enabled;
        this.npc.updateClient = true;
    }

    @Override
    public int getBossbar() {
        return this.showBossBar;
    }

    @Override
    public void setBossbar(int type) {
        if (type == this.showBossBar) {
            return;
        }
        this.showBossBar = (byte)ValueUtil.CorrectInt(type, 0, 2);
        this.npc.updateClient = true;
    }

    @Override
    public int getVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(int type) {
        if (type == this.visible) {
            return;
        }
        this.visible = ValueUtil.CorrectInt(type, 0, 2);
        this.npc.updateClient = true;
    }

    @Override
    public int getSize() {
        return this.modelSize;
    }

    @Override
    public void setSize(int size) {
        if (this.modelSize == size) {
            return;
        }
        this.modelSize = ValueUtil.CorrectInt(size, 1, 30);
        this.npc.updateClient = true;
    }

    @Override
    public int getTint() {
        return this.skinColor;
    }

    @Override
    public void setTint(int color) {
        if (color == this.skinColor) {
            return;
        }
        this.skinColor = color;
        this.npc.updateClient = true;
    }
}

