/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import noppes.npcs.EventHooks;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.ScriptContainerOld;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.scripted.ScriptNpc;
import noppes.npcs.scripted.ScriptWorld;
import noppes.npcs.scripted.constants.AnimationType;
import noppes.npcs.scripted.constants.EntityType;
import noppes.npcs.scripted.constants.JobType;
import noppes.npcs.scripted.constants.MovingType;
import noppes.npcs.scripted.constants.PotionEffectType;
import noppes.npcs.scripted.constants.RoleEventType;
import noppes.npcs.scripted.constants.RoleType;
import noppes.npcs.scripted.constants.StandingType;
import noppes.npcs.scripted.constants.TacticalVariantType;

public class DataScript {
    public Map<Integer, ScriptContainerOld> scripts = new HashMap<Integer, ScriptContainerOld>();
    private static final AnimationType animations = new AnimationType();
    private static final EntityType entities = new EntityType();
    private static final JobType jobs = new JobType();
    private static final MovingType movingTypes = new MovingType();
    private static final RoleType roles = new RoleType();
    private static final StandingType standingTypes = new StandingType();
    private static final TacticalVariantType tacticalVariantTypes = new TacticalVariantType();
    private static final PotionEffectType potionEffectTypes = new PotionEffectType();
    private static final RoleEventType roleEventTypes = new RoleEventType();
    public String scriptLanguage = "ECMAScript";
    private EntityNPCInterface npc;
    public boolean enabled = false;
    public ScriptNpc dummyNpc;
    public ScriptWorld dummyWorld;
    public boolean hasInited = false;

    public DataScript(EntityNPCInterface npc) {
        this.npc = npc;
        if (npc instanceof EntityCustomNpc) {
            this.dummyNpc = new ScriptNpc((EntityCustomNpc)npc);
        }
        if (npc.field_70170_p instanceof WorldServer) {
            this.dummyWorld = new ScriptWorld((WorldServer)npc.field_70170_p);
        }
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.scripts = this.readScript(compound.func_150295_c("ScriptsContainers", 10));
        this.scriptLanguage = compound.func_74779_i("ScriptLanguage");
        this.enabled = compound.func_74767_n("ScriptEnabled");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74782_a("ScriptsContainers", (NBTBase)this.writeScript(this.scripts));
        compound.func_74778_a("ScriptLanguage", this.scriptLanguage);
        compound.func_74757_a("ScriptEnabled", this.enabled);
        return compound;
    }

    private Map<Integer, ScriptContainerOld> readScript(NBTTagList list) {
        HashMap<Integer, ScriptContainerOld> scripts = new HashMap<Integer, ScriptContainerOld>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compoundd = list.func_150305_b(i);
            ScriptContainerOld script = new ScriptContainerOld();
            script.readFromNBT(compoundd);
            if (!script.hasCode() && !this.npc.isRemote()) continue;
            scripts.put(compoundd.func_74762_e("Type"), script);
        }
        return scripts;
    }

    private NBTTagList writeScript(Map<Integer, ScriptContainerOld> scripts) {
        NBTTagList list = new NBTTagList();
        for (Integer type : scripts.keySet()) {
            NBTTagCompound compoundd = new NBTTagCompound();
            compoundd.func_74768_a("Type", type.intValue());
            ScriptContainerOld script = scripts.get(type);
            script.writeToNBT(compoundd);
            list.func_74742_a((NBTBase)compoundd);
        }
        return list;
    }

    public boolean callScript(EnumScriptType type, Object ... obs) {
        ScriptContainerOld script;
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.hasInited) {
            this.hasInited = true;
            EventHooks.onNPCInit(this.npc);
        }
        if ((script = this.scripts.get(type.ordinal())) == null || script.errored || !script.hasCode()) {
            return false;
        }
        script.setEngine(this.scriptLanguage);
        if (script.engine == null) {
            return false;
        }
        script.engine.put("npc", this.dummyNpc);
        script.engine.put("world", this.dummyWorld);
        return ScriptController.Instance.runScript(script, obs);
    }

    public boolean isEnabled() {
        return this.enabled && ScriptController.HasStart && !this.npc.field_70170_p.field_72995_K;
    }

    public void setWorld(World world) {
        if (world instanceof WorldServer) {
            this.dummyWorld = new ScriptWorld((WorldServer)world);
        }
    }
}

