/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.entity.IEntityLivingBase;
import noppes.npcs.api.event.BlockEvent;
import noppes.npcs.api.event.DialogEvent;
import noppes.npcs.api.event.NpcEvent;
import noppes.npcs.api.event.QuestEvent;
import noppes.npcs.api.wrapper.WrapperNpcAPI;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.Dialog;
import noppes.npcs.controllers.DialogOption;
import noppes.npcs.controllers.Quest;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.scripted.events.ScriptCancellableEvent;
import noppes.npcs.scripted.events.ScriptEventAttack;
import noppes.npcs.scripted.events.ScriptEventDamaged;
import noppes.npcs.scripted.events.ScriptEventKilled;
import noppes.npcs.scripted.events.ScriptEventTarget;

public class EventHooks {
    public static boolean onNPCAttacksMelee(EntityNPCInterface npc, NpcEvent.MeleeAttackEvent event) {
        ScriptEventAttack eventold = new ScriptEventAttack(event.damage, event.target.getMCEntity(), false);
        if (npc.script.callScript(EnumScriptType.ATTACK, "event", eventold, "target", event.target.getMCEntity())) {
            return true;
        }
        event.damage = eventold.getDamage();
        return WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static boolean onNPCRangedLaunched(EntityNPCInterface npc, NpcEvent.RangedLaunchedEvent event) {
        ScriptEventAttack eventold = new ScriptEventAttack(event.damage, event.target.getMCEntity(), true);
        if (npc.script.callScript(EnumScriptType.ATTACK, "event", eventold, "target", event.target.getMCEntity())) {
            return true;
        }
        event.damage = eventold.getDamage();
        return WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static boolean onNPCTarget(EntityNPCInterface npc, NpcEvent.TargetEvent event) {
        ScriptEventTarget eventold = new ScriptEventTarget(event.entity.getMCEntity());
        if (npc.script.callScript(EnumScriptType.TARGET, "event", eventold)) {
            return true;
        }
        event.entity = eventold.getTarget() == null ? null : (IEntityLivingBase)NpcAPI.Instance().getIEntity((Entity)eventold.getTarget().getMCEntity());
        return WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static boolean onNPCTargetLost(EntityNPCInterface npc, EntityLivingBase prevtarget) {
        ScriptEventTarget eventold = new ScriptEventTarget(prevtarget);
        if (npc.script.callScript(EnumScriptType.TARGET_LOST, "event", eventold)) {
            return true;
        }
        return WrapperNpcAPI.EVENT_BUS.post((Event)new NpcEvent.TargetLostEvent(npc.wrappedNPC, prevtarget));
    }

    public static boolean onNPCInteract(EntityNPCInterface npc, EntityPlayer player) {
        if (npc.script.callScript(EnumScriptType.INTERACT, "player", player, "event", new ScriptCancellableEvent())) {
            return true;
        }
        NpcEvent.InteractEvent event = new NpcEvent.InteractEvent(npc.wrappedNPC, player);
        event.setCanceled(npc.isAttacking() || npc.isKilled() || npc.faction.isAggressiveToPlayer(player));
        return WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static boolean onNPCDamaged(EntityNPCInterface npc, NpcEvent.DamagedEvent event) {
        ScriptEventDamaged eventold = new ScriptEventDamaged(event.damage, event.source == null ? null : event.source.getMCEntity(), event.mcDamageSource);
        if (npc.script.callScript(EnumScriptType.DAMAGED, "event", eventold)) {
            return true;
        }
        event.damage = eventold.getDamage();
        event.clearTarget = eventold.getClearTarget();
        event.setCanceled(npc.isKilled());
        return WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static void onNPCInit(EntityNPCInterface npc) {
        npc.script.callScript(EnumScriptType.INIT, new Object[0]);
        WrapperNpcAPI.EVENT_BUS.post((Event)new NpcEvent.InitEvent(npc.wrappedNPC));
    }

    public static void onNPCCollide(EntityNPCInterface npc, Entity entity) {
        npc.script.callScript(EnumScriptType.COLLIDE, "entity", entity);
        WrapperNpcAPI.EVENT_BUS.post((Event)new NpcEvent.CollideEvent(npc.wrappedNPC, entity));
    }

    public static void onNPCTick(EntityNPCInterface npc) {
        npc.script.callScript(EnumScriptType.TICK, new Object[0]);
        WrapperNpcAPI.EVENT_BUS.post((Event)new NpcEvent.UpdateEvent(npc.wrappedNPC));
    }

    public static boolean onNPCDied(EntityNPCInterface npc, Entity entity, DamageSource damagesource) {
        if (npc.script.callScript(EnumScriptType.KILLED, "event", new ScriptEventKilled(entity, damagesource))) {
            return true;
        }
        return WrapperNpcAPI.EVENT_BUS.post((Event)new NpcEvent.DiedEvent(npc.wrappedNPC, damagesource, entity));
    }

    public static boolean onNPCDialogOption(EntityNPCInterface npc, EntityPlayerMP player, Dialog dialog, DialogOption option) {
        npc.script.callScript(EnumScriptType.DIALOG_OPTION, "player", player, "dialog", dialog.id, "option", option.slot + 1);
        return WrapperNpcAPI.EVENT_BUS.post((Event)new DialogEvent.OptionEvent(npc.wrappedNPC, (EntityPlayer)player, dialog, option));
    }

    public static boolean onNPCDialog(EntityNPCInterface npc, EntityPlayer player, Dialog dialog) {
        npc.script.callScript(EnumScriptType.DIALOG, "player", player, "dialog", dialog.id);
        return WrapperNpcAPI.EVENT_BUS.post((Event)new DialogEvent.OpenEvent(npc.wrappedNPC, player, dialog));
    }

    public static void onNPCKills(EntityNPCInterface npc, EntityLivingBase entityLiving) {
        npc.script.callScript(EnumScriptType.KILLS, "target", entityLiving);
        WrapperNpcAPI.EVENT_BUS.post((Event)new NpcEvent.KilledEntityEvent(npc.wrappedNPC, entityLiving));
    }

    public static boolean onQuestStarted(EntityPlayer player, Quest quest) {
        return WrapperNpcAPI.EVENT_BUS.post((Event)new QuestEvent.QuestStartEvent(player, quest));
    }

    public static void onQuestFinished(EntityPlayer player, Quest quest) {
        WrapperNpcAPI.EVENT_BUS.post((Event)new QuestEvent.QuestCompletedEvent(player, quest));
    }

    public static void onQuestTurnedIn(EntityPlayerMP player, Quest quest) {
        WrapperNpcAPI.EVENT_BUS.post((Event)new QuestEvent.QuestTurnedInEvent((EntityPlayer)player, quest));
    }

    public static boolean onScriptBlockInteract(IBlock block, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        return WrapperNpcAPI.EVENT_BUS.post((Event)new BlockEvent.InteractEvent(block, player, side, hitX, hitY, hitZ));
    }

    public static void onScriptBlockCollide(IBlock block, Entity entityIn) {
        WrapperNpcAPI.EVENT_BUS.post((Event)new BlockEvent.CollidedEvent(block, entityIn));
    }

    public static void onScriptBlockRainFill(IBlock block) {
        WrapperNpcAPI.EVENT_BUS.post((Event)new BlockEvent.RainFillEvent(block));
    }

    public static float onScriptBlockFallenUpon(IBlock block, Entity entity, float distance) {
        BlockEvent.EntityFallenUponEvent event = new BlockEvent.EntityFallenUponEvent(block, entity, distance);
        if (WrapperNpcAPI.EVENT_BUS.post((Event)event)) {
            return 0.0f;
        }
        return event.distanceFallen;
    }

    public static void onScriptBlockClicked(IBlock block, EntityPlayer player) {
        WrapperNpcAPI.EVENT_BUS.post((Event)new BlockEvent.ClickedEvent(block, player));
    }

    public static void onScriptBlockBreak(IBlock block) {
        WrapperNpcAPI.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(block));
    }

    public static boolean onScriptBlockHarvest(IBlock block, EntityPlayer player) {
        return WrapperNpcAPI.EVENT_BUS.post((Event)new BlockEvent.HarvestedEvent(block, player));
    }

    public static boolean onScriptBlockExploded(IBlock block) {
        return WrapperNpcAPI.EVENT_BUS.post((Event)new BlockEvent.ExplodedEvent(block));
    }

    public static void onScriptBlockNeighborChanged(IBlock block) {
        WrapperNpcAPI.EVENT_BUS.post((Event)new BlockEvent.NeighborChangedEvent(block));
    }

    public static void onScriptBlockRedstonePower(IBlock block, int prevPower, int power) {
        WrapperNpcAPI.EVENT_BUS.post((Event)new BlockEvent.RedstoneEvent(block, prevPower, power));
    }

    public static void onScriptBlockInit(IBlock block) {
        WrapperNpcAPI.EVENT_BUS.post((Event)new BlockEvent.InitEvent(block));
    }

    public static void onScriptBlockUpdate(IBlock block) {
        WrapperNpcAPI.EVENT_BUS.post((Event)new BlockEvent.UpdateEvent(block));
    }

    public static boolean onScriptBlockDoorToggle(IBlock block) {
        return WrapperNpcAPI.EVENT_BUS.post((Event)new BlockEvent.DoorToggleEvent(block));
    }
}

