/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.MathHelper;
import noppes.npcs.constants.AiMutex;
import noppes.npcs.constants.EnumAnimation;
import noppes.npcs.constants.EnumNavType;
import noppes.npcs.entity.EntityNPCInterface;

public class EntityAIRangedAttack
extends EntityAIBase {
    private final EntityNPCInterface npc;
    private EntityLivingBase attackTarget;
    private int rangedAttackTime = 0;
    private int field_75318_f = 0;
    private int field_70846_g = 0;
    private int attackTick = 0;
    private boolean hasFired = false;
    private boolean navOverride = false;

    public EntityAIRangedAttack(IRangedAttackMob par1IRangedAttackMob) {
        if (!(par1IRangedAttackMob instanceof EntityLivingBase)) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        this.npc = (EntityNPCInterface)par1IRangedAttackMob;
        this.rangedAttackTime = this.npc.stats.minDelay / 2;
        this.func_75248_a(this.navOverride ? AiMutex.PATHING : AiMutex.LOOK + AiMutex.PASSIVE);
    }

    public boolean func_75250_a() {
        this.attackTarget = this.npc.func_70638_az();
        if (this.attackTarget == null || !this.attackTarget.func_70089_S() || !this.npc.isInRange((Entity)this.attackTarget, this.npc.stats.aggroRange) || this.npc.inventory.getProjectile() == null) {
            return false;
        }
        return this.npc.ai.useRangeMelee < 1 || !this.npc.isInRange((Entity)this.attackTarget, this.npc.ai.distanceToMelee);
    }

    public void func_75251_c() {
        this.attackTarget = null;
        this.npc.func_70624_b(null);
        this.npc.func_70661_as().func_75499_g();
        this.field_75318_f = 0;
        this.hasFired = false;
        this.rangedAttackTime = this.npc.stats.minDelay / 2;
    }

    public void func_75246_d() {
        this.npc.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
        double var1 = this.npc.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v);
        float field_82642_h = this.npc.stats.rangedRange * this.npc.stats.rangedRange;
        if (!this.navOverride && this.npc.ai.directLOS) {
            int v;
            this.field_75318_f = this.npc.func_70635_at().func_75522_a((Entity)this.attackTarget) ? ++this.field_75318_f : 0;
            int n = v = this.npc.ai.tacticalVariant == EnumNavType.Default ? 20 : 5;
            if (var1 <= (double)field_82642_h && this.field_75318_f >= v) {
                this.npc.func_70661_as().func_75499_g();
            } else {
                this.npc.func_70661_as().func_75497_a((Entity)this.attackTarget, 1.0);
            }
        }
        this.rangedAttackTime = Math.max(this.rangedAttackTime - 1, 0);
        if (this.rangedAttackTime <= 0 && var1 <= (double)field_82642_h && (this.npc.func_70635_at().func_75522_a((Entity)this.attackTarget) || this.npc.ai.canFireIndirect == 2)) {
            if (this.field_70846_g++ <= this.npc.stats.burstCount) {
                this.rangedAttackTime = this.npc.stats.fireRate;
            } else {
                this.field_70846_g = 0;
                this.hasFired = true;
                this.rangedAttackTime = this.npc.stats.maxDelay - MathHelper.func_76141_d((float)(this.npc.func_70681_au().nextFloat() * (float)(this.npc.stats.maxDelay - this.npc.stats.minDelay)));
            }
            if (this.field_70846_g > 1) {
                boolean indirect = false;
                switch (this.npc.ai.canFireIndirect) {
                    case 1: {
                        indirect = var1 > (double)field_82642_h / 2.0;
                        break;
                    }
                    case 2: {
                        indirect = !this.npc.func_70635_at().func_75522_a((Entity)this.attackTarget);
                    }
                }
                this.npc.func_82196_d(this.attackTarget, indirect ? 1.0f : 0.0f);
                if (this.npc.currentAnimation != EnumAnimation.AIMING) {
                    this.npc.func_71038_i();
                }
            }
        }
    }

    public boolean hasFired() {
        return this.hasFired;
    }

    public void navOverride(boolean nav) {
        this.navOverride = nav;
        this.func_75248_a(this.navOverride ? AiMutex.PATHING : AiMutex.LOOK + AiMutex.PASSIVE);
    }
}

