/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai;

import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import noppes.npcs.CustomNpcs;
import noppes.npcs.ai.RandomPositionGeneratorAlt;
import noppes.npcs.constants.AiMutex;
import noppes.npcs.constants.EnumMovingType;
import noppes.npcs.entity.EntityNPCInterface;

public class EntityAIReturn
extends EntityAIBase {
    public static final int MaxTotalTicks = 600;
    private final EntityNPCInterface npc;
    private int stuckTicks = 0;
    private int totalTicks = 0;
    private double endPosX;
    private double endPosY;
    private double endPosZ;
    private boolean wasAttacked = false;
    private double[] preAttackPos;
    private int stuckCount = 0;

    public EntityAIReturn(EntityNPCInterface npc) {
        this.npc = npc;
        this.func_75248_a(AiMutex.PASSIVE);
    }

    public boolean func_75250_a() {
        BlockPos pos;
        if (this.npc.hasOwner() || !this.npc.ai.returnToStart || this.npc.isKilled() || !this.npc.func_70661_as().func_75500_f() || this.npc.isInteracting()) {
            return false;
        }
        if (this.npc.ai.findShelter == 0 && (!this.npc.field_70170_p.func_72935_r() || this.npc.field_70170_p.func_72896_J()) && !this.npc.field_70170_p.field_73011_w.func_177495_o() ? this.npc.field_70170_p.func_175678_i(pos = new BlockPos((double)this.npc.getStartXPos(), this.npc.getStartYPos(), (double)this.npc.getStartZPos())) || this.npc.field_70170_p.func_175699_k(pos) <= 8 : this.npc.ai.findShelter == 1 && this.npc.field_70170_p.func_72935_r() && this.npc.field_70170_p.func_175678_i(pos = new BlockPos((double)this.npc.getStartXPos(), this.npc.getStartYPos(), (double)this.npc.getStartZPos()))) {
            return false;
        }
        if (this.npc.isAttacking()) {
            if (!this.wasAttacked) {
                this.wasAttacked = true;
                this.preAttackPos = new double[]{this.npc.field_70165_t, this.npc.field_70163_u, this.npc.field_70161_v};
            }
            return false;
        }
        if (!this.npc.isAttacking() && this.wasAttacked) {
            return true;
        }
        if (this.npc.ai.movingType == EnumMovingType.MovingPath && this.npc.ai.getDistanceSqToPathPoint() < (double)(CustomNpcs.NpcNavRange * CustomNpcs.NpcNavRange)) {
            return false;
        }
        if (this.npc.ai.movingType == EnumMovingType.Wandering) {
            double x = this.npc.field_70165_t - (double)this.npc.getStartXPos();
            double z = this.npc.field_70165_t - (double)this.npc.getStartZPos();
            return !this.npc.isInRange(this.npc.getStartXPos(), -1.0, this.npc.getStartZPos(), this.npc.ai.walkingRange);
        }
        if (this.npc.ai.movingType == EnumMovingType.Standing) {
            return !this.npc.isVeryNearAssignedPlace();
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.npc.isFollower() || this.npc.isKilled() || this.npc.isAttacking() || this.npc.isVeryNearAssignedPlace() || this.npc.isInteracting()) {
            return false;
        }
        if (this.npc.func_70661_as().func_75500_f() && this.wasAttacked && !this.isTooFar()) {
            return false;
        }
        return this.totalTicks <= 600;
    }

    public void func_75246_d() {
        ++this.totalTicks;
        if (this.totalTicks > 600) {
            this.npc.func_70107_b(this.endPosX, this.endPosY, this.endPosZ);
            this.npc.func_70661_as().func_75499_g();
            return;
        }
        if (this.stuckTicks > 0) {
            --this.stuckTicks;
        } else if (this.npc.func_70661_as().func_75500_f()) {
            ++this.stuckCount;
            this.stuckTicks = 10;
            if (this.totalTicks > 30 && this.wasAttacked && this.isTooFar() || this.stuckCount > 5) {
                this.npc.func_70107_b(this.endPosX, this.endPosY, this.endPosZ);
                this.npc.func_70661_as().func_75499_g();
            } else {
                this.navigate(this.stuckCount % 2 == 1);
            }
        } else {
            this.stuckCount = 0;
        }
    }

    private boolean isTooFar() {
        double z;
        double x;
        int allowedDistance = this.npc.stats.aggroRange * 2;
        if (this.npc.ai.movingType == EnumMovingType.Wandering) {
            allowedDistance += this.npc.ai.walkingRange;
        }
        return (x = this.npc.field_70165_t - this.endPosX) * x + (z = this.npc.field_70165_t - this.endPosZ) * z > (double)(allowedDistance * allowedDistance);
    }

    public void func_75249_e() {
        this.stuckTicks = 0;
        this.totalTicks = 0;
        this.stuckCount = 0;
        this.navigate(false);
    }

    private void navigate(boolean towards) {
        if (!this.wasAttacked) {
            this.endPosX = this.npc.getStartXPos();
            this.endPosY = this.npc.getStartYPos();
            this.endPosZ = this.npc.getStartZPos();
        } else {
            this.endPosX = this.preAttackPos[0];
            this.endPosY = this.preAttackPos[1];
            this.endPosZ = this.preAttackPos[2];
        }
        double posX = this.endPosX;
        double posY = this.endPosY;
        double posZ = this.endPosZ;
        double range = this.npc.func_70011_f(posX, posY, posZ);
        if (range > (double)CustomNpcs.NpcNavRange || towards) {
            Vec3 start;
            Vec3 pos;
            int distance = (int)range;
            distance = distance > CustomNpcs.NpcNavRange ? CustomNpcs.NpcNavRange / 2 : (distance /= 2);
            if (distance > 2 && (pos = RandomPositionGeneratorAlt.findRandomTargetBlockTowards(this.npc, distance, distance / 2 > 7 ? 7 : distance / 2, start = new Vec3(posX, posY, posZ))) != null) {
                posX = pos.field_72450_a;
                posY = pos.field_72448_b;
                posZ = pos.field_72449_c;
            }
        }
        this.npc.func_70661_as().func_75499_g();
        this.npc.func_70661_as().func_75492_a(posX, posY, posZ, 1.0);
    }

    public void func_75251_c() {
        this.wasAttacked = false;
        this.npc.func_70661_as().func_75499_g();
    }
}

