/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldSettings;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.api.APIException;
import noppes.npcs.api.IItemStack;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.wrapper.EntityLivingBaseWrapper;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.client.EntityUtil;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.Dialog;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.DialogOption;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerDialogData;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.controllers.Quest;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.QuestData;
import noppes.npcs.entity.EntityDialogNpc;
import noppes.npcs.util.ValueUtil;

public class PlayerWrapper
extends EntityLivingBaseWrapper
implements IPlayer {
    private EntityPlayerMP player;

    public PlayerWrapper(EntityPlayerMP player) {
        super((EntityLivingBase)player);
        this.player = player;
    }

    @Override
    public String getName() {
        return this.player.func_70005_c_();
    }

    @Override
    public boolean hasFinishedQuest(int id) {
        PlayerQuestData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player).questData;
        return data.finishedQuests.containsKey(id);
    }

    @Override
    public boolean hasActiveQuest(int id) {
        PlayerQuestData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player).questData;
        return data.activeQuests.containsKey(id);
    }

    @Override
    public void startQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        QuestData questdata = new QuestData(quest);
        data.questData.activeQuests.put(id, questdata);
        Server.sendData(this.player, EnumPacketClient.MESSAGE, "quest.newquest", quest.title);
        Server.sendData(this.player, EnumPacketClient.CHAT, "quest.newquest", ": ", quest.title);
    }

    @Override
    public void finishQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        data.questData.finishedQuests.put(id, System.currentTimeMillis());
    }

    @Override
    public void stopQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        data.questData.activeQuests.remove(id);
    }

    @Override
    public void removeQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        data.questData.activeQuests.remove(id);
        data.questData.finishedQuests.remove(id);
    }

    @Override
    public boolean hasReadDialog(int id) {
        PlayerDialogData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player).dialogData;
        return data.dialogsRead.contains(id);
    }

    @Override
    public void showDialog(int id, String name) {
        Dialog dialog = DialogController.instance.dialogs.get(id);
        if (dialog == null) {
            throw new APIException("Unknown Dialog id: " + id, new Object[0]);
        }
        if (!dialog.availability.isAvailable((EntityPlayer)this.player)) {
            return;
        }
        EntityDialogNpc npc = new EntityDialogNpc(this.getWorld().getMCWorld());
        npc.display.setName(name);
        EntityUtil.Copy((EntityLivingBase)this.player, (EntityLivingBase)npc);
        DialogOption option = new DialogOption();
        option.dialogId = id;
        option.title = dialog.title;
        npc.dialogs.put(0, option);
        NoppesUtilServer.openDialog((EntityPlayer)this.player, npc, dialog);
    }

    @Override
    public void addFactionPoints(int faction, int points) {
        PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        data.factionData.increasePoints(faction, points);
    }

    @Override
    public int getFactionPoints(int faction) {
        PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        return data.factionData.getFactionPoints(faction);
    }

    @Override
    public void message(String message) {
        this.player.func_145747_a((IChatComponent)new ChatComponentTranslation(NoppesStringUtils.formatText(message, this.player), new Object[0]));
    }

    @Override
    public int getGamemode() {
        return this.player.field_71134_c.func_73081_b().func_77148_a();
    }

    @Override
    public void setGamemode(int type) {
        this.player.func_71033_a(WorldSettings.func_77161_a((int)type));
    }

    @Override
    public int inventoryItemCount(IItemStack item) {
        int i = 0;
        for (ItemStack is : this.player.field_71071_by.field_70462_a) {
            if (is == null || !is.func_77969_a(item.getMCItemStack())) continue;
            i += is.field_77994_a;
        }
        return i;
    }

    @Override
    public boolean removeItem(IItemStack item, int amount) {
        int count = this.inventoryItemCount(item);
        if (amount > count) {
            return false;
        }
        if (count == amount) {
            this.removeAllItems(item);
        } else {
            for (int i = 0; i < this.player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack is = this.player.field_71071_by.field_70462_a[i];
                if (is == null || !is.func_77969_a(item.getMCItemStack())) continue;
                if (amount > is.field_77994_a) {
                    this.player.field_71071_by.field_70462_a[i] = null;
                    amount -= is.field_77994_a;
                    continue;
                }
                is.func_77979_a(amount);
                break;
            }
        }
        return true;
    }

    @Override
    public boolean removeItem(String id, int damage, int amount) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)id);
        if (item == null) {
            return false;
        }
        return this.removeItem(new ItemStackWrapper(new ItemStack(item, 1, damage)), amount);
    }

    @Override
    public boolean giveItem(IItemStack item, int amount) {
        String itemname = Item.field_150901_e.func_177774_c((Object)item.getMCItemStack().func_77973_b()) + "";
        return this.giveItem(itemname, item.getItemDamage(), amount);
    }

    @Override
    public boolean giveItem(String id, int damage, int amount) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)id);
        if (item == null) {
            return false;
        }
        return this.player.field_71071_by.func_70441_a(new ItemStack(item, amount, damage));
    }

    @Override
    public void setSpawnpoint(int x, int y, int z) {
        x = ValueUtil.CorrectInt(x, -30000000, 30000000);
        z = ValueUtil.CorrectInt(z, -30000000, 30000000);
        y = ValueUtil.CorrectInt(y, 0, 256);
        this.player.func_180473_a(new BlockPos(x, y, z), true);
    }

    @Override
    public void resetSpawnpoint() {
        this.player.func_180473_a(null, false);
    }

    @Override
    public void removeAllItems(IItemStack item) {
        for (int i = 0; i < this.player.field_71071_by.field_70462_a.length; ++i) {
            ItemStack is = this.player.field_71071_by.field_70462_a[i];
            if (is == null || !is.func_77969_a(item.getMCItemStack())) continue;
            this.player.field_71071_by.field_70462_a[i] = null;
        }
    }

    @Override
    public boolean hasAchievement(String achievement) {
        StatBase statbase = StatList.func_151177_a((String)achievement);
        if (statbase == null || !(statbase instanceof Achievement)) {
            return false;
        }
        return this.player.func_147099_x().func_77443_a((Achievement)statbase);
    }

    @Override
    public int getExpLevel() {
        return this.player.field_71068_ca;
    }

    @Override
    public void setExpLevel(int level) {
        this.player.field_71068_ca = level;
    }

    @Override
    public void setPosition(double x, double y, double z) {
        NoppesUtilPlayer.teleportPlayer(this.player, new BlockPos(x, y, z), this.player.field_71093_bK);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean typeOf(int type) {
        return type == 1 ? true : super.typeOf(type);
    }

    @Override
    public EntityPlayerMP getMCEntity() {
        return this.player;
    }
}

