/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.APIException;
import noppes.npcs.api.IData;
import noppes.npcs.api.IItemStack;
import noppes.npcs.api.IScoreboard;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.api.wrapper.ScoreboardWrapper;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.entity.EntityNPCInterface;

public class WorldWrapper
implements IWorld {
    private static Map<String, Object> tempData = new HashMap<String, Object>();
    public WorldServer world;
    private IData tempdata = new IData(){

        @Override
        public void put(String key, Object value) {
            tempData.put(key, value);
        }

        @Override
        public Object get(String key) {
            return tempData.get(key);
        }

        @Override
        public void remove(String key) {
            tempData.remove(key);
        }

        @Override
        public boolean has(String key) {
            return tempData.containsKey(key);
        }

        @Override
        public void clear() {
            tempData.clear();
        }
    };
    private IData storeddata = new IData(){

        @Override
        public void put(String key, Object value) {
            NBTTagCompound compound = ScriptController.Instance.compound;
            if (value instanceof Number) {
                compound.func_74780_a(key, ((Number)value).doubleValue());
            } else if (value instanceof String) {
                compound.func_74778_a(key, (String)value);
            }
            ScriptController.Instance.shouldSave = true;
        }

        @Override
        public Object get(String key) {
            NBTTagCompound compound = ScriptController.Instance.compound;
            if (!compound.func_74764_b(key)) {
                return null;
            }
            NBTBase base = compound.func_74781_a(key);
            if (base instanceof NBTBase.NBTPrimitive) {
                return ((NBTBase.NBTPrimitive)base).func_150286_g();
            }
            return ((NBTTagString)base).func_150285_a_();
        }

        @Override
        public void remove(String key) {
            ScriptController.Instance.compound.func_82580_o(key);
            ScriptController.Instance.shouldSave = true;
        }

        @Override
        public boolean has(String key) {
            return ScriptController.Instance.compound.func_74764_b(key);
        }

        @Override
        public void clear() {
            ScriptController.Instance.compound = new NBTTagCompound();
            ScriptController.Instance.shouldSave = true;
        }
    };

    public WorldWrapper(World world) {
        this.world = (WorldServer)world;
    }

    @Override
    public World getMCWorld() {
        return this.world;
    }

    @Override
    public IEntity[] getNearbyEntities(int x, int y, int z, int range, int type) {
        AxisAlignedBB bb = AxisAlignedBB.func_178781_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0).func_72317_d((double)x, (double)y, (double)z).func_72314_b((double)range, (double)range, (double)range);
        List entities = this.world.func_72872_a(this.getClassForType(type), bb);
        ArrayList<IEntity> list = new ArrayList<IEntity>();
        for (Entity living : entities) {
            list.add(NpcAPI.Instance().getIEntity(living));
        }
        return list.toArray(new IEntity[list.size()]);
    }

    @Override
    public IEntity getClosestEntity(int x, int y, int z, int range, int type) {
        AxisAlignedBB bb = AxisAlignedBB.func_178781_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0).func_72317_d((double)x, (double)y, (double)z).func_72314_b((double)range, (double)range, (double)range);
        List entities = this.world.func_72872_a(this.getClassForType(type), bb);
        double distance = range * range * range;
        Entity entity = null;
        for (Entity e : entities) {
            double d0 = (double)x - e.field_70165_t;
            double d1 = (double)y - e.field_70163_u;
            double d2 = (double)z - e.field_70161_v;
            double r = d0 * d0 + d1 * d1 + d2 * d2;
            if (entity == null) {
                distance = r;
                entity = e;
                continue;
            }
            if (!(r < distance)) continue;
            distance = r;
            entity = e;
        }
        return NpcAPI.Instance().getIEntity(entity);
    }

    @Override
    public IPlayer getPlayer(String name) {
        EntityPlayer player = this.world.func_72924_a(name);
        if (player == null) {
            return null;
        }
        return (IPlayer)NpcAPI.Instance().getIEntity((Entity)player);
    }

    private Class getClassForType(int type) {
        Class cls = Entity.class;
        if (type == 5) {
            cls = EntityLivingBase.class;
        } else if (type == 1) {
            cls = EntityPlayer.class;
        } else if (type == 4) {
            cls = EntityAnimal.class;
        } else if (type == 3) {
            cls = EntityMob.class;
        } else if (type == 2) {
            cls = EntityNPCInterface.class;
        }
        return cls;
    }

    @Override
    public long getTime() {
        return this.world.func_72820_D();
    }

    @Override
    public void setTime(long time) {
        this.world.func_72877_b(time);
    }

    @Override
    public long getTotalTime() {
        return this.world.func_82737_E();
    }

    @Override
    public IBlock getBlock(int x, int y, int z) {
        return NpcAPI.Instance().getIBlock((World)this.world, new BlockPos(x, y, z));
    }

    @Override
    public void setBlock(int x, int y, int z, String name, int meta) {
        Block block = Block.func_149684_b((String)name);
        if (block == null) {
            throw new APIException("There is no such block: %s", new Object[0]);
        }
        this.world.func_175656_a(new BlockPos(x, y, z), block.func_176203_a(meta));
    }

    @Override
    public void removeBlock(int x, int y, int z) {
        this.world.func_175698_g(new BlockPos(x, y, z));
    }

    @Override
    public float getLightValue(int x, int y, int z) {
        return (float)this.world.func_175699_k(new BlockPos(x, y, z)) / 16.0f;
    }

    @Override
    public boolean isDay() {
        return this.world.func_72820_D() % 24000L < 12000L;
    }

    @Override
    public boolean isRaining() {
        return this.world.func_72912_H().func_76059_o();
    }

    @Override
    public void setRaining(boolean bo) {
        this.world.func_72912_H().func_76084_b(bo);
    }

    @Override
    public void thunderStrike(double x, double y, double z) {
        this.world.func_72942_c((Entity)new EntityLightningBolt((World)this.world, x, y, z));
    }

    @Override
    public void spawnParticle(String particle, double x, double y, double z, double dx, double dy, double dz, double speed, int count) {
        EnumParticleTypes particleType = null;
        for (EnumParticleTypes enumParticle : EnumParticleTypes.values()) {
            if (enumParticle.func_179343_f()) {
                if (!particle.startsWith(enumParticle.func_179346_b())) continue;
                particleType = enumParticle;
                break;
            }
            if (!particle.equals(enumParticle.func_179346_b())) continue;
            particleType = enumParticle;
            break;
        }
        if (particleType != null) {
            this.world.func_175739_a(particleType, x, y, z, count, dx, dy, dz, speed, new int[0]);
        }
    }

    @Override
    public IData getTempdata() {
        return this.tempdata;
    }

    @Override
    public IData getStoreddata() {
        return this.storeddata;
    }

    @Override
    public IItemStack createItem(String name, int damage, int size) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)name);
        if (item == null) {
            return null;
        }
        return new ItemStackWrapper(new ItemStack(item, size, damage));
    }

    @Override
    public void explode(double x, double y, double z, float range, boolean fire, boolean grief) {
        this.world.func_72885_a(null, x, y, z, range, fire, grief);
    }

    @Override
    public IPlayer[] getAllPlayers() {
        List list = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        IPlayer[] arr = new IPlayer[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = (IPlayer)NpcAPI.Instance().getIEntity((Entity)list.get(i));
        }
        return arr;
    }

    @Override
    public String getBiomeName(int x, int z) {
        return this.world.func_180494_b((BlockPos)new BlockPos((int)x, (int)0, (int)z)).field_76791_y;
    }

    @Override
    public IEntity spawnClone(int x, int y, int z, int tab, String name) {
        NBTTagCompound compound = ServerCloneController.Instance.getCloneData(null, name, tab);
        if (compound == null) {
            return null;
        }
        Entity entity = NoppesUtilServer.spawnClone(compound, x, y, z, (World)this.world);
        if (entity == null) {
            return null;
        }
        return NpcAPI.Instance().getIEntity(entity);
    }

    @Override
    public IScoreboard getScoreboard() {
        return new ScoreboardWrapper();
    }

    @Override
    public void broadcast(String message) {
        MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(message));
    }

    @Override
    public int getRedstonePower(int x, int y, int z) {
        return this.world.func_175676_y(new BlockPos(x, y, z));
    }
}

