/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.blocks.tiles.TileBanner;
import noppes.npcs.blocks.tiles.TileColorable;
import noppes.npcs.client.renderer.ITileRenderer;

public class BlockBanner
extends BlockContainer
implements ITileRenderer {
    public static final PropertyInteger DAMAGE = PropertyInteger.func_177719_a((String)"damage", (int)0, (int)5);
    public static final PropertyBool TOP = PropertyBool.func_177716_a((String)"top");
    private TileColorable renderTile;

    public BlockBanner() {
        super(Material.field_151576_e);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f);
    }

    public boolean func_180639_a(World par1World, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileBanner tile;
        ItemStack item = player.field_71071_by.func_70448_g();
        if (item == null) {
            return false;
        }
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            pos = pos.func_177977_b();
        }
        if ((tile = (TileBanner)par1World.func_175625_s(pos)).canEdit()) {
            return true;
        }
        if (item.func_77973_b() != Items.field_151100_aR) {
            return false;
        }
        int color = EnumDyeColor.func_176764_b((int)item.func_77952_i()).func_176768_e().field_76291_p;
        if (tile.color != color) {
            NoppesUtilServer.consumeItemStack(1, player);
            tile.color = color;
            par1World.func_175689_h(pos);
        }
        return true;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
        par3List.add(new ItemStack(par1, 1, 2));
        par3List.add(new ItemStack(par1, 1, 3));
        par3List.add(new ItemStack(par1, 1, 4));
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)DAMAGE);
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)DAMAGE) + ((Boolean)state.func_177229_b((IProperty)TOP) != false ? 7 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(meta % 7)).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(meta >= 7));
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{DAMAGE, TOP});
    }

    public void func_180654_a(IBlockAccess world, BlockPos pos) {
        try {
            if (((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)TOP)).booleanValue()) {
                this.func_149676_a(0.0f, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            } else {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        if (!world.func_175623_d(pos.func_177984_a())) {
            world.func_175698_g(pos);
        } else {
            world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(stack.func_77952_i())), 2);
            world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(stack.func_77952_i())), 2);
            int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            TileBanner tile = (TileBanner)world.func_175625_s(pos);
            tile.rotation = l %= 4;
            tile.color = 15 - stack.func_77952_i();
            tile.time = System.currentTimeMillis();
            if (entity instanceof EntityPlayer && world.field_72995_K) {
                ((EntityPlayer)entity).func_146105_b((IChatComponent)new ChatComponentTranslation("availability.editIcon", new Object[0]));
            }
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        if (var2 < 7) {
            return new TileBanner();
        }
        return null;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue() && world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            world.func_175698_g(pos.func_177977_b());
        } else if (!((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue() && world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            world.func_175698_g(pos.func_177984_a());
        }
    }

    @Override
    public TileColorable getTile() {
        if (this.renderTile == null) {
            this.renderTile = (TileColorable)this.func_149915_a(null, 0);
        }
        return this.renderTile;
    }
}

