/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import noppes.npcs.CustomItems;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.blocks.tiles.TileScripted;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.constants.EnumScriptBlockType;
import noppes.npcs.scripted.events.ScriptBlockEventFallen;
import noppes.npcs.scripted.events.ScriptBlockEventInteract;
import noppes.npcs.scripted.events.ScriptBlockEventRedstone;
import noppes.npcs.scripted.events.ScriptCancellableEvent;
import noppes.npcs.util.IPermission;

public class BlockScripted
extends BlockContainer
implements IPermission {
    public BlockScripted() {
        super(Material.field_151576_e);
        this.func_149676_a(0.001f, 0.001f, 0.001f, 0.998f, 0.998f, 0.998f);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileScripted();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (currentItem != null && (currentItem.func_77973_b() == CustomItems.wand || currentItem.func_77973_b() == CustomItems.scripter)) {
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.ScriptBlock, null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        if (EventHooks.onScriptBlockInteract(tile.getBlock(), player, side.func_176745_a(), hitX, hitY, hitZ)) {
            return false;
        }
        return !tile.runScript(EnumScriptBlockType.INTERACT, "player", player, "event", new ScriptBlockEventInteract(side.func_176745_a(), hitX, hitY, hitZ));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        if (entity instanceof EntityPlayer && !world.field_72995_K) {
            NoppesUtilServer.sendOpenGui((EntityPlayer)entity, EnumGuiType.ScriptBlock, null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entityIn) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        EventHooks.onScriptBlockCollide(tile.getBlock(), entityIn);
        tile.runScript(EnumScriptBlockType.COLLIDED, "entity", entityIn);
    }

    public void func_176224_k(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        EventHooks.onScriptBlockRainFill(tile.getBlock());
        tile.runScript(EnumScriptBlockType.RAIN_FILL, new Object[0]);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        fallDistance = EventHooks.onScriptBlockFallenUpon(tile.getBlock(), entity, fallDistance);
        if (fallDistance <= 0.0f) {
            return;
        }
        ScriptBlockEventFallen eventold = new ScriptBlockEventFallen(fallDistance);
        if (tile.runScript(EnumScriptBlockType.FALLEN_UPON, "entity", entity, "event", eventold)) {
            return;
        }
        super.func_180658_a(world, pos, entity, eventold.getDistance());
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        EventHooks.onScriptBlockClicked(tile.getBlock(), player);
        tile.runScript(EnumScriptBlockType.CLICKED, "player", player);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        EventHooks.onScriptBlockBreak(tile.getBlock());
        tile.runScript(EnumScriptBlockType.REMOVED, new Object[0]);
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return super.removedByPlayer(world, pos, player, willHarvest);
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        if (EventHooks.onScriptBlockHarvest(tile.getBlock(), player)) {
            return false;
        }
        if (tile.runScript(EnumScriptBlockType.HARVESTED, "player", player, "event", new ScriptCancellableEvent())) {
            return false;
        }
        return super.removedByPlayer(world, pos, player, willHarvest);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K) {
            TileScripted tile = (TileScripted)world.func_175625_s(pos);
            if (EventHooks.onScriptBlockExploded(tile.getBlock())) {
                return;
            }
            if (tile.runScript(EnumScriptBlockType.EXPLODED, "event", new ScriptCancellableEvent())) {
                return;
            }
        }
        super.onBlockExploded(world, pos, explosion);
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        EventHooks.onScriptBlockNeighborChanged(tile.getBlock());
        tile.runScript(EnumScriptBlockType.NEIGHBOR_CHANGED, new Object[0]);
        int power = world.func_175676_y(pos);
        if (tile.prevPower != power && tile.powering <= 0) {
            EventHooks.onScriptBlockRedstonePower(tile.getBlock(), tile.prevPower, power);
            tile.runScript(EnumScriptBlockType.RESTONE_POWER, "event", new ScriptBlockEventRedstone(tile.prevPower, power));
            tile.prevPower = power;
        }
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_180656_a(IBlockAccess worldIn, BlockPos pos, IBlockState state, EnumFacing side) {
        return this.func_176211_b(worldIn, pos, state, side);
    }

    public int func_176211_b(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        return ((TileScripted)world.func_175625_s((BlockPos)pos)).activePowering;
    }

    public boolean isLadder(IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return ((TileScripted)world.func_175625_s((BlockPos)pos)).isLadder;
    }

    public boolean canCreatureSpawn(IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return true;
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        if (tile == null) {
            return 0;
        }
        return tile.lightValue;
    }

    public boolean canEntityDestroy(IBlockAccess world, BlockPos pos, Entity entity) {
        return super.canEntityDestroy(world, pos, entity);
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return super.getEnchantPowerBonus(world, pos);
    }

    public float func_176195_g(World worldIn, BlockPos pos) {
        return this.field_149782_v;
    }

    @Override
    public boolean isAllowed(EnumPacketServer e) {
        return e == EnumPacketServer.SaveTileEntity || e == EnumPacketServer.ScriptBlockDataSave;
    }
}

