/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import noppes.npcs.CustomItems;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.blocks.BlockNpcDoorInterface;
import noppes.npcs.blocks.tiles.TileScriptedDoor;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.constants.EnumScriptDoorType;
import noppes.npcs.scripted.events.ScriptBlockEventInteract;
import noppes.npcs.scripted.events.ScriptCancellableEvent;
import noppes.npcs.scripted.events.ScriptDoorEventRedstone;
import noppes.npcs.util.IPermission;

public class BlockScriptedDoor
extends BlockNpcDoorInterface
implements IPermission {
    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileScriptedDoor();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate1;
        if (world.field_72995_K) {
            return true;
        }
        BlockPos blockpos1 = state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate1 = pos.equals((Object)blockpos1) ? state : world.func_180495_p(blockpos1);
        if (iblockstate1.func_177230_c() != this) {
            return false;
        }
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (currentItem != null && (currentItem.func_77973_b() == CustomItems.wand || currentItem.func_77973_b() == CustomItems.scripter || currentItem.func_77973_b() == CustomItems.scriptedDoorTool)) {
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.ScriptDoor, null, blockpos1.func_177958_n(), blockpos1.func_177956_o(), blockpos1.func_177952_p());
            return true;
        }
        TileScriptedDoor tile = (TileScriptedDoor)world.func_175625_s(blockpos1);
        if (EventHooks.onScriptBlockInteract(tile.getBlock(), player, side.func_176745_a(), hitX, hitY, hitZ)) {
            return false;
        }
        if (tile.runScript(EnumScriptDoorType.INTERACT, "event", new ScriptBlockEventInteract(side.func_176745_a(), hitX, hitY, hitZ), "player", player)) {
            return false;
        }
        this.func_176512_a(world, blockpos1, iblockstate1.func_177229_b((IProperty)BlockDoor.field_176519_b).equals(false));
        return true;
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            BlockPos blockpos1 = pos.func_177977_b();
            IBlockState iblockstate1 = worldIn.func_180495_p(blockpos1);
            if (iblockstate1.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            } else if (neighborBlock != this) {
                this.func_176204_a(worldIn, blockpos1, iblockstate1, neighborBlock);
            }
        } else {
            boolean flag1 = false;
            BlockPos blockpos2 = pos.func_177984_a();
            IBlockState iblockstate2 = worldIn.func_180495_p(blockpos2);
            if (iblockstate2.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
                flag1 = true;
            }
            if (!World.func_175683_a((IBlockAccess)worldIn, (BlockPos)pos.func_177977_b())) {
                worldIn.func_175698_g(pos);
                flag1 = true;
                if (iblockstate2.func_177230_c() == this) {
                    worldIn.func_175698_g(blockpos2);
                }
            }
            if (flag1) {
                if (!worldIn.field_72995_K) {
                    this.func_176226_b(worldIn, pos, state, 0);
                }
            } else {
                boolean flag;
                TileScriptedDoor tile = (TileScriptedDoor)worldIn.func_175625_s(pos);
                if (!worldIn.field_72995_K) {
                    EventHooks.onScriptBlockNeighborChanged(tile.getBlock());
                }
                boolean bl = flag = worldIn.func_175640_z(pos) || worldIn.func_175640_z(blockpos2);
                if ((flag || neighborBlock.func_149744_f()) && neighborBlock != this && flag != (Boolean)iblockstate2.func_177229_b((IProperty)field_176522_N)) {
                    worldIn.func_180501_a(blockpos2, iblockstate2.func_177226_a((IProperty)field_176522_N, (Comparable)Boolean.valueOf(flag)), 2);
                    if (flag != (Boolean)state.func_177229_b((IProperty)field_176519_b)) {
                        int power = worldIn.func_175676_y(pos);
                        EventHooks.onScriptBlockRedstonePower(tile.getBlock(), tile.prevPower, power);
                        ScriptDoorEventRedstone evt = new ScriptDoorEventRedstone(tile.prevPower, power);
                        tile.prevPower = power;
                        if (tile.runScript(EnumScriptDoorType.POWERED, "event", evt)) {
                            return;
                        }
                        this.func_176512_a(worldIn, pos, flag);
                    }
                }
            }
        }
    }

    public void func_176512_a(World worldIn, BlockPos pos, boolean open) {
        TileScriptedDoor tile = (TileScriptedDoor)worldIn.func_175625_s(pos);
        if (EventHooks.onScriptBlockDoorToggle(tile.getBlock())) {
            return;
        }
        if (tile.runScript(EnumScriptDoorType.TOGGLED, "event", new ScriptCancellableEvent())) {
            return;
        }
        super.func_176512_a(worldIn, pos, open);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer playerIn) {
        IBlockState iblockstate1;
        if (world.field_72995_K) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        BlockPos blockpos1 = state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate1 = pos.equals((Object)blockpos1) ? state : world.func_180495_p(blockpos1);
        if (iblockstate1.func_177230_c() != this) {
            return;
        }
        TileScriptedDoor tile = (TileScriptedDoor)world.func_175625_s(blockpos1);
        EventHooks.onScriptBlockClicked(tile.getBlock(), playerIn);
        tile.runScript(EnumScriptDoorType.CLICKED, "player", playerIn);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        IBlockState iblockstate1;
        BlockPos blockpos1 = state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate1 = pos.equals((Object)blockpos1) ? state : world.func_180495_p(blockpos1);
        if (iblockstate1.func_177230_c() != this || world.field_72995_K) {
            return;
        }
        TileScriptedDoor tile = (TileScriptedDoor)world.func_175625_s(pos);
        EventHooks.onScriptBlockBreak(tile.getBlock());
        tile.runScript(EnumScriptDoorType.REMOVED, new Object[0]);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entityIn) {
        if (world.field_72995_K) {
            return;
        }
        TileScriptedDoor tile = (TileScriptedDoor)world.func_175625_s(pos);
        EventHooks.onScriptBlockCollide(tile.getBlock(), entityIn);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        IBlockState iblockstate1;
        BlockPos blockpos1 = state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate1 = pos.equals((Object)blockpos1) ? state : world.func_180495_p(blockpos1);
        if (player.field_71075_bZ.field_75098_d && iblockstate1.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER && iblockstate1.func_177230_c() == this) {
            TileScriptedDoor tile = (TileScriptedDoor)world.func_175625_s(blockpos1);
            if (!world.field_72995_K) {
                EventHooks.onScriptBlockHarvest(tile.getBlock(), player);
            }
            tile.runScript(EnumScriptDoorType.HARVESTED, "player", player);
            world.func_175698_g(blockpos1);
        }
    }

    @Override
    public boolean isAllowed(EnumPacketServer e) {
        return e == EnumPacketServer.ScriptDoorDataSave;
    }
}

