/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks.tiles;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import noppes.npcs.EventHooks;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.wrapper.BlockScriptedDoorWrapper;
import noppes.npcs.blocks.tiles.TileDoor;
import noppes.npcs.constants.EnumScriptDoorType;
import noppes.npcs.controllers.ScriptContainerOld;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.scripted.ScriptBlockDoor;
import noppes.npcs.scripted.ScriptWorld;

public class TileScriptedDoor
extends TileDoor
implements IUpdatePlayerListBox {
    public Map<Integer, ScriptContainerOld> scripts = new HashMap<Integer, ScriptContainerOld>();
    public boolean shouldRefreshData = false;
    public String scriptLanguage = "ECMAScript";
    public boolean enabled = false;
    public ScriptWorld dummyWorld;
    public ScriptBlockDoor dummyDoor;
    private IBlock blockDummy = null;
    public boolean hasInited = false;
    private short ticksExisted = 0;
    public int prevPower = 0;

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        if (world instanceof WorldServer) {
            this.dummyWorld = new ScriptWorld((WorldServer)world);
        }
    }

    public IBlock getBlock() {
        if (this.blockDummy == null) {
            this.blockDummy = new BlockScriptedDoorWrapper(this.func_145831_w(), this.func_145838_q(), this.func_174877_v());
        }
        return this.blockDummy;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.setNBT(compound);
    }

    public void setNBT(NBTTagCompound compound) {
        this.scripts = this.readScript(compound.func_150295_c("ScriptsContainers", 10));
        this.scriptLanguage = compound.func_74779_i("ScriptLanguage");
        this.enabled = compound.func_74767_n("ScriptEnabled");
        this.prevPower = compound.func_74762_e("BlockPrevPower");
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.getNBT(compound);
    }

    public NBTTagCompound getNBT(NBTTagCompound compound) {
        compound.func_74782_a("ScriptsContainers", (NBTBase)this.writeScript(this.scripts));
        compound.func_74778_a("ScriptLanguage", this.scriptLanguage);
        compound.func_74757_a("ScriptEnabled", this.enabled);
        compound.func_74768_a("BlockPrevPower", this.prevPower);
        return compound;
    }

    private Map<Integer, ScriptContainerOld> readScript(NBTTagList list) {
        HashMap<Integer, ScriptContainerOld> scripts = new HashMap<Integer, ScriptContainerOld>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compoundd = list.func_150305_b(i);
            ScriptContainerOld script = new ScriptContainerOld();
            script.readFromNBT(compoundd);
            scripts.put(compoundd.func_74762_e("Type"), script);
        }
        return scripts;
    }

    private NBTTagList writeScript(Map<Integer, ScriptContainerOld> scripts) {
        NBTTagList list = new NBTTagList();
        for (Integer type : scripts.keySet()) {
            NBTTagCompound compoundd = new NBTTagCompound();
            compoundd.func_74768_a("Type", type.intValue());
            ScriptContainerOld script = scripts.get(type);
            script.writeToNBT(compoundd);
            list.func_74742_a((NBTBase)compoundd);
        }
        return list;
    }

    public boolean runScript(EnumScriptDoorType type, Object ... obs) {
        ScriptContainerOld script;
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.hasInited) {
            this.hasInited = true;
            EventHooks.onScriptBlockInit(this.blockDummy);
            this.runScript(EnumScriptDoorType.INIT, new Object[0]);
        }
        if ((script = this.scripts.get(type.ordinal())) == null || script.errored || !script.hasCode()) {
            return false;
        }
        script.setEngine(this.scriptLanguage);
        if (script.engine == null) {
            return false;
        }
        if (this.dummyDoor == null) {
            this.dummyDoor = new ScriptBlockDoor(this.func_145831_w(), this.func_145838_q(), this.func_174877_v());
        }
        script.engine.put("door", this.dummyDoor);
        script.engine.put("world", this.dummyWorld);
        return ScriptController.Instance.runScript(script, obs);
    }

    private boolean isEnabled() {
        return this.enabled && ScriptController.HasStart && !this.field_145850_b.field_72995_K;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.ticksExisted = (short)(this.ticksExisted + 1);
        if (this.ticksExisted >= 10) {
            EventHooks.onScriptBlockUpdate(this.blockDummy);
            this.runScript(EnumScriptDoorType.TICK, new Object[0]);
            this.ticksExisted = 0;
        }
    }
}

