/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import com.google.common.collect.Maps;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityFlameFX;
import net.minecraft.client.particle.EntitySmokeFX;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import noppes.npcs.CommonProxy;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.ModelData;
import noppes.npcs.ModelPartData;
import noppes.npcs.PacketHandlerPlayer;
import noppes.npcs.blocks.BlockBanner;
import noppes.npcs.blocks.BlockBlood;
import noppes.npcs.blocks.BlockBuilder;
import noppes.npcs.blocks.BlockCarpentryBench;
import noppes.npcs.blocks.BlockCouchWood;
import noppes.npcs.blocks.BlockCouchWool;
import noppes.npcs.blocks.BlockLightable;
import noppes.npcs.blocks.BlockMailbox;
import noppes.npcs.blocks.BlockPlaceholder;
import noppes.npcs.blocks.BlockRotated;
import noppes.npcs.blocks.BlockTallLamp;
import noppes.npcs.blocks.BlockTombstone;
import noppes.npcs.blocks.BlockWallBanner;
import noppes.npcs.blocks.BlockWeaponRack;
import noppes.npcs.blocks.tiles.TileBanner;
import noppes.npcs.blocks.tiles.TileBarrel;
import noppes.npcs.blocks.tiles.TileBeam;
import noppes.npcs.blocks.tiles.TileBigSign;
import noppes.npcs.blocks.tiles.TileBlockAnvil;
import noppes.npcs.blocks.tiles.TileBlood;
import noppes.npcs.blocks.tiles.TileBook;
import noppes.npcs.blocks.tiles.TileCampfire;
import noppes.npcs.blocks.tiles.TileCandle;
import noppes.npcs.blocks.tiles.TileChair;
import noppes.npcs.blocks.tiles.TileCopy;
import noppes.npcs.blocks.tiles.TileCouchWood;
import noppes.npcs.blocks.tiles.TileCouchWool;
import noppes.npcs.blocks.tiles.TileCrate;
import noppes.npcs.blocks.tiles.TileDoor;
import noppes.npcs.blocks.tiles.TileLamp;
import noppes.npcs.blocks.tiles.TileMailbox;
import noppes.npcs.blocks.tiles.TilePedestal;
import noppes.npcs.blocks.tiles.TileScripted;
import noppes.npcs.blocks.tiles.TileShelf;
import noppes.npcs.blocks.tiles.TileSign;
import noppes.npcs.blocks.tiles.TileStool;
import noppes.npcs.blocks.tiles.TileTable;
import noppes.npcs.blocks.tiles.TileTallLamp;
import noppes.npcs.blocks.tiles.TileTombstone;
import noppes.npcs.blocks.tiles.TileWallBanner;
import noppes.npcs.blocks.tiles.TileWeaponRack;
import noppes.npcs.client.ClientEventHandler;
import noppes.npcs.client.ClientTickHandler;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.PacketHandlerClient;
import noppes.npcs.client.VersionChecker;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.controllers.PresetController;
import noppes.npcs.client.fx.EntityElementalStaffFX;
import noppes.npcs.client.fx.EntityEnderFX;
import noppes.npcs.client.fx.EntityRainbowFX;
import noppes.npcs.client.gui.GuiBlockBuilder;
import noppes.npcs.client.gui.GuiBlockCopy;
import noppes.npcs.client.gui.GuiBorderBlock;
import noppes.npcs.client.gui.GuiMerchantAdd;
import noppes.npcs.client.gui.GuiNpcDimension;
import noppes.npcs.client.gui.GuiNpcMobSpawner;
import noppes.npcs.client.gui.GuiNpcMobSpawnerMounter;
import noppes.npcs.client.gui.GuiNpcPather;
import noppes.npcs.client.gui.GuiNpcRedstoneBlock;
import noppes.npcs.client.gui.GuiNpcRemoteEditor;
import noppes.npcs.client.gui.GuiNpcWaypoint;
import noppes.npcs.client.gui.GuiScript;
import noppes.npcs.client.gui.GuiScriptBlock;
import noppes.npcs.client.gui.GuiScriptDoor;
import noppes.npcs.client.gui.global.GuiNPCManageBanks;
import noppes.npcs.client.gui.global.GuiNPCManageDialogs;
import noppes.npcs.client.gui.global.GuiNPCManageFactions;
import noppes.npcs.client.gui.global.GuiNPCManageLinkedNpc;
import noppes.npcs.client.gui.global.GuiNPCManageQuest;
import noppes.npcs.client.gui.global.GuiNPCManageTransporters;
import noppes.npcs.client.gui.global.GuiNpcManageRecipes;
import noppes.npcs.client.gui.global.GuiNpcQuestReward;
import noppes.npcs.client.gui.mainmenu.GuiNPCGlobalMainMenu;
import noppes.npcs.client.gui.mainmenu.GuiNPCInv;
import noppes.npcs.client.gui.mainmenu.GuiNpcAI;
import noppes.npcs.client.gui.mainmenu.GuiNpcAdvanced;
import noppes.npcs.client.gui.mainmenu.GuiNpcDisplay;
import noppes.npcs.client.gui.mainmenu.GuiNpcStats;
import noppes.npcs.client.gui.player.GuiBigSign;
import noppes.npcs.client.gui.player.GuiCrate;
import noppes.npcs.client.gui.player.GuiMailbox;
import noppes.npcs.client.gui.player.GuiMailmanWrite;
import noppes.npcs.client.gui.player.GuiNPCBankChest;
import noppes.npcs.client.gui.player.GuiNPCTrader;
import noppes.npcs.client.gui.player.GuiNpcCarpentryBench;
import noppes.npcs.client.gui.player.GuiNpcFollower;
import noppes.npcs.client.gui.player.GuiNpcFollowerHire;
import noppes.npcs.client.gui.player.GuiTransportSelection;
import noppes.npcs.client.gui.player.companion.GuiNpcCompanionInv;
import noppes.npcs.client.gui.player.companion.GuiNpcCompanionStats;
import noppes.npcs.client.gui.player.companion.GuiNpcCompanionTalents;
import noppes.npcs.client.gui.questtypes.GuiNpcQuestTypeItem;
import noppes.npcs.client.gui.roles.GuiNpcBankSetup;
import noppes.npcs.client.gui.roles.GuiNpcFollowerSetup;
import noppes.npcs.client.gui.roles.GuiNpcItemGiver;
import noppes.npcs.client.gui.roles.GuiNpcTraderSetup;
import noppes.npcs.client.gui.roles.GuiNpcTransporter;
import noppes.npcs.client.model.ModelBipedAlt;
import noppes.npcs.client.model.ModelNPCGolem;
import noppes.npcs.client.model.ModelNpcCrystal;
import noppes.npcs.client.model.ModelNpcDragon;
import noppes.npcs.client.model.ModelNpcSlime;
import noppes.npcs.client.model.ModelPlayerAlt;
import noppes.npcs.client.model.ModelSkirtArmor;
import noppes.npcs.client.renderer.RenderCustomNpc;
import noppes.npcs.client.renderer.RenderNPCInterface;
import noppes.npcs.client.renderer.RenderNPCPony;
import noppes.npcs.client.renderer.RenderNpcCrystal;
import noppes.npcs.client.renderer.RenderNpcDragon;
import noppes.npcs.client.renderer.RenderNpcSlime;
import noppes.npcs.client.renderer.RenderProjectile;
import noppes.npcs.client.renderer.TileEntityItemStackRendererAlt;
import noppes.npcs.client.renderer.blocks.BlockBannerRenderer;
import noppes.npcs.client.renderer.blocks.BlockBarrelRenderer;
import noppes.npcs.client.renderer.blocks.BlockBeamRenderer;
import noppes.npcs.client.renderer.blocks.BlockBigSignRenderer;
import noppes.npcs.client.renderer.blocks.BlockBloodRenderer;
import noppes.npcs.client.renderer.blocks.BlockBookRenderer;
import noppes.npcs.client.renderer.blocks.BlockCampfireRenderer;
import noppes.npcs.client.renderer.blocks.BlockCandleRenderer;
import noppes.npcs.client.renderer.blocks.BlockCarpentryBenchRenderer;
import noppes.npcs.client.renderer.blocks.BlockChairRenderer;
import noppes.npcs.client.renderer.blocks.BlockCopyRenderer;
import noppes.npcs.client.renderer.blocks.BlockCouchWoodRenderer;
import noppes.npcs.client.renderer.blocks.BlockCouchWoolRenderer;
import noppes.npcs.client.renderer.blocks.BlockCrateRenderer;
import noppes.npcs.client.renderer.blocks.BlockDoorRenderer;
import noppes.npcs.client.renderer.blocks.BlockLampRenderer;
import noppes.npcs.client.renderer.blocks.BlockMailboxRenderer;
import noppes.npcs.client.renderer.blocks.BlockPedestalRenderer;
import noppes.npcs.client.renderer.blocks.BlockScriptedRenderer;
import noppes.npcs.client.renderer.blocks.BlockShelfRenderer;
import noppes.npcs.client.renderer.blocks.BlockSignRenderer;
import noppes.npcs.client.renderer.blocks.BlockStoolRenderer;
import noppes.npcs.client.renderer.blocks.BlockTableRenderer;
import noppes.npcs.client.renderer.blocks.BlockTallLampRenderer;
import noppes.npcs.client.renderer.blocks.BlockTombstoneRenderer;
import noppes.npcs.client.renderer.blocks.BlockWallBannerRenderer;
import noppes.npcs.client.renderer.blocks.BlockWeaponRackRenderer;
import noppes.npcs.config.StringCache;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.containers.ContainerCarpentryBench;
import noppes.npcs.containers.ContainerCrate;
import noppes.npcs.containers.ContainerMail;
import noppes.npcs.containers.ContainerManageBanks;
import noppes.npcs.containers.ContainerManageRecipes;
import noppes.npcs.containers.ContainerNPCBankInterface;
import noppes.npcs.containers.ContainerNPCCompanion;
import noppes.npcs.containers.ContainerNPCFollower;
import noppes.npcs.containers.ContainerNPCFollowerHire;
import noppes.npcs.containers.ContainerNPCFollowerSetup;
import noppes.npcs.containers.ContainerNPCInv;
import noppes.npcs.containers.ContainerNPCTrader;
import noppes.npcs.containers.ContainerNPCTraderSetup;
import noppes.npcs.containers.ContainerNpcItemGiver;
import noppes.npcs.containers.ContainerNpcQuestReward;
import noppes.npcs.containers.ContainerNpcQuestTypeItem;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPC64x32;
import noppes.npcs.entity.EntityNPCGolem;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.EntityNpcCrystal;
import noppes.npcs.entity.EntityNpcDragon;
import noppes.npcs.entity.EntityNpcPony;
import noppes.npcs.entity.EntityNpcSlime;
import noppes.npcs.entity.EntityProjectile;
import tconstruct.client.tabs.InventoryTabFactions;
import tconstruct.client.tabs.InventoryTabQuests;
import tconstruct.client.tabs.InventoryTabVanilla;
import tconstruct.client.tabs.TabRegistry;

public class ClientProxy
extends CommonProxy {
    public static KeyBinding QuestLog;
    public static KeyBinding SceneMain;
    public static KeyBinding SceneReset;
    public static KeyBinding SceneNext;
    public static KeyBinding ScenePrev;
    public static FontContainer Font;
    private ModelSkirtArmor model = new ModelSkirtArmor();

    @Override
    public void load() {
        Font = new FontContainer(CustomNpcs.FontType, CustomNpcs.FontSize);
        this.createFolders();
        CustomNpcs.Channel.register((Object)new PacketHandlerClient());
        CustomNpcs.ChannelPlayer.register((Object)new PacketHandlerPlayer());
        new MusicController();
        new TileEntityItemStackRendererAlt();
        FMLCommonHandler.instance().bus().register((Object)new ClientTickHandler());
        Minecraft mc = Minecraft.func_71410_x();
        QuestLog = new KeyBinding("Quest Log", 38, "key.categories.gameplay");
        if (CustomNpcs.SceneButtonsEnabled) {
            SceneMain = new KeyBinding("Scene start/pause", 82, "key.categories.gameplay");
            SceneReset = new KeyBinding("Scene reset", 83, "key.categories.gameplay");
            SceneNext = new KeyBinding("Scene forward", 78, "key.categories.gameplay");
            ScenePrev = new KeyBinding("Scene back", 74, "key.categories.gameplay");
            ClientRegistry.registerKeyBinding((KeyBinding)SceneMain);
            ClientRegistry.registerKeyBinding((KeyBinding)SceneReset);
            ClientRegistry.registerKeyBinding((KeyBinding)SceneNext);
            ClientRegistry.registerKeyBinding((KeyBinding)ScenePrev);
        }
        ClientRegistry.registerKeyBinding((KeyBinding)QuestLog);
        mc.field_71474_y.func_74300_a();
        new PresetController(CustomNpcs.Dir);
        if (CustomNpcs.EnableUpdateChecker) {
            VersionChecker checker = new VersionChecker();
            checker.start();
        }
        this.blockIgnoreBlockstate(CustomItems.pedestal, new IProperty[]{BlockRotated.DAMAGE});
        this.blockIgnoreBlockstate(CustomItems.beam, new IProperty[]{BlockRotated.DAMAGE});
        this.blockIgnoreBlockstate(CustomItems.crate, new IProperty[]{BlockRotated.DAMAGE});
        this.blockIgnoreBlockstate(CustomItems.book, new IProperty[]{BlockRotated.DAMAGE});
        this.blockIgnoreBlockstate(CustomItems.stool, new IProperty[]{BlockRotated.DAMAGE});
        this.blockIgnoreBlockstate(CustomItems.chair, new IProperty[]{BlockRotated.DAMAGE});
        this.blockIgnoreBlockstate(CustomItems.sign, new IProperty[]{BlockRotated.DAMAGE});
        this.blockIgnoreBlockstate(CustomItems.barrel, new IProperty[]{BlockRotated.DAMAGE});
        this.blockIgnoreBlockstate(CustomItems.couchWood, new IProperty[]{BlockCouchWood.DAMAGE});
        this.blockIgnoreBlockstate(CustomItems.couchWool, new IProperty[]{BlockCouchWool.DAMAGE});
        this.blockIgnoreBlockstate(CustomItems.tombstone, new IProperty[]{BlockTombstone.DAMAGE});
        this.blockIgnoreBlockstate(CustomItems.bigsign, new IProperty[]{BlockRotated.DAMAGE});
        this.blockIgnoreBlockstate(CustomItems.table, new IProperty[]{BlockRotated.DAMAGE});
        this.blockIgnoreBlockstate(CustomItems.shelf, new IProperty[]{BlockRotated.DAMAGE});
        this.blockIgnoreBlockstate(CustomItems.wallBanner, new IProperty[]{BlockWallBanner.DAMAGE});
        this.blockIgnoreBlockstate(CustomItems.banner, new IProperty[]{BlockBanner.DAMAGE, BlockBanner.TOP});
        this.blockIgnoreBlockstate(CustomItems.weaponsRack, new IProperty[]{BlockWeaponRack.DAMAGE, BlockWeaponRack.IS_TOP});
        this.blockIgnoreBlockstate(CustomItems.tallLamp, new IProperty[]{BlockTallLamp.DAMAGE, BlockTallLamp.IS_TOP});
        this.blockIgnoreBlockstate(CustomItems.mailbox, new IProperty[]{BlockMailbox.ROTATION, BlockMailbox.TYPE});
        this.blockIgnoreBlockstate(CustomItems.carpentyBench, new IProperty[]{BlockCarpentryBench.ROTATION, BlockCarpentryBench.TYPE});
        this.blockIgnoreBlockstate(CustomItems.lamp, new IProperty[]{BlockRotated.DAMAGE, BlockLightable.LIT});
        this.blockIgnoreBlockstate(CustomItems.lamp_unlit, new IProperty[]{BlockRotated.DAMAGE, BlockLightable.LIT});
        this.blockIgnoreBlockstate(CustomItems.candle, new IProperty[]{BlockRotated.DAMAGE, BlockLightable.LIT});
        this.blockIgnoreBlockstate(CustomItems.candle_unlit, new IProperty[]{BlockRotated.DAMAGE, BlockLightable.LIT});
        this.blockIgnoreBlockstate(CustomItems.campfire, new IProperty[]{BlockRotated.DAMAGE, BlockLightable.LIT});
        this.blockIgnoreBlockstate(CustomItems.campfire_unlit, new IProperty[]{BlockRotated.DAMAGE, BlockLightable.LIT});
        this.blockIgnoreBlockstate(CustomItems.scriptedDoor, new IProperty[]{BlockDoor.field_176522_N});
        this.blockIgnoreBlockstate(CustomItems.builder, new IProperty[]{BlockBuilder.ROTATION});
        ModelLoader.setCustomStateMapper((Block)CustomItems.placeholder, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                LinkedHashMap linkedhashmap = Maps.newLinkedHashMap((Map)state.func_177228_b());
                String s = BlockPlaceholder.DAMAGE.func_177702_a((Comparable)linkedhashmap.remove(BlockPlaceholder.DAMAGE));
                return new ModelResourceLocation("customnpcs:npcPlaceholder_" + s, this.func_178131_a(linkedhashmap));
            }
        });
        ModelLoader.setCustomStateMapper((Block)CustomItems.blood, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                LinkedHashMap linkedhashmap = Maps.newLinkedHashMap((Map)state.func_177228_b());
                String s = BlockBlood.TYPE.func_177702_a((Comparable)linkedhashmap.remove(BlockBlood.TYPE));
                return new ModelResourceLocation("customnpcs:npcBloodBlock_" + s, this.func_178131_a(linkedhashmap));
            }
        });
    }

    @Override
    public void postload() {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        if (CustomNpcs.InventoryGuiEnabled) {
            MinecraftForge.EVENT_BUS.register((Object)new TabRegistry());
            if (TabRegistry.getTabList().size() < 2) {
                TabRegistry.registerTab(new InventoryTabVanilla());
            }
            TabRegistry.registerTab(new InventoryTabFactions());
            TabRegistry.registerTab(new InventoryTabQuests());
        }
        RenderingRegistry.registerEntityRenderingHandler(EntityNpcPony.class, (Render)new RenderNPCPony());
        RenderingRegistry.registerEntityRenderingHandler(EntityNpcCrystal.class, (Render)new RenderNpcCrystal(new ModelNpcCrystal(0.5f)));
        RenderingRegistry.registerEntityRenderingHandler(EntityNpcDragon.class, (Render)new RenderNpcDragon(new ModelNpcDragon(0.0f), 0.5f));
        RenderingRegistry.registerEntityRenderingHandler(EntityNpcSlime.class, (Render)new RenderNpcSlime(new ModelNpcSlime(16), new ModelNpcSlime(0), 0.25f));
        RenderingRegistry.registerEntityRenderingHandler(EntityProjectile.class, (Render)new RenderProjectile());
        RenderingRegistry.registerEntityRenderingHandler(EntityCustomNpc.class, (Render)new RenderCustomNpc((ModelBiped)new ModelPlayerAlt(0.0f, false)));
        RenderingRegistry.registerEntityRenderingHandler(EntityNPC64x32.class, (Render)new RenderCustomNpc(new ModelBipedAlt(0.0f)));
        RenderingRegistry.registerEntityRenderingHandler(EntityNPCGolem.class, (Render)new RenderNPCInterface((ModelBase)new ModelNPCGolem(0.0f), 0.0f));
        ClientRegistry.bindTileEntitySpecialRenderer(TileBlockAnvil.class, (TileEntitySpecialRenderer)new BlockCarpentryBenchRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileMailbox.class, (TileEntitySpecialRenderer)new BlockMailboxRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileScripted.class, (TileEntitySpecialRenderer)new BlockScriptedRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileDoor.class, (TileEntitySpecialRenderer)new BlockDoorRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileBlood.class, (TileEntitySpecialRenderer)new BlockBloodRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileCopy.class, (TileEntitySpecialRenderer)new BlockCopyRenderer());
        if (!CustomNpcs.DisableExtraBlock) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileBanner.class, (TileEntitySpecialRenderer)new BlockBannerRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileWallBanner.class, (TileEntitySpecialRenderer)new BlockWallBannerRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileTallLamp.class, (TileEntitySpecialRenderer)new BlockTallLampRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileChair.class, (TileEntitySpecialRenderer)new BlockChairRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileWeaponRack.class, (TileEntitySpecialRenderer)new BlockWeaponRackRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileCrate.class, (TileEntitySpecialRenderer)new BlockCrateRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileCouchWool.class, (TileEntitySpecialRenderer)new BlockCouchWoolRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileCouchWood.class, (TileEntitySpecialRenderer)new BlockCouchWoodRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileTable.class, (TileEntitySpecialRenderer)new BlockTableRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileCandle.class, (TileEntitySpecialRenderer)new BlockCandleRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileLamp.class, (TileEntitySpecialRenderer)new BlockLampRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileStool.class, (TileEntitySpecialRenderer)new BlockStoolRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileBigSign.class, (TileEntitySpecialRenderer)new BlockBigSignRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileBarrel.class, (TileEntitySpecialRenderer)new BlockBarrelRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileCampfire.class, (TileEntitySpecialRenderer)new BlockCampfireRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileTombstone.class, (TileEntitySpecialRenderer)new BlockTombstoneRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileShelf.class, (TileEntitySpecialRenderer)new BlockShelfRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileSign.class, (TileEntitySpecialRenderer)new BlockSignRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileBeam.class, (TileEntitySpecialRenderer)new BlockBeamRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileBook.class, (TileEntitySpecialRenderer)new BlockBookRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TilePedestal.class, (TileEntitySpecialRenderer)new BlockPedestalRenderer());
        }
    }

    private void blockIgnoreBlockstate(Block block, IProperty ... properties) {
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(properties).func_178441_a());
    }

    private void createFolders() {
        File json;
        File check;
        File file = new File(CustomNpcs.Dir, "assets/customnpcs");
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(check = new File(file, "sounds")).exists()) {
            check.mkdir();
        }
        if (!(json = new File(file, "sounds.json")).exists()) {
            try {
                json.createNewFile();
                BufferedWriter writer = new BufferedWriter(new FileWriter(json));
                writer.write("{\n\n}");
                writer.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (!(check = new File(file, "textures")).exists()) {
            check.mkdir();
        }
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)new CustomNpcResourceListener());
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID > EnumGuiType.values().length) {
            return null;
        }
        EnumGuiType gui = EnumGuiType.values()[ID];
        EntityNPCInterface npc = NoppesUtil.getLastNpc();
        Container container = this.getContainer(gui, player, x, y, z, npc);
        return this.getGui(npc, gui, container, x, y, z);
    }

    private GuiScreen getGui(EntityNPCInterface npc, EnumGuiType gui, Container container, int x, int y, int z) {
        if (gui == EnumGuiType.MainMenuDisplay) {
            if (npc != null) {
                return new GuiNpcDisplay(npc);
            }
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Unable to find npc"));
        } else {
            if (gui == EnumGuiType.MainMenuStats) {
                return new GuiNpcStats(npc);
            }
            if (gui == EnumGuiType.MainMenuInv) {
                return new GuiNPCInv(npc, (ContainerNPCInv)container);
            }
            if (gui == EnumGuiType.MainMenuAdvanced) {
                return new GuiNpcAdvanced(npc);
            }
            if (gui == EnumGuiType.QuestReward) {
                return new GuiNpcQuestReward(npc, (ContainerNpcQuestReward)container);
            }
            if (gui == EnumGuiType.QuestItem) {
                return new GuiNpcQuestTypeItem(npc, (ContainerNpcQuestTypeItem)container);
            }
            if (gui == EnumGuiType.MovingPath) {
                return new GuiNpcPather(npc);
            }
            if (gui == EnumGuiType.ManageFactions) {
                return new GuiNPCManageFactions(npc);
            }
            if (gui == EnumGuiType.ManageLinked) {
                return new GuiNPCManageLinkedNpc(npc);
            }
            if (gui == EnumGuiType.BuilderBlock) {
                return new GuiBlockBuilder(x, y, z);
            }
            if (gui == EnumGuiType.ManageTransport) {
                return new GuiNPCManageTransporters(npc);
            }
            if (gui == EnumGuiType.ManageRecipes) {
                return new GuiNpcManageRecipes(npc, (ContainerManageRecipes)container);
            }
            if (gui == EnumGuiType.ManageDialogs) {
                return new GuiNPCManageDialogs(npc);
            }
            if (gui == EnumGuiType.ManageQuests) {
                return new GuiNPCManageQuest(npc);
            }
            if (gui == EnumGuiType.ManageBanks) {
                return new GuiNPCManageBanks(npc, (ContainerManageBanks)container);
            }
            if (gui == EnumGuiType.MainMenuGlobal) {
                return new GuiNPCGlobalMainMenu(npc);
            }
            if (gui == EnumGuiType.MainMenuAI) {
                return new GuiNpcAI(npc);
            }
            if (gui == EnumGuiType.PlayerFollowerHire) {
                return new GuiNpcFollowerHire(npc, (ContainerNPCFollowerHire)container);
            }
            if (gui == EnumGuiType.PlayerFollower) {
                return new GuiNpcFollower(npc, (ContainerNPCFollower)container);
            }
            if (gui == EnumGuiType.PlayerTrader) {
                return new GuiNPCTrader(npc, (ContainerNPCTrader)container);
            }
            if (gui == EnumGuiType.PlayerBankSmall || gui == EnumGuiType.PlayerBankUnlock || gui == EnumGuiType.PlayerBankUprade || gui == EnumGuiType.PlayerBankLarge) {
                return new GuiNPCBankChest(npc, (ContainerNPCBankInterface)container);
            }
            if (gui == EnumGuiType.PlayerTransporter) {
                return new GuiTransportSelection(npc);
            }
            if (gui == EnumGuiType.Script) {
                return new GuiScript(npc);
            }
            if (gui == EnumGuiType.ScriptBlock) {
                return new GuiScriptBlock(x, y, z);
            }
            if (gui == EnumGuiType.ScriptDoor) {
                return new GuiScriptDoor(x, y, z);
            }
            if (gui == EnumGuiType.PlayerAnvil) {
                return new GuiNpcCarpentryBench((ContainerCarpentryBench)container);
            }
            if (gui == EnumGuiType.SetupFollower) {
                return new GuiNpcFollowerSetup(npc, (ContainerNPCFollowerSetup)container);
            }
            if (gui == EnumGuiType.SetupItemGiver) {
                return new GuiNpcItemGiver(npc, (ContainerNpcItemGiver)container);
            }
            if (gui == EnumGuiType.SetupTrader) {
                return new GuiNpcTraderSetup(npc, (ContainerNPCTraderSetup)container);
            }
            if (gui == EnumGuiType.SetupTransporter) {
                return new GuiNpcTransporter(npc);
            }
            if (gui == EnumGuiType.SetupBank) {
                return new GuiNpcBankSetup(npc);
            }
            if (gui == EnumGuiType.NpcRemote && Minecraft.func_71410_x().field_71462_r == null) {
                return new GuiNpcRemoteEditor();
            }
            if (gui == EnumGuiType.PlayerMailman) {
                return new GuiMailmanWrite((ContainerMail)container, x == 1, y == 1);
            }
            if (gui == EnumGuiType.PlayerMailbox) {
                return new GuiMailbox();
            }
            if (gui == EnumGuiType.MerchantAdd) {
                return new GuiMerchantAdd();
            }
            if (gui == EnumGuiType.Crate) {
                return new GuiCrate((ContainerCrate)container);
            }
            if (gui == EnumGuiType.NpcDimensions) {
                return new GuiNpcDimension();
            }
            if (gui == EnumGuiType.Border) {
                return new GuiBorderBlock(x, y, z);
            }
            if (gui == EnumGuiType.BigSign) {
                return new GuiBigSign(x, y, z);
            }
            if (gui == EnumGuiType.RedstoneBlock) {
                return new GuiNpcRedstoneBlock(x, y, z);
            }
            if (gui == EnumGuiType.MobSpawner) {
                return new GuiNpcMobSpawner(x, y, z);
            }
            if (gui == EnumGuiType.CopyBlock) {
                return new GuiBlockCopy(x, y, z);
            }
            if (gui == EnumGuiType.MobSpawnerMounter) {
                return new GuiNpcMobSpawnerMounter(x, y, z);
            }
            if (gui == EnumGuiType.Waypoint) {
                return new GuiNpcWaypoint(x, y, z);
            }
            if (gui == EnumGuiType.Companion) {
                return new GuiNpcCompanionStats(npc);
            }
            if (gui == EnumGuiType.CompanionTalent) {
                return new GuiNpcCompanionTalents(npc);
            }
            if (gui == EnumGuiType.CompanionInv) {
                return new GuiNpcCompanionInv(npc, (ContainerNPCCompanion)container);
            }
        }
        return null;
    }

    @Override
    public void openGui(int i, int j, int k, EnumGuiType gui, EntityPlayer player) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71439_g != player) {
            return;
        }
        GuiScreen guiscreen = this.getGui(null, gui, null, i, j, k);
        if (guiscreen != null) {
            minecraft.func_147108_a(guiscreen);
        }
    }

    @Override
    public void openGui(EntityNPCInterface npc, EnumGuiType gui) {
        this.openGui(npc, gui, 0, 0, 0);
    }

    @Override
    public void openGui(EntityNPCInterface npc, EnumGuiType gui, int x, int y, int z) {
        Minecraft minecraft = Minecraft.func_71410_x();
        Container container = this.getContainer(gui, (EntityPlayer)minecraft.field_71439_g, x, y, z, npc);
        GuiScreen guiscreen = this.getGui(npc, gui, container, x, y, z);
        if (guiscreen != null) {
            minecraft.func_147108_a(guiscreen);
        }
    }

    @Override
    public void openGui(EntityPlayer player, Object guiscreen) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (!player.field_70170_p.field_72995_K || !(guiscreen instanceof GuiScreen)) {
            return;
        }
        if (guiscreen != null) {
            minecraft.func_147108_a((GuiScreen)guiscreen);
        }
    }

    @Override
    public void spawnParticle(EntityLivingBase player, String string, Object ... ob) {
        block4: {
            Random rand;
            double height;
            Minecraft minecraft;
            ModelPartData particles;
            block5: {
                block3: {
                    if (!string.equals("Spell")) break block3;
                    int color = (Integer)ob[0];
                    int number = (Integer)ob[1];
                    for (int i = 0; i < number; ++i) {
                        Random rand2 = player.field_70170_p.field_73012_v;
                        double x = (rand2.nextDouble() - 0.5) * (double)player.field_70130_N;
                        double y = player.func_70047_e();
                        double z = (rand2.nextDouble() - 0.5) * (double)player.field_70130_N;
                        double f = (rand2.nextDouble() - 0.5) * 2.0;
                        double f1 = -rand2.nextDouble();
                        double f2 = (rand2.nextDouble() - 0.5) * 2.0;
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityElementalStaffFX(player, x, y, z, f, f1, f2, color));
                    }
                    break block4;
                }
                if (!string.equals("ModelData")) break block4;
                ModelData data = (ModelData)ob[0];
                particles = (ModelPartData)ob[1];
                EntityCustomNpc npc = (EntityCustomNpc)player;
                minecraft = Minecraft.func_71410_x();
                height = npc.func_70033_W() + (double)data.getBodyY();
                rand = npc.func_70681_au();
                if (particles.type != 0) break block5;
                for (int i = 0; i < 2; ++i) {
                    EntityEnderFX fx = new EntityEnderFX(npc, (rand.nextDouble() - 0.5) * (double)player.field_70130_N, rand.nextDouble() * (double)player.field_70131_O - height - 0.25, (rand.nextDouble() - 0.5) * (double)player.field_70130_N, (rand.nextDouble() - 0.5) * 2.0, -rand.nextDouble(), (rand.nextDouble() - 0.5) * 2.0, particles);
                    minecraft.field_71452_i.func_78873_a((EntityFX)fx);
                }
                break block4;
            }
            if (particles.type != 1) break block4;
            for (int i = 0; i < 2; ++i) {
                double x = player.field_70165_t + (rand.nextDouble() - 0.5) * 0.9;
                double y = player.field_70163_u + rand.nextDouble() * 1.9 - 0.25 - height;
                double z = player.field_70161_v + (rand.nextDouble() - 0.5) * 0.9;
                double f = (rand.nextDouble() - 0.5) * 2.0;
                double f1 = -rand.nextDouble();
                double f2 = (rand.nextDouble() - 0.5) * 2.0;
                minecraft.field_71452_i.func_78873_a((EntityFX)new EntityRainbowFX(player.field_70170_p, x, y, z, f, f1, f2));
            }
        }
    }

    @Override
    public ModelBiped getSkirtModel() {
        return this.model;
    }

    @Override
    public boolean hasClient() {
        return true;
    }

    @Override
    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static void bindTexture(ResourceLocation location) {
        try {
            if (location == null) {
                return;
            }
            TextureManager manager = Minecraft.func_71410_x().func_110434_K();
            ITextureObject ob = manager.func_110581_b(location);
            if (ob == null) {
                ob = new SimpleTexture(location);
                manager.func_110579_a(location, ob);
            }
            GlStateManager.func_179144_i((int)ob.func_110552_b());
        }
        catch (NullPointerException ex) {
        }
        catch (ReportedException reportedException) {
            // empty catch block
        }
    }

    @Override
    public void spawnParticle(EnumParticleTypes particle, double x, double y, double z, double motionX, double motionY, double motionZ, float scale) {
        Minecraft mc = Minecraft.func_71410_x();
        double xx = mc.func_175606_aa().field_70165_t - x;
        double yy = mc.func_175606_aa().field_70163_u - y;
        double zz = mc.func_175606_aa().field_70161_v - z;
        if (xx * xx + yy * yy + zz * zz > 256.0) {
            return;
        }
        EntityFX fx = mc.field_71452_i.func_178927_a(particle.func_179348_c(), x, y, z, motionX, motionY, motionZ, new int[0]);
        if (fx == null) {
            return;
        }
        if (particle == EnumParticleTypes.FLAME) {
            ObfuscationReflectionHelper.setPrivateValue(EntityFlameFX.class, (Object)((EntityFlameFX)fx), (Object)Float.valueOf(scale), (int)0);
        } else if (particle == EnumParticleTypes.SMOKE_NORMAL) {
            ObfuscationReflectionHelper.setPrivateValue(EntitySmokeFX.class, (Object)((EntitySmokeFX)fx), (Object)Float.valueOf(scale), (int)0);
        }
    }

    @Override
    public void registerItem(Item item, String name, int meta) {
        ModelResourceLocation location = new ModelResourceLocation("customnpcs:" + name, "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)location);
    }

    @Override
    public void registerBlock(Block block, String name, int meta, Class<? extends ItemBlock> itemclass, boolean seperateMetadata) {
        super.registerBlock(block, name, meta, itemclass, seperateMetadata);
        this.registerItems(GameRegistry.findItem((String)"customnpcs", (String)name), name, meta, seperateMetadata);
    }

    public void registerItems(Item item, String name, int meta, boolean seperate) {
        if (meta > 0) {
            item.func_77627_a(true);
            for (int i = 0; i <= meta; ++i) {
                String metaname = name;
                if (seperate) {
                    metaname = metaname + "_" + i;
                    ModelLoader.addVariantName((Item)item, (String[])new String[]{"customnpcs:" + metaname});
                }
                this.registerItem(item, metaname, i);
            }
        } else {
            this.registerItem(item, name, 0);
        }
    }

    public static class FontContainer {
        private StringCache textFont = null;
        public boolean useCustomFont = true;

        private FontContainer() {
        }

        public FontContainer(String fontType, int fontSize) {
            this.textFont = new StringCache();
            this.textFont.setDefaultFont("Arial", fontSize, true);
            this.useCustomFont = !fontType.equalsIgnoreCase("minecraft");
            try {
                if (!this.useCustomFont || fontType.isEmpty() || fontType.equalsIgnoreCase("default")) {
                    this.textFont.setCustomFont(new ResourceLocation("customnpcs", "OpenSans.ttf"), fontSize, true);
                } else {
                    this.textFont.setDefaultFont(fontType, fontSize, true);
                }
            }
            catch (Exception e) {
                LogWriter.info("Failed loading font so using Arial");
            }
        }

        public int height() {
            if (this.useCustomFont) {
                return this.textFont.fontHeight;
            }
            return Minecraft.func_71410_x().field_71466_p.field_78288_b;
        }

        public int width(String text) {
            if (this.useCustomFont) {
                return this.textFont.getStringWidth(text);
            }
            return Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
        }

        public FontContainer copy() {
            FontContainer font = new FontContainer();
            font.textFont = this.textFont;
            font.useCustomFont = this.useCustomFont;
            return font;
        }

        public void drawString(String text, int x, int y, int color) {
            if (this.useCustomFont) {
                this.textFont.renderString(text, x, y, color, true);
                this.textFont.renderString(text, x, y, color, false);
            } else {
                Minecraft.func_71410_x().field_71466_p.func_175063_a(text, (float)x, (float)y, color);
            }
        }

        public String getName() {
            if (!this.useCustomFont) {
                return "Minecraft";
            }
            return this.textFont.usedFont().getFontName();
        }
    }
}

