/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.model;

import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.StatCollector;
import noppes.npcs.ModelPartData;
import noppes.npcs.client.gui.model.GuiCreationExtra;
import noppes.npcs.client.gui.model.GuiCreationScreenInterface;
import noppes.npcs.client.gui.model.GuiModelColor;
import noppes.npcs.client.gui.util.GuiButtonBiDirectional;
import noppes.npcs.client.gui.util.GuiColorButton;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcButtonYesNo;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.entity.EntityNPCInterface;

public class GuiCreationParts
extends GuiCreationScreenInterface
implements ITextfieldListener,
ICustomScrollListener {
    private GuiCustomScroll scroll;
    private GuiPart[] parts = new GuiPart[]{new GuiPart(EnumParts.EARS).setTypes(new String[]{"gui.none", "gui.normal", "ears.bunny"}), new GuiPartHorns(), new GuiPartHair(), new GuiPart(EnumParts.MOHAWK).setTypes(new String[]{"gui.none", "1", "2"}).noPlayerOptions(), new GuiPartSnout(), new GuiPartBeard(), new GuiPart(EnumParts.FIN).setTypes(new String[]{"gui.none", "fin.shark", "fin.reptile"}), new GuiPart(EnumParts.BREASTS).setTypes(new String[]{"gui.none", "1", "2", "3"}).noPlayerOptions(), new GuiPart(EnumParts.WINGS).setTypes(new String[]{"gui.none", "1", "2", "3"}), new GuiPartClaws(), new GuiPart(EnumParts.SKIRT).setTypes(new String[]{"gui.none", "gui.normal"}).noPlayerOptions(), new GuiPartLegs(), new GuiPartTail()};
    private static int selected = 0;

    public GuiCreationParts(EntityNPCInterface npc) {
        super(npc);
        this.active = 2;
        this.closeOnEsc = false;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.entity != null) {
            this.openGui(new GuiCreationExtra(this.npc));
            return;
        }
        if (this.scroll == null) {
            ArrayList<String> list = new ArrayList<String>();
            for (GuiPart part : this.parts) {
                list.add(StatCollector.func_74838_a((String)("part." + part.part.name)));
            }
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setUnsortedList(list);
        }
        this.scroll.guiLeft = this.guiLeft;
        this.scroll.guiTop = this.guiTop + 46;
        this.scroll.setSize(100, this.ySize - 74);
        this.addScroll(this.scroll);
        if (this.parts[selected] != null) {
            this.scroll.setSelected(StatCollector.func_74838_a((String)("part." + this.parts[GuiCreationParts.selected].part.name)));
            this.parts[selected].initGui();
        }
    }

    @Override
    protected void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        if (this.parts[selected] != null) {
            this.parts[selected].actionPerformed(btn);
        }
    }

    @Override
    public void unFocused(GuiNpcTextField textfield) {
        if (textfield.id == 23) {
            // empty if block
        }
    }

    @Override
    public void customScrollClicked(int i, int j, int k, GuiCustomScroll scroll) {
        if (scroll.selected >= 0) {
            selected = scroll.selected;
            this.func_73866_w_();
        }
    }

    class GuiPartLegs
    extends GuiPart {
        public GuiPartLegs() {
            super(EnumParts.LEGS);
            this.types = new String[]{"gui.none", "gui.normal", "legs.naga", "legs.spider", "legs.horse", "legs.mermaid", "legs.digitigrade"};
            this.canBeDeleted = false;
        }

        @Override
        public int initGui() {
            this.hasPlayerOption = this.data.type == 1 || this.data.type == 5;
            return super.initGui();
        }

        @Override
        protected void actionPerformed(GuiButton btn) {
            if (btn.field_146127_k == 20) {
                int i = ((GuiNpcButton)btn).getValue();
                this.data.playerTexture = i <= 1;
            }
            super.actionPerformed(btn);
        }
    }

    class GuiPartClaws
    extends GuiPart {
        public GuiPartClaws() {
            super(EnumParts.CLAWS);
            this.types = new String[]{"gui.none", "gui.show"};
        }

        @Override
        public int initGui() {
            int y = super.initGui();
            if (this.data == null) {
                return y;
            }
            GuiCreationParts.this.addLabel(new GuiNpcLabel(22, "gui.pattern", GuiCreationParts.this.guiLeft + 102, y + 5, 0xFFFFFF));
            GuiCreationParts.this.addButton(new GuiButtonBiDirectional(22, GuiCreationParts.this.guiLeft + 145, y, 100, 20, new String[]{"gui.both", "gui.left", "gui.right"}, this.data.pattern));
            return y;
        }
    }

    class GuiPartBeard
    extends GuiPart {
        public GuiPartBeard() {
            super(EnumParts.BEARD);
            this.types = new String[]{"gui.none", "1", "2", "3", "4"};
            this.noPlayerTypes();
        }
    }

    class GuiPartSnout
    extends GuiPart {
        public GuiPartSnout() {
            super(EnumParts.SNOUT);
            this.types = new String[]{"gui.none", "snout.small", "snout.medium", "snout.large", "snout.bunny", "snout.beak"};
        }
    }

    class GuiPartHair
    extends GuiPart {
        public GuiPartHair() {
            super(EnumParts.HAIR);
            this.types = new String[]{"gui.none", "1", "2", "3", "4"};
            this.noPlayerTypes();
        }
    }

    class GuiPartHorns
    extends GuiPart {
        public GuiPartHorns() {
            super(EnumParts.HORNS);
            this.types = new String[]{"gui.none", "horns.bull", "horns.antlers", "horns.antenna"};
        }

        @Override
        public int initGui() {
            int y = super.initGui();
            if (this.data != null && this.data.type == 2) {
                GuiCreationParts.this.addLabel(new GuiNpcLabel(22, "gui.pattern", GuiCreationParts.this.guiLeft + 102, y + 5, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiButtonBiDirectional(22, GuiCreationParts.this.guiLeft + 145, y, 100, 20, new String[]{"1", "2"}, this.data.pattern));
            }
            return y;
        }
    }

    class GuiPartTail
    extends GuiPart {
        public GuiPartTail() {
            super(EnumParts.TAIL);
            this.types = new String[]{"gui.none", "part.tail", "tail.dragon", "tail.horse", "tail.squirrel", "tail.fin", "tail.rodent"};
        }

        @Override
        public int initGui() {
            this.data = GuiCreationParts.this.playerdata.getPartData(this.part);
            this.hasPlayerOption = this.data != null && (this.data.type == 0 || this.data.type == 1);
            return super.initGui();
        }
    }

    class GuiPart {
        EnumParts part;
        private int paterns = 0;
        protected String[] types = new String[]{"gui.none"};
        protected ModelPartData data;
        protected boolean hasPlayerOption = true;
        protected boolean noPlayerTypes = false;
        protected boolean canBeDeleted = true;

        public GuiPart(EnumParts part) {
            this.part = part;
            this.data = GuiCreationParts.this.playerdata.getPartData(part);
        }

        public int initGui() {
            this.data = GuiCreationParts.this.playerdata.getPartData(this.part);
            int y = GuiCreationParts.this.guiTop + 50;
            if (this.data == null || !this.data.playerTexture || !this.noPlayerTypes) {
                GuiCreationParts.this.addLabel(new GuiNpcLabel(20, "gui.type", GuiCreationParts.this.guiLeft + 102, y + 5, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiButtonBiDirectional(20, GuiCreationParts.this.guiLeft + 145, y, 100, 20, this.types, this.data == null ? 0 : this.data.type + 1));
                y += 25;
            }
            if (this.data != null && this.hasPlayerOption) {
                GuiCreationParts.this.addLabel(new GuiNpcLabel(21, "gui.playerskin", GuiCreationParts.this.guiLeft + 102, y + 5, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiNpcButtonYesNo(21, GuiCreationParts.this.guiLeft + 170, y, this.data.playerTexture));
                y += 25;
            }
            if (this.data != null && !this.data.playerTexture) {
                GuiCreationParts.this.addLabel(new GuiNpcLabel(23, "gui.color", GuiCreationParts.this.guiLeft + 102, y + 5, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiColorButton(23, GuiCreationParts.this.guiLeft + 170, y, this.data.color));
                y += 25;
            }
            return y;
        }

        protected void actionPerformed(GuiButton btn) {
            if (btn.field_146127_k == 20) {
                int i = ((GuiNpcButton)btn).getValue();
                if (i == 0 && this.canBeDeleted) {
                    GuiCreationParts.this.playerdata.removePart(this.part);
                } else {
                    this.data = GuiCreationParts.this.playerdata.getOrCreatePart(this.part);
                    this.data.pattern = 0;
                    this.data.setType(i - 1);
                }
                GuiCreationParts.this.func_73866_w_();
            }
            if (btn.field_146127_k == 22) {
                this.data.pattern = (byte)((GuiNpcButton)btn).getValue();
            }
            if (btn.field_146127_k == 21) {
                this.data.playerTexture = ((GuiNpcButtonYesNo)btn).getBoolean();
                GuiCreationParts.this.func_73866_w_();
            }
            if (btn.field_146127_k == 23) {
                GuiCreationParts.this.setSubGui(new GuiModelColor(GuiCreationParts.this, this.data));
            }
        }

        public GuiPart noPlayerOptions() {
            this.hasPlayerOption = false;
            return this;
        }

        public GuiPart noPlayerTypes() {
            this.noPlayerTypes = true;
            return this;
        }

        public GuiPart setTypes(String[] types) {
            this.types = types;
            return this;
        }
    }
}

