/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.NBTTags;
import noppes.npcs.controllers.ScriptController;

public class ScriptContainer {
    public String fullscript = "";
    public String script = "";
    public String console = "";
    public boolean errored = false;
    public List<String> scripts = new ArrayList<String>();
    private Set<String> unknownFunctions = new HashSet<String>();
    private long lastCreated = 0L;
    private String currentScriptLanguage = null;
    public ScriptEngine engine = null;
    private boolean init = false;

    public void readFromNBT(NBTTagCompound compound) {
        this.script = compound.func_74779_i("Script");
        this.console = compound.func_74779_i("ScriptConsole");
        this.scripts = NBTTags.getStringList(compound.func_150295_c("ScriptList", 10));
        this.lastCreated = 0L;
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("Script", this.script);
        compound.func_74778_a("ScriptConsole", this.console);
        compound.func_74782_a("ScriptList", (NBTBase)NBTTags.nbtStringList(this.scripts));
    }

    public String getCode() {
        if (ScriptController.Instance.lastLoaded > this.lastCreated) {
            this.lastCreated = ScriptController.Instance.lastLoaded;
            this.fullscript = this.script;
            if (!this.fullscript.isEmpty()) {
                this.fullscript = this.fullscript + "\n";
            }
            for (String loc : this.scripts) {
                String code = ScriptController.Instance.scripts.get(loc);
                if (code == null || code.isEmpty()) continue;
                this.fullscript = this.fullscript + code + "\n";
            }
            this.unknownFunctions = new HashSet<String>();
            this.init = false;
        }
        return this.fullscript;
    }

    public void run(String function, Event event) {
        if (!this.hasCode() || this.unknownFunctions.contains(function)) {
            return;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.engine.getContext().setWriter(pw);
        this.engine.getContext().setErrorWriter(pw);
        try {
            if (!this.init) {
                this.engine.eval(this.getCode());
                this.init = true;
            }
            ((Invocable)((Object)this.engine)).invokeFunction(function, event);
        }
        catch (NoSuchMethodException e) {
            this.unknownFunctions.add(function);
        }
        catch (Exception e) {
            this.errored = true;
            e.printStackTrace(pw);
        }
        this.appandConsole(sw.getBuffer().toString().trim());
    }

    public void appandConsole(String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        this.console = message + "\n" + this.console;
    }

    public boolean hasCode() {
        return !this.getCode().isEmpty();
    }

    public void setEngine(String scriptLanguage) {
        if (this.currentScriptLanguage != null && this.currentScriptLanguage.equals(scriptLanguage)) {
            return;
        }
        this.engine = ScriptController.Instance.getEngineByName(scriptLanguage);
        this.currentScriptLanguage = scriptLanguage;
        this.init = false;
    }
}

