/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.ScriptContainerOld;
import noppes.npcs.controllers.ScriptEntityData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.scripted.ScriptAnimal;
import noppes.npcs.scripted.ScriptEntity;
import noppes.npcs.scripted.ScriptLiving;
import noppes.npcs.scripted.ScriptLivingBase;
import noppes.npcs.scripted.ScriptMonster;
import noppes.npcs.scripted.ScriptPixelmon;
import noppes.npcs.scripted.ScriptPlayer;
import noppes.npcs.scripted.ScriptWorld;
import noppes.npcs.scripted.constants.AnimationType;
import noppes.npcs.scripted.constants.EntityType;
import noppes.npcs.scripted.constants.JobType;
import noppes.npcs.scripted.constants.MovingType;
import noppes.npcs.scripted.constants.ParticleType;
import noppes.npcs.scripted.constants.PotionEffectType;
import noppes.npcs.scripted.constants.RoleType;
import noppes.npcs.scripted.constants.StandingType;
import noppes.npcs.scripted.constants.TacticalVariantType;
import noppes.npcs.scripted.events.ScriptEvent;
import noppes.npcs.util.NBTJsonUtil;

public class ScriptController {
    public static ScriptController Instance;
    public static boolean HasStart;
    private ScriptEngineManager manager;
    public Map<String, String> languages = new HashMap<String, String>();
    public Map<String, String> scripts = new HashMap<String, String>();
    public long lastLoaded = 0L;
    public File dir;
    public NBTTagCompound compound = new NBTTagCompound();
    private boolean loaded = false;
    public boolean shouldSave = false;
    private static final AnimationType animations;
    private static final EntityType entities;
    private static final JobType jobs;
    private static final MovingType movingTypes;
    private static final RoleType roles;
    private static final StandingType standingTypes;
    private static final TacticalVariantType tacticalVariantTypes;
    private static final PotionEffectType potionEffectTypes;
    private static final ParticleType particleTypes;

    public ScriptController() {
        Instance = this;
        this.manager = new ScriptEngineManager();
        LogWriter.info("Script Engines Available:");
        for (ScriptEngineFactory fac : this.manager.getEngineFactories()) {
            if (fac.getExtensions().isEmpty() || !(this.manager.getEngineByName(fac.getLanguageName()) instanceof Invocable)) continue;
            String ext = "." + fac.getExtensions().get(0).toLowerCase();
            LogWriter.info(fac.getLanguageName() + ": " + ext);
            this.languages.put(fac.getLanguageName(), ext);
        }
    }

    private void loadCategories() {
        this.dir = new File(CustomNpcs.getWorldSaveDirectory(), "scripts");
        if (!this.dir.exists()) {
            this.dir.mkdir();
        }
        if (!this.getSavedFile().exists()) {
            this.shouldSave = true;
        }
        new ScriptWorld(null).clearTempData();
        this.scripts.clear();
        for (String language : this.languages.keySet()) {
            String ext = this.languages.get(language);
            File scriptDir = new File(this.dir, language.toLowerCase());
            if (!scriptDir.exists()) {
                scriptDir.mkdir();
                continue;
            }
            this.loadDir(scriptDir, "", ext);
        }
        this.lastLoaded = System.currentTimeMillis();
    }

    private void loadDir(File dir, String name, String ext) {
        for (File file : dir.listFiles()) {
            String filename = name + file.getName().toLowerCase();
            if (file.isDirectory()) {
                this.loadDir(file, filename + "/", ext);
                continue;
            }
            if (!filename.endsWith(ext)) continue;
            try {
                this.scripts.put(filename, this.readFile(file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean loadStoredData() {
        File file = this.getSavedFile();
        try {
            this.loadCategories();
            if (!file.exists()) {
                return false;
            }
            this.compound = NBTJsonUtil.LoadFile(file);
            this.shouldSave = false;
        }
        catch (Exception e) {
            LogWriter.error("Error loading: " + file.getAbsolutePath(), e);
            return false;
        }
        return true;
    }

    private File getSavedFile() {
        return new File(this.dir, "world_data.json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        try {
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
            String string = sb.toString();
            return string;
        }
        finally {
            br.close();
        }
    }

    public ScriptEngine getEngineByName(String language) {
        return this.manager.getEngineByName(language);
    }

    public NBTTagList nbtLanguages() {
        NBTTagList list = new NBTTagList();
        for (String language : this.languages.keySet()) {
            NBTTagCompound compound = new NBTTagCompound();
            NBTTagList scripts = new NBTTagList();
            for (String script : this.getScripts(language)) {
                scripts.func_74742_a((NBTBase)new NBTTagString(script));
            }
            compound.func_74782_a("Scripts", (NBTBase)scripts);
            compound.func_74778_a("Language", language);
            list.func_74742_a((NBTBase)compound);
        }
        return list;
    }

    private List<String> getScripts(String language) {
        ArrayList<String> list = new ArrayList<String>();
        String ext = this.languages.get(language);
        if (ext == null) {
            return list;
        }
        for (String script : this.scripts.keySet()) {
            if (!script.endsWith(ext)) continue;
            list.add(script);
        }
        return list;
    }

    public static ScriptEntity getScriptForEntity(Entity entity) {
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityNPCInterface) {
            return ((EntityNPCInterface)entity).script.dummyNpc;
        }
        ScriptEntityData data = (ScriptEntityData)entity.getExtendedProperties("ScriptedObject");
        if (data != null) {
            return data.base;
        }
        if (entity instanceof EntityPlayerMP) {
            data = new ScriptEntityData(new ScriptPlayer((EntityPlayerMP)entity));
        } else {
            if (PixelmonHelper.isPixelmon(entity)) {
                return new ScriptPixelmon((EntityTameable)entity);
            }
            data = entity instanceof EntityAnimal ? new ScriptEntityData(new ScriptAnimal((EntityAnimal)entity)) : (entity instanceof EntityMob ? new ScriptEntityData(new ScriptMonster((EntityMob)entity)) : (entity instanceof EntityLiving ? new ScriptEntityData(new ScriptLiving((EntityLiving)entity)) : (entity instanceof EntityLivingBase ? new ScriptEntityData(new ScriptLivingBase((EntityLivingBase)entity)) : new ScriptEntityData(new ScriptEntity(entity)))));
        }
        entity.registerExtendedProperties("ScriptedObject", (IExtendedEntityProperties)data);
        return data.base;
    }

    public boolean runScript(ScriptContainerOld script, Object ... obs) {
        if (!script.hasCode()) {
            return false;
        }
        ScriptEngine engine = script.engine;
        int i = 0;
        while (i + 1 < obs.length) {
            Object ob = obs[i + 1];
            if (ob instanceof Entity) {
                ob = ScriptController.getScriptForEntity((Entity)ob);
            }
            engine.put(obs[i].toString(), ob);
            i += 2;
        }
        ScriptEvent result = (ScriptEvent)engine.get("event");
        if (result == null) {
            result = new ScriptEvent();
            engine.put("event", result);
        }
        engine.put("AnimationType", animations);
        engine.put("EntityType", entities);
        engine.put("RoleType", roles);
        engine.put("JobType", jobs);
        engine.put("MovingType", movingTypes);
        engine.put("StandingType", standingTypes);
        engine.put("TacticalVariantType", tacticalVariantTypes);
        engine.put("PotionEffectType", potionEffectTypes);
        engine.put("ParticleType", particleTypes);
        script.run(engine);
        return result.isCancelled();
    }

    @SubscribeEvent
    public void saveWorld(WorldEvent.Save event) {
        if (!this.shouldSave || event.world.field_72995_K || event.world != MinecraftServer.func_71276_C().field_71305_c[0]) {
            return;
        }
        try {
            NBTJsonUtil.SaveFile(this.getSavedFile(), this.compound);
        }
        catch (Exception e) {
            LogWriter.except(e);
        }
        this.shouldSave = false;
    }

    static {
        HasStart = false;
        animations = new AnimationType();
        entities = new EntityType();
        jobs = new JobType();
        movingTypes = new MovingType();
        roles = new RoleType();
        standingTypes = new StandingType();
        tacticalVariantTypes = new TacticalVariantType();
        potionEffectTypes = new PotionEffectType();
        particleTypes = new ParticleType();
    }
}

