/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.constants.EnumOptionType;
import noppes.npcs.controllers.Dialog;
import noppes.npcs.controllers.DialogOption;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.Quest;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleInterface;

public class RoleDialog
extends RoleInterface {
    public String dialog = "";
    public int questId = -1;
    public HashMap<Integer, String> options = new HashMap();
    public HashMap<Integer, String> optionsTexts = new HashMap();

    public RoleDialog(EntityNPCInterface npc) {
        super(npc);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("RoleQuestId", this.questId);
        compound.func_74778_a("RoleDialog", this.dialog);
        compound.func_74782_a("RoleOptions", NBTTags.nbtIntegerStringMap(this.options));
        compound.func_74782_a("RoleOptionTexts", NBTTags.nbtIntegerStringMap(this.optionsTexts));
        return compound;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.questId = compound.func_74762_e("RoleQuestId");
        this.dialog = compound.func_74779_i("RoleDialog");
        this.options = NBTTags.getIntegerStringMap(compound.func_150295_c("RoleOptions", 10));
        this.optionsTexts = NBTTags.getIntegerStringMap(compound.func_150295_c("RoleOptionTexts", 10));
    }

    @Override
    public void interact(EntityPlayer player) {
        if (this.dialog.isEmpty()) {
            this.npc.say(player, this.npc.advanced.getInteractLine());
        } else {
            Dialog d = new Dialog();
            d.text = this.dialog;
            for (Map.Entry<Integer, String> entry : this.options.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                DialogOption option = new DialogOption();
                String text = this.optionsTexts.get(entry.getKey());
                option.optionType = text != null && !text.isEmpty() ? EnumOptionType.ROLE_OPTION : EnumOptionType.QUIT_OPTION;
                option.title = entry.getValue();
                d.options.put(entry.getKey(), option);
            }
            NoppesUtilServer.openDialog(player, this.npc, d);
        }
        Quest quest = QuestController.instance.quests.get(this.questId);
        if (quest != null) {
            PlayerQuestController.addActiveQuest(quest, player);
        }
    }
}

