/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.blocks.tiles.TileScripted;
import noppes.npcs.scripted.ScriptBlockState;
import noppes.npcs.scripted.ScriptItemStack;

public class ScriptBlockScripted
extends ScriptBlockState {
    private TileScripted tile;

    public ScriptBlockScripted(World world, Block block, BlockPos pos) {
        super(world, block, pos);
        this.tile = (TileScripted)((ScriptBlockState)this).tile;
    }

    public void setBlockModel(ScriptItemStack item) {
        if (item == null) {
            this.tile.setItemModel(null);
        } else {
            this.tile.setItemModel(item.item);
        }
    }

    public void setBlockModel(String name) {
        if (name == null) {
            this.tile.setItemModel(null);
        } else {
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)name);
            if (item == null) {
                this.tile.setItemModel(null);
            } else {
                this.tile.setItemModel(new ItemStack(item));
            }
        }
    }

    public ScriptItemStack getBlockModel() {
        return new ScriptItemStack(this.tile.itemModel);
    }

    public void setRedstonePower(int strength) {
        this.tile.setRedstonePower(strength);
    }

    public int getRedstonePower() {
        return this.tile.powering;
    }

    public void setIsLadder(boolean bo) {
        this.tile.isLadder = bo;
        this.tile.needsClientUpdate = true;
    }

    public boolean getIsLadder() {
        return this.tile.isLadder;
    }

    public void setLight(int value) {
        this.tile.setLightValue(value);
    }

    public int getLight() {
        return this.tile.lightValue;
    }

    public void setScale(float x, float y, float z) {
        this.tile.setScale(x, y, z);
    }

    public float getScaleX() {
        return this.tile.scaleX;
    }

    public float getScaleY() {
        return this.tile.scaleY;
    }

    public float getScaleZ() {
        return this.tile.scaleZ;
    }

    public void setRotation(int x, int y, int z) {
        this.tile.setRotation(x % 360, y % 360, z % 360);
    }

    public int getRotationX() {
        return this.tile.rotationX;
    }

    public int getRotationY() {
        return this.tile.rotationY;
    }

    public int getRotationZ() {
        return this.tile.rotationZ;
    }

    public void executeCommand(String command) {
        NoppesUtilServer.runCommand(this.tile.func_145831_w(), this.tile.func_174877_v(), "ScriptBlock: " + this.tile.func_174877_v(), command, null);
    }
}

