/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import noppes.npcs.blocks.tiles.TileNpcEntity;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.scripted.ScriptItemStack;

public class ScriptBlockState {
    protected World world;
    protected Block block;
    protected BlockPos pos;
    protected TileEntity tile;

    public ScriptBlockState(World world, Block block, BlockPos pos) {
        this.world = world;
        this.block = block;
        this.pos = pos;
        this.tile = world.func_175625_s(pos);
    }

    public int getX() {
        return this.pos.func_177958_n();
    }

    public int getY() {
        return this.pos.func_177956_o();
    }

    public int getZ() {
        return this.pos.func_177952_p();
    }

    public String getName() {
        return Block.field_149771_c.func_177774_c((Object)this.block) + "";
    }

    public boolean isRemoved() {
        IBlockState state = this.world.func_180495_p(this.pos);
        if (state == null) {
            return true;
        }
        return state.func_177230_c() != this.block;
    }

    public ScriptBlockState setBlock(String name) {
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)name);
        if (block == null) {
            return this;
        }
        this.world.func_175656_a(this.pos, block.func_176223_P());
        return new ScriptBlockState(this.world, block, this.pos);
    }

    public ScriptBlockState setBlock(ScriptBlockState block) {
        this.world.func_175656_a(this.pos, block.block.func_176223_P());
        return new ScriptBlockState(this.world, block.block, this.pos);
    }

    public void remove() {
        this.block = Blocks.field_150350_a;
        this.world.func_175698_g(this.pos);
    }

    public boolean isContainer() {
        if (this.tile == null || !(this.tile instanceof IInventory)) {
            return false;
        }
        return ((IInventory)this.tile).func_70302_i_() > 0;
    }

    public int getContainerSize() {
        if (this.tile == null || !(this.tile instanceof IInventory)) {
            return -1;
        }
        return ((IInventory)this.tile).func_70302_i_();
    }

    public ScriptItemStack getContainerSlot(int slot) {
        if (this.tile == null || !(this.tile instanceof IInventory)) {
            return null;
        }
        IInventory inv = (IInventory)this.tile;
        if (slot < 0 || slot >= inv.func_70302_i_()) {
            return null;
        }
        return new ScriptItemStack(inv.func_70301_a(slot));
    }

    public void setContainerSlot(int slot, ScriptItemStack item) {
        if (this.tile == null || !(this.tile instanceof IInventory)) {
            return;
        }
        IInventory inv = (IInventory)this.tile;
        if (slot < 0 || slot >= inv.func_70302_i_()) {
            return;
        }
        inv.func_70299_a(slot, item == null ? null : item.item);
    }

    public boolean canStoreData() {
        return this.tile instanceof TileNpcEntity;
    }

    public Object getTempData(String key) {
        if (!(this.tile instanceof TileNpcEntity)) {
            return null;
        }
        return ((TileNpcEntity)this.tile).tempData.get(key);
    }

    public void setTempData(String key, Object value) {
        if (!(this.tile instanceof TileNpcEntity)) {
            return;
        }
        ((TileNpcEntity)this.tile).tempData.put(key, value);
    }

    public boolean hasTempData(String key) {
        if (!(this.tile instanceof TileNpcEntity)) {
            return false;
        }
        return ((TileNpcEntity)this.tile).tempData.containsKey(key);
    }

    public void removeTempData(String key) {
        if (!(this.tile instanceof TileNpcEntity)) {
            return;
        }
        ((TileNpcEntity)this.tile).tempData.remove(key);
    }

    public void clearTempData() {
        if (!(this.tile instanceof TileNpcEntity)) {
            return;
        }
        ((TileNpcEntity)this.tile).tempData.clear();
    }

    public Object getStoredData(String key) {
        if (!(this.tile instanceof TileNpcEntity)) {
            return null;
        }
        NBTTagCompound compound = ((TileNpcEntity)this.tile).extraData;
        if (!compound.func_74764_b(key)) {
            return null;
        }
        NBTBase base = compound.func_74781_a(key);
        if (base instanceof NBTBase.NBTPrimitive) {
            return ((NBTBase.NBTPrimitive)base).func_150286_g();
        }
        return ((NBTTagString)base).func_150285_a_();
    }

    public void setStoredData(String key, Object value) {
        if (!(this.tile instanceof TileNpcEntity)) {
            return;
        }
        NBTTagCompound compound = ((TileNpcEntity)this.tile).extraData;
        if (value instanceof Number) {
            compound.func_74780_a(key, ((Number)value).doubleValue());
        } else if (value instanceof String) {
            compound.func_74778_a(key, (String)value);
        }
        ScriptController.Instance.shouldSave = true;
    }

    public boolean hasStoredData(String key) {
        if (!(this.tile instanceof TileNpcEntity)) {
            return false;
        }
        return ((TileNpcEntity)this.tile).extraData.func_74764_b(key);
    }

    public void removeStoredData(String key) {
        if (!(this.tile instanceof TileNpcEntity)) {
            return;
        }
        ((TileNpcEntity)this.tile).extraData.func_82580_o(key);
    }

    public void clearStoredData() {
        if (!(this.tile instanceof TileNpcEntity)) {
            return;
        }
        ((TileNpcEntity)this.tile).extraData = new NBTTagCompound();
    }

    public Block getMCBlock() {
        return this.block;
    }

    public TileEntity getMCTileEntity() {
        return this.tile;
    }
}

