/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.scripted.ScriptItemStack;

public class ScriptEntity {
    protected Entity entity;
    private Map<String, Object> tempData = new HashMap<String, Object>();

    public ScriptEntity(Entity entity) {
        this.entity = entity;
    }

    public double getX() {
        return this.entity.field_70165_t;
    }

    public void setX(double x) {
        this.entity.field_70165_t = x;
    }

    public double getY() {
        return this.entity.field_70163_u;
    }

    public void setY(double y) {
        this.entity.field_70163_u = y;
    }

    public double getZ() {
        return this.entity.field_70161_v;
    }

    public void setZ(double z) {
        this.entity.field_70161_v = z;
    }

    public int getBlockX() {
        return MathHelper.func_76128_c((double)this.entity.field_70165_t);
    }

    public int getBlockY() {
        return MathHelper.func_76128_c((double)this.entity.field_70163_u);
    }

    public int getBlockZ() {
        return MathHelper.func_76128_c((double)this.entity.field_70161_v);
    }

    public void setPosition(double x, double y, double z) {
        this.entity.func_70107_b(x, y, z);
    }

    public ScriptEntity[] getSurroundingEntities(int range) {
        List entities = this.entity.field_70170_p.func_72872_a(Entity.class, this.entity.func_174813_aQ().func_72314_b((double)range, (double)range, (double)range));
        ArrayList<ScriptEntity> list = new ArrayList<ScriptEntity>();
        for (Entity living : entities) {
            if (living == this.entity) continue;
            list.add(ScriptController.getScriptForEntity(living));
        }
        return list.toArray(new ScriptEntity[list.size()]);
    }

    public ScriptEntity getClosestEntity(int type) {
        List entities = this.entity.field_70170_p.func_72872_a(this.getClassForType(type), this.entity.func_174813_aQ().func_72314_b(40.0, 40.0, 40.0));
        double distance = 64000.0;
        Entity entity = null;
        for (Entity e : entities) {
            double range = this.entity.func_70068_e(e);
            if (entity == null) {
                distance = range;
                entity = e;
                continue;
            }
            if (!(range < distance)) continue;
            distance = range;
            entity = e;
        }
        return ScriptController.getScriptForEntity(entity);
    }

    private Class getClassForType(int type) {
        Class cls = Entity.class;
        if (type == 5) {
            cls = EntityLivingBase.class;
        } else if (type == 1) {
            cls = EntityPlayer.class;
        } else if (type == 4) {
            cls = EntityAnimal.class;
        } else if (type == 3) {
            cls = EntityMob.class;
        } else if (type == 2) {
            cls = EntityNPCInterface.class;
        }
        return cls;
    }

    public ScriptEntity[] getSurroundingEntities(int range, int type) {
        List entities = this.entity.field_70170_p.func_72872_a(this.getClassForType(type), this.entity.func_174813_aQ().func_72314_b((double)range, (double)range, (double)range));
        ArrayList<ScriptEntity> list = new ArrayList<ScriptEntity>();
        for (Entity living : entities) {
            if (living == this.entity) continue;
            list.add(ScriptController.getScriptForEntity(living));
        }
        return list.toArray(new ScriptEntity[list.size()]);
    }

    public boolean isAlive() {
        return this.entity.func_70089_S();
    }

    public Object getTempData(String key) {
        return this.tempData.get(key);
    }

    public void setTempData(String key, Object value) {
        this.tempData.put(key, value);
    }

    public boolean hasTempData(String key) {
        return this.tempData.containsKey(key);
    }

    public void removeTempData(String key) {
        this.tempData.remove(key);
    }

    public void clearTempData() {
        this.tempData.clear();
    }

    public Object getStoredData(String key) {
        NBTTagCompound compound = this.getStoredCompound();
        if (!compound.func_74764_b(key)) {
            return null;
        }
        NBTBase base = compound.func_74781_a(key);
        if (base instanceof NBTBase.NBTPrimitive) {
            return ((NBTBase.NBTPrimitive)base).func_150286_g();
        }
        return ((NBTTagString)base).func_150285_a_();
    }

    public void setStoredData(String key, Object value) {
        NBTTagCompound compound = this.getStoredCompound();
        if (value instanceof Number) {
            compound.func_74780_a(key, ((Number)value).doubleValue());
        } else if (value instanceof String) {
            compound.func_74778_a(key, (String)value);
        }
        this.saveStoredCompound(compound);
    }

    public boolean hasStoredData(String key) {
        return this.getStoredCompound().func_74764_b(key);
    }

    public void removeStoredData(String key) {
        NBTTagCompound compound = this.getStoredCompound();
        compound.func_82580_o(key);
        this.saveStoredCompound(compound);
    }

    public void clearStoredData() {
        this.entity.getEntityData().func_82580_o("CNPCStoredData");
    }

    private NBTTagCompound getStoredCompound() {
        NBTTagCompound compound = this.entity.getEntityData().func_74775_l("CNPCStoredData");
        if (compound == null) {
            compound = new NBTTagCompound();
            this.entity.getEntityData().func_74782_a("CNPCStoredData", (NBTBase)compound);
        }
        return compound;
    }

    private void saveStoredCompound(NBTTagCompound compound) {
        this.entity.getEntityData().func_74782_a("CNPCStoredData", (NBTBase)compound);
    }

    public long getAge() {
        return this.entity.field_70173_aa;
    }

    public void despawn() {
        this.entity.field_70128_L = true;
    }

    public boolean inWater() {
        return this.entity.func_70055_a(Material.field_151586_h);
    }

    public boolean inLava() {
        return this.entity.func_70055_a(Material.field_151587_i);
    }

    public boolean inFire() {
        return this.entity.func_70055_a(Material.field_151581_o);
    }

    public boolean isBurning() {
        return this.entity.func_70027_ad();
    }

    public void setBurning(int ticks) {
        this.entity.func_70015_d(ticks);
    }

    public void extinguish() {
        this.entity.func_70066_B();
    }

    public String getTypeName() {
        return EntityList.func_75621_b((Entity)this.entity);
    }

    public void dropItem(ScriptItemStack item) {
        this.entity.func_70099_a(item.item, 0.0f);
    }

    public ScriptEntity getRider() {
        return ScriptController.getScriptForEntity(this.entity.field_70153_n);
    }

    public void setRider(ScriptEntity entity) {
        if (entity != null) {
            entity.entity.func_70078_a(this.entity);
        } else if (this.entity.field_70153_n != null) {
            this.entity.field_70153_n.func_70078_a(null);
        }
    }

    public ScriptEntity getMount() {
        return ScriptController.getScriptForEntity(this.entity.field_70154_o);
    }

    public void setMount(ScriptEntity entity) {
        if (entity == null) {
            this.entity.func_70078_a(null);
        } else {
            this.entity.func_70078_a(entity.entity);
        }
    }

    public int getType() {
        return 0;
    }

    public boolean typeOf(int type) {
        return type == 0;
    }

    public void setRotation(float rotation) {
        this.entity.field_70177_z = rotation;
    }

    public float getRotation() {
        return this.entity.field_70177_z;
    }

    public void knockback(int power, float direction) {
        float v = direction * (float)Math.PI / 180.0f;
        this.entity.func_70024_g((double)(-MathHelper.func_76126_a((float)v) * (float)power), 0.1 + (double)((float)power * 0.04f), (double)(MathHelper.func_76134_b((float)v) * (float)power));
        this.entity.field_70159_w *= 0.6;
        this.entity.field_70179_y *= 0.6;
        this.entity.func_70097_a(DamageSource.field_76380_i, 1.0E-4f);
    }

    public boolean isSneaking() {
        return this.entity.func_70093_af();
    }

    public boolean isSprinting() {
        return this.entity.func_70051_ag();
    }

    public Entity getMCEntity() {
        return this.entity;
    }

    public String getUUID() {
        return this.entity.func_110124_au().toString();
    }
}

