/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.IItemStack;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.constants.EnumAnimation;
import noppes.npcs.constants.EnumMovingType;
import noppes.npcs.constants.EnumNavType;
import noppes.npcs.constants.EnumParticleType;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.constants.EnumPotionType;
import noppes.npcs.constants.EnumStandingType;
import noppes.npcs.controllers.Line;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.scripted.ScriptFaction;
import noppes.npcs.scripted.ScriptItemStack;
import noppes.npcs.scripted.ScriptLiving;
import noppes.npcs.scripted.ScriptLivingBase;
import noppes.npcs.scripted.ScriptPlayer;
import noppes.npcs.scripted.roles.ScriptJobBard;
import noppes.npcs.scripted.roles.ScriptJobConversation;
import noppes.npcs.scripted.roles.ScriptJobFollower;
import noppes.npcs.scripted.roles.ScriptJobGuard;
import noppes.npcs.scripted.roles.ScriptJobHealer;
import noppes.npcs.scripted.roles.ScriptJobInterface;
import noppes.npcs.scripted.roles.ScriptJobItemGiver;
import noppes.npcs.scripted.roles.ScriptJobPuppet;
import noppes.npcs.scripted.roles.ScriptJobSpawner;
import noppes.npcs.scripted.roles.ScriptRoleBank;
import noppes.npcs.scripted.roles.ScriptRoleCompanion;
import noppes.npcs.scripted.roles.ScriptRoleDialog;
import noppes.npcs.scripted.roles.ScriptRoleFollower;
import noppes.npcs.scripted.roles.ScriptRoleInterface;
import noppes.npcs.scripted.roles.ScriptRoleMailman;
import noppes.npcs.scripted.roles.ScriptRoleTrader;
import noppes.npcs.scripted.roles.ScriptRoleTransporter;
import noppes.npcs.util.ValueUtil;

public class ScriptNpc
extends ScriptLiving {
    protected EntityCustomNpc npc;

    public ScriptNpc(EntityCustomNpc npc) {
        super((EntityLiving)npc);
        this.npc = npc;
    }

    public int getSize() {
        return this.npc.display.getSize();
    }

    public void setSize(int size) {
        if (size > 30) {
            size = 30;
        } else if (size < 1) {
            size = 1;
        }
        this.npc.display.setSize(size);
    }

    public String getName() {
        return this.npc.display.getName();
    }

    @Override
    public void setRotation(float rotation) {
        this.npc.ai.orientation = (int)rotation;
        super.setRotation(rotation);
    }

    public void setName(String name) {
        this.npc.display.setName(name);
    }

    public String getTitle() {
        return this.npc.display.getTitle();
    }

    public void setTitle(String title) {
        this.npc.display.setTitle(title);
    }

    public String getTexture() {
        return this.npc.display.getSkinTexture();
    }

    public void setTexture(String texture) {
        this.npc.display.setSkinTexture(texture);
    }

    public int getHomeX() {
        return this.npc.getStartPos()[0];
    }

    public void setHomeX(int x) {
        this.npc.ai.startPos[0] = x;
    }

    public int getHomeY() {
        return this.npc.getStartPos()[1];
    }

    public void setHomeY(int y) {
        this.npc.ai.startPos[1] = y;
    }

    public int getHomeZ() {
        return this.npc.getStartPos()[2];
    }

    public void setHomeZ(int z) {
        this.npc.ai.startPos[2] = z;
    }

    public void setHome(int x, int y, int z) {
        this.npc.ai.startPos = new int[]{x, y, z};
    }

    public void setMaxHealth(int health) {
        this.npc.stats.setMaxHealth(health);
    }

    public void setReturnToHome(boolean bo) {
        this.npc.ai.returnToStart = bo;
    }

    public boolean getReturnToHome() {
        return this.npc.ai.returnToStart;
    }

    public ScriptFaction getFaction() {
        return new ScriptFaction(this.npc.getFaction());
    }

    public void setFaction(int id) {
        this.npc.setFaction(id);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public boolean typeOf(int type) {
        return type == 2 ? true : super.typeOf(type);
    }

    public void shootItem(ScriptLivingBase target, ScriptItemStack item, int accuracy) {
        if (item == null) {
            return;
        }
        if (accuracy < 0) {
            accuracy = 0;
        } else if (accuracy > 100) {
            accuracy = 100;
        }
        this.npc.shoot(target.entity, accuracy, item.item, false);
    }

    public void say(String message) {
        this.npc.saySurrounding(new Line(message));
    }

    public void say(ScriptPlayer player, String message) {
        if (player == null || message == null || message.isEmpty()) {
            return;
        }
        this.npc.say((EntityPlayer)player.player, new Line(message));
    }

    public void kill() {
        this.npc.func_70106_y();
    }

    public void reset() {
        this.npc.reset();
    }

    public ScriptRoleInterface getRole() {
        if (this.npc.advanced.role == 3) {
            return new ScriptRoleBank(this.npc);
        }
        if (this.npc.advanced.role == 2) {
            return new ScriptRoleFollower(this.npc);
        }
        if (this.npc.advanced.role == 5) {
            return new ScriptRoleMailman(this.npc);
        }
        if (this.npc.advanced.role == 1) {
            return new ScriptRoleTrader(this.npc);
        }
        if (this.npc.advanced.role == 4) {
            return new ScriptRoleTransporter(this.npc);
        }
        if (this.npc.advanced.role == 6) {
            return new ScriptRoleCompanion(this.npc);
        }
        if (this.npc.advanced.role == 7) {
            return new ScriptRoleDialog(this.npc);
        }
        return new ScriptRoleInterface(this.npc);
    }

    public ScriptJobInterface getJob() {
        if (this.npc.advanced.job == 1) {
            return new ScriptJobBard(this.npc);
        }
        if (this.npc.advanced.job == 7) {
            return new ScriptJobConversation(this.npc);
        }
        if (this.npc.advanced.job == 5) {
            return new ScriptJobFollower(this.npc);
        }
        if (this.npc.advanced.job == 3) {
            return new ScriptJobGuard(this.npc);
        }
        if (this.npc.advanced.job == 2) {
            return new ScriptJobHealer(this.npc);
        }
        if (this.npc.advanced.job == 9) {
            return new ScriptJobPuppet(this.npc);
        }
        if (this.npc.advanced.job == 4) {
            return new ScriptJobItemGiver(this.npc);
        }
        if (this.npc.advanced.job == 6) {
            return new ScriptJobSpawner(this.npc);
        }
        return new ScriptJobInterface(this.npc);
    }

    public ScriptItemStack getRightItem() {
        IItemStack item = this.npc.inventory.getRightHand();
        if (item == null) {
            return null;
        }
        return new ScriptItemStack(item.getMCItemStack());
    }

    public void setRightItem(ScriptItemStack item) {
        if (item == null) {
            this.npc.inventory.setRightHand(null);
        } else {
            this.npc.inventory.setRightHand(new ItemStackWrapper(item.item));
        }
    }

    public ScriptItemStack getLeftItem() {
        ItemStack item = this.npc.getOffHand();
        if (item == null || item.func_77973_b() == null) {
            return null;
        }
        return new ScriptItemStack(item);
    }

    public void setLeftItem(ScriptItemStack item) {
        if (item == null) {
            this.npc.inventory.setLeftHand(null);
        } else {
            this.npc.inventory.setLeftHand(new ItemStackWrapper(item.item));
        }
        this.npc.updateClient = true;
    }

    public ScriptItemStack getProjectileItem() {
        IItemStack item = this.npc.inventory.getProjectile();
        if (item == null) {
            return null;
        }
        return new ScriptItemStack(item.getMCItemStack());
    }

    public void setProjectileItem(ScriptItemStack item) {
        if (item == null) {
            this.npc.inventory.setProjectile(null);
        } else {
            this.npc.inventory.setProjectile(new ItemStackWrapper(item.item));
        }
        this.npc.updateAI = true;
    }

    @Override
    public ScriptItemStack getArmor(int slot) {
        IItemStack item = this.npc.inventory.armor.get(slot);
        if (item == null) {
            return null;
        }
        return new ScriptItemStack(item.getMCItemStack());
    }

    @Override
    public void setArmor(int slot, ScriptItemStack item) {
        if (item == null) {
            this.npc.inventory.setArmor(slot, null);
        } else {
            this.npc.inventory.setArmor(slot, new ItemStackWrapper(item.item));
        }
        this.npc.updateClient = true;
    }

    public int getAnimation() {
        if (this.npc.ai.animationType == EnumAnimation.NONE) {
            return 0;
        }
        if (this.npc.ai.animationType == EnumAnimation.SITTING) {
            return 1;
        }
        if (this.npc.ai.animationType == EnumAnimation.DANCING) {
            return 5;
        }
        if (this.npc.ai.animationType == EnumAnimation.SNEAKING) {
            return 4;
        }
        if (this.npc.ai.animationType == EnumAnimation.LYING) {
            return 2;
        }
        if (this.npc.ai.animationType == EnumAnimation.HUG) {
            return 3;
        }
        if (this.npc.ai.animationType == EnumAnimation.AIMING) {
            return 6;
        }
        if (this.npc.ai.animationType == EnumAnimation.CRAWLING) {
            return 7;
        }
        return 0;
    }

    public boolean hasAnimation(int type) {
        return type == this.getAnimation();
    }

    public void setAnimation(int type) {
        if (type == 0) {
            this.npc.ai.animationType = EnumAnimation.NONE;
        } else if (type == 1) {
            this.npc.ai.animationType = EnumAnimation.SITTING;
        } else if (type == 5) {
            this.npc.ai.animationType = EnumAnimation.DANCING;
        } else if (type == 4) {
            this.npc.ai.animationType = EnumAnimation.SNEAKING;
        } else if (type == 2) {
            this.npc.ai.animationType = EnumAnimation.LYING;
        } else if (type == 3) {
            this.npc.ai.animationType = EnumAnimation.HUG;
        } else if (type == 6) {
            this.npc.ai.animationType = EnumAnimation.AIMING;
        } else if (type == 7) {
            this.npc.ai.animationType = EnumAnimation.CRAWLING;
        }
    }

    public void setVisibleType(int type) {
        this.npc.display.setVisible(type);
    }

    public int getVisibleType() {
        return this.npc.display.getVisible();
    }

    public void setShowName(int type) {
        this.npc.display.setShowName(type);
    }

    public int getShowName() {
        return this.npc.display.getShowName();
    }

    public int getShowBossBar() {
        return this.npc.display.getBossbar();
    }

    public void setShowBossBar(int type) {
        this.npc.display.setBossbar(type);
    }

    public int getMeleeStrength() {
        return this.npc.stats.getAttackStrength();
    }

    public void setMeleeStrength(int strength) {
        this.npc.stats.setAttackStrength(strength);
    }

    public int getMeleeSpeed() {
        return this.npc.stats.attackSpeed;
    }

    public void setMeleeSpeed(int speed) {
        this.npc.stats.attackSpeed = speed;
    }

    public int getRangedStrength() {
        return this.npc.stats.pDamage;
    }

    public void setRangedStrength(int strength) {
        this.npc.stats.pDamage = strength;
    }

    public int getRangedSpeed() {
        return this.npc.stats.pSpeed;
    }

    public void setRangedSpeed(int speed) {
        this.npc.stats.pSpeed = speed;
    }

    public int getRangedBurst() {
        return this.npc.stats.burstCount;
    }

    public void setRangedBurst(int count) {
        this.npc.stats.burstCount = count;
    }

    public void giveItem(ScriptPlayer player, ScriptItemStack item) {
        this.npc.givePlayerItem((EntityPlayer)player.player, item.item);
    }

    public void executeCommand(String command) {
        NoppesUtilServer.runCommand(this.npc, this.npc.func_70005_c_(), command, null);
    }

    public float[] getHeadScale() {
        float[] scale = new float[]{this.npc.modelData.getPartConfig(EnumParts.HEAD).getScaleX(), this.npc.modelData.getPartConfig(EnumParts.HEAD).getScaleY(), this.npc.modelData.getPartConfig(EnumParts.HEAD).getScaleZ()};
        return scale;
    }

    public void setHeadScale(float x, float y, float z) {
        this.npc.modelData.getPartConfig(EnumParts.HEAD).setScale(ValueUtil.correctFloat(x, 0.5f, 1.5f), ValueUtil.correctFloat(y, 0.5f, 1.5f), ValueUtil.correctFloat(z, 0.5f, 1.5f));
        this.npc.updateClient = true;
    }

    public float[] getBodyScale() {
        float[] scale = new float[]{this.npc.modelData.getPartConfig(EnumParts.BODY).getScaleX(), this.npc.modelData.getPartConfig(EnumParts.BODY).getScaleY(), this.npc.modelData.getPartConfig(EnumParts.BODY).getScaleZ()};
        return scale;
    }

    public void setBodyScale(float x, float y, float z) {
        this.npc.modelData.getPartConfig(EnumParts.BODY).setScale(ValueUtil.correctFloat(x, 0.5f, 1.5f), ValueUtil.correctFloat(y, 0.5f, 1.5f), ValueUtil.correctFloat(z, 0.5f, 1.5f));
        this.npc.updateClient = true;
    }

    public float[] getArmsScale() {
        float[] scale = new float[]{this.npc.modelData.getPartConfig(EnumParts.ARM_LEFT).getScaleX(), this.npc.modelData.getPartConfig(EnumParts.ARM_LEFT).getScaleY(), this.npc.modelData.getPartConfig(EnumParts.ARM_LEFT).getScaleZ()};
        return scale;
    }

    public void setArmsScale(float x, float y, float z) {
        this.npc.modelData.getPartConfig(EnumParts.ARM_LEFT).setScale(ValueUtil.correctFloat(x, 0.5f, 1.5f), ValueUtil.correctFloat(y, 0.5f, 1.5f), ValueUtil.correctFloat(z, 0.5f, 1.5f));
        this.npc.updateClient = true;
    }

    public float[] getLegsScale() {
        float[] scale = new float[]{this.npc.modelData.getPartConfig(EnumParts.LEGS).getScaleX(), this.npc.modelData.getPartConfig(EnumParts.LEGS).getScaleY(), this.npc.modelData.getPartConfig(EnumParts.LEGS).getScaleZ()};
        return scale;
    }

    public void setLegsScale(float x, float y, float z) {
        this.npc.modelData.getPartConfig(EnumParts.LEGS).setScale(ValueUtil.correctFloat(x, 0.5f, 1.5f), ValueUtil.correctFloat(y, 0.5f, 1.5f), ValueUtil.correctFloat(z, 0.5f, 1.5f));
        this.npc.updateClient = true;
    }

    public void setExplosionResistance(float resistance) {
        this.npc.stats.resistances.explosion = ValueUtil.correctFloat(resistance, 0.0f, 2.0f);
    }

    public float getExplosionResistance() {
        return this.npc.stats.resistances.explosion;
    }

    public void setMeleeResistance(float resistance) {
        this.npc.stats.resistances.melee = ValueUtil.correctFloat(resistance, 0.0f, 2.0f);
    }

    public float getMeleeResistance() {
        return this.npc.stats.resistances.melee;
    }

    public void setArrowResistance(float resistance) {
        this.npc.stats.resistances.arrow = ValueUtil.correctFloat(resistance, 0.0f, 2.0f);
    }

    public float getArrowResistance() {
        return this.npc.stats.resistances.arrow;
    }

    public void setKnockbackResistance(float resistance) {
        this.npc.stats.resistances.knockback = ValueUtil.correctFloat(resistance, 0.0f, 2.0f);
    }

    public float getKnockbackResistance() {
        return this.npc.stats.resistances.knockback;
    }

    public int getRetaliateType() {
        return this.npc.ai.onAttack;
    }

    public void setRetaliateType(int type) {
        if (type > -1 && type <= 3) {
            this.npc.ai.onAttack = type;
            this.npc.updateAI = true;
        }
    }

    public int getCombatRegen() {
        return this.npc.stats.combatRegen;
    }

    public void setCombatRegen(int regen) {
        this.npc.stats.combatRegen = regen;
    }

    public int getHealthRegen() {
        return this.npc.stats.healthRegen;
    }

    public void setHealthRegen(int regen) {
        this.npc.stats.healthRegen = regen;
    }

    @Override
    public long getAge() {
        return this.npc.totalTicksAlive;
    }

    public int getMovingType() {
        int movType = 0;
        switch (this.npc.ai.movingType) {
            case Standing: {
                movType = 0;
                break;
            }
            case Wandering: {
                movType = 1;
                break;
            }
            case MovingPath: {
                movType = 2;
            }
        }
        return movType;
    }

    public void setMovingType(int type) {
        switch (type) {
            case 0: {
                this.npc.ai.movingType = EnumMovingType.Standing;
                break;
            }
            case 1: {
                this.npc.ai.movingType = EnumMovingType.Wandering;
                break;
            }
            case 2: {
                this.npc.ai.movingType = EnumMovingType.MovingPath;
            }
        }
        this.npc.updateAI = true;
    }

    public int getStandingType() {
        int standType = 0;
        switch (this.npc.ai.standingType) {
            case RotateBody: {
                standType = 0;
                break;
            }
            case NoRotation: {
                standType = 1;
                break;
            }
            case Stalking: {
                standType = 2;
                break;
            }
            case HeadRotation: {
                standType = 3;
            }
        }
        return standType;
    }

    public void setStandingType(int type) {
        switch (type) {
            case 0: {
                this.npc.ai.standingType = EnumStandingType.RotateBody;
                break;
            }
            case 1: {
                this.npc.ai.standingType = EnumStandingType.NoRotation;
                break;
            }
            case 2: {
                this.npc.ai.standingType = EnumStandingType.Stalking;
                break;
            }
            case 3: {
                this.npc.ai.standingType = EnumStandingType.HeadRotation;
            }
        }
        this.npc.updateAI = true;
    }

    public float getBodyOffsetX() {
        return this.npc.ai.bodyOffsetX;
    }

    public void setBodyOffsetX(int offset) {
        if (offset > -1 && offset < 10) {
            this.npc.ai.bodyOffsetX = offset;
        }
    }

    public float getBodyOffsetY() {
        return this.npc.ai.bodyOffsetY;
    }

    public void setBodyOffsetY(int offset) {
        if (offset > -1 && offset < 10) {
            this.npc.ai.bodyOffsetY = offset;
        }
    }

    public float getBodyOffsetZ() {
        return this.npc.ai.bodyOffsetZ;
    }

    public void setBodyOffsetZ(int offset) {
        if (offset > -1 && offset < 10) {
            this.npc.ai.bodyOffsetZ = offset;
        }
    }

    public int getWanderingRange() {
        return this.npc.ai.walkingRange;
    }

    public void setWanderingRange(int range) {
        if (range > -1 && range < 50) {
            this.npc.ai.walkingRange = range;
        }
    }

    public boolean getInteractWithNPCs() {
        return this.npc.ai.npcInteracting;
    }

    public void setInteractWithNPCs(boolean interact) {
        this.npc.ai.npcInteracting = interact;
    }

    public boolean getStopOnInteract() {
        return this.npc.ai.stopAndInteract;
    }

    public void setStopOnInteract(boolean stopOnInteract) {
        this.npc.ai.stopAndInteract = stopOnInteract;
    }

    public int getWalkingSpeed() {
        return this.npc.ai.getWalkingSpeed();
    }

    public void setWalkingSpeed(int speed) {
        if (speed > -1 && speed < 10) {
            this.npc.ai.setWalkingSpeed(speed);
        }
    }

    public int getMovingPathType() {
        return this.npc.ai.movingPattern;
    }

    public void setMovingPathType(int type) {
        if (type > -1 && type <= 1) {
            this.npc.ai.movingPattern = type;
        }
    }

    public boolean getMovingPathPauses() {
        return this.npc.ai.movingPause;
    }

    public void setMovingPathPauses(boolean pauses) {
        this.npc.ai.movingPause = pauses;
    }

    public int getDoorInteract() {
        return this.npc.ai.doorInteract;
    }

    public void setDoorInteract(int type) {
        this.npc.ai.doorInteract = type;
        this.npc.updateAI = true;
    }

    public boolean getCanSwim() {
        return this.npc.ai.canSwim;
    }

    public void setCanSwim(boolean canSwim) {
        this.npc.ai.canSwim = canSwim;
    }

    public int getSheltersFrom() {
        return this.npc.ai.findShelter;
    }

    public void setSheltersFrom(int sheltersFrom) {
        this.npc.ai.findShelter = sheltersFrom;
        this.npc.updateAI = true;
    }

    public boolean getMustSeeTarget() {
        return this.npc.ai.directLOS;
    }

    public void setMustSeeTarget(boolean mustSee) {
        this.npc.ai.directLOS = mustSee;
        this.npc.updateAI = true;
    }

    public boolean getCanSprint() {
        return this.npc.ai.canSprint;
    }

    public void setCanSprint(boolean canSprint) {
        this.npc.ai.canSprint = canSprint;
        this.npc.updateAI = true;
    }

    public boolean getAvoidsWater() {
        return this.npc.ai.avoidsWater;
    }

    public void setAvoidsWater(boolean avoid) {
        this.npc.setAvoidWater(avoid);
    }

    public boolean getLeapAtTarget() {
        return this.npc.ai.canLeap;
    }

    public void setLeapAtTarget(boolean leap) {
        this.npc.ai.canLeap = leap;
        this.npc.updateAI = true;
    }

    public int getCanFireIndirect() {
        return this.npc.ai.canFireIndirect;
    }

    public void setCanFireIndirect(int canFireIndirect) {
        this.npc.ai.canFireIndirect = canFireIndirect;
    }

    public int getUseRangedAttack() {
        return this.npc.ai.useRangeMelee;
    }

    public void setUseRangedAttack(int useRanged) {
        this.npc.ai.useRangeMelee = useRanged;
        this.npc.updateAI = true;
    }

    public int getTacticalVariant() {
        int tacType = 0;
        switch (this.npc.ai.tacticalVariant) {
            case Default: {
                tacType = 0;
                break;
            }
            case Dodge: {
                tacType = 1;
                break;
            }
            case Surround: {
                tacType = 2;
                break;
            }
            case HitNRun: {
                tacType = 3;
                break;
            }
            case Ambush: {
                tacType = 4;
                break;
            }
            case Stalk: {
                tacType = 5;
                break;
            }
            case None: {
                tacType = 6;
            }
        }
        return tacType;
    }

    public void setTacticalVariant(int variant) {
        EnumNavType newVariant = EnumNavType.Default;
        switch (variant) {
            case 0: {
                newVariant = EnumNavType.Default;
                break;
            }
            case 1: {
                newVariant = EnumNavType.Dodge;
                break;
            }
            case 2: {
                newVariant = EnumNavType.Surround;
                break;
            }
            case 3: {
                newVariant = EnumNavType.HitNRun;
                break;
            }
            case 4: {
                newVariant = EnumNavType.Ambush;
                break;
            }
            case 5: {
                newVariant = EnumNavType.Stalk;
                break;
            }
            case 6: {
                newVariant = EnumNavType.None;
            }
        }
        this.npc.ai.tacticalVariant = newVariant;
        this.npc.updateAI = true;
    }

    public int getTacticalRadius() {
        return this.npc.ai.tacticalRadius;
    }

    public void setTacticalRadius(int radius) {
        this.npc.ai.tacticalRadius = radius;
    }

    public boolean getCobwebAffected() {
        return !this.npc.ai.ignoreCobweb;
    }

    public void setCobwebAffected(boolean isAffected) {
        this.npc.ai.ignoreCobweb = !isAffected;
    }

    public ScriptItemStack getDropItem(int slot) {
        if (slot < 0 || slot > 8) {
            return null;
        }
        IItemStack item = this.npc.inventory.items.get(slot);
        if (item == null) {
            return null;
        }
        return new ScriptItemStack(item.getMCItemStack());
    }

    public void setDropItem(int slot, ScriptItemStack item) {
        if (slot < 0 || slot > 8) {
            return;
        }
        this.npc.inventory.func_70299_a(slot + 7, item.getMCItemStack());
    }

    public int getDropItemChance(int slot) {
        if (slot < 0 || slot > 8) {
            return 0;
        }
        return this.npc.inventory.dropchance.get(slot);
    }

    public void setDropItemChance(int slot, int chance) {
        if (slot < 0 || slot > 8) {
            return;
        }
        chance = ValueUtil.CorrectInt(chance, 0, 100);
        this.npc.inventory.dropchance.put(slot, chance);
    }

    public String getWorldLine(int slot) {
        if (slot < 0 || slot > 7) {
            return null;
        }
        Line worldLine = this.npc.advanced.worldLines.lines.get(slot);
        if (this.npc.advanced.worldLines.lines.get(slot) == null) {
            return null;
        }
        return worldLine.text;
    }

    public void setWorldLine(int slot, String text) {
        if (slot < 0 || slot > 7) {
            return;
        }
        Line worldLine = this.npc.advanced.worldLines.lines.get(slot);
        if (worldLine == null) {
            worldLine = new Line();
            this.npc.advanced.worldLines.lines.put(slot, worldLine);
        }
        worldLine.text = text;
    }

    public String getWorldLineSound(int slot) {
        if (slot < 0 || slot > 7) {
            return null;
        }
        Line worldLine = this.npc.advanced.worldLines.lines.get(slot);
        if (worldLine == null) {
            return null;
        }
        return worldLine.sound;
    }

    public void setWorldLineSound(int slot, String sound) {
        if (slot < 0 || slot > 7) {
            return;
        }
        Line worldLine = this.npc.advanced.worldLines.lines.get(slot);
        if (worldLine == null) {
            worldLine = new Line();
            this.npc.advanced.worldLines.lines.put(slot, worldLine);
        }
        worldLine.sound = sound;
    }

    public String getInteractLine(int slot) {
        if (slot < 0 || slot > 7) {
            return null;
        }
        Line interactLine = this.npc.advanced.interactLines.lines.get(slot);
        if (interactLine == null) {
            return null;
        }
        return interactLine.text;
    }

    public void setInteractLine(int slot, String text) {
        if (slot < 0 || slot > 7) {
            return;
        }
        Line interactLine = this.npc.advanced.interactLines.lines.get(slot);
        if (this.npc.advanced.interactLines.lines.get(slot) == null) {
            interactLine = new Line(text);
            this.npc.advanced.interactLines.lines.put(slot, interactLine);
        } else {
            interactLine.text = text;
        }
    }

    public String getInteractLineSound(int slot) {
        if (slot < 0 || slot > 7) {
            return null;
        }
        Line interactLine = this.npc.advanced.interactLines.lines.get(slot);
        if (interactLine == null) {
            return null;
        }
        return interactLine.sound;
    }

    public void setInteractLineSound(int slot, String sound) {
        if (slot < 0 || slot > 7) {
            return;
        }
        Line worldLine = this.npc.advanced.interactLines.lines.get(slot);
        if (worldLine == null) {
            worldLine = new Line();
            this.npc.advanced.interactLines.lines.put(slot, worldLine);
        }
        worldLine.sound = sound;
    }

    public String getAttackLine(int slot) {
        if (slot < 0 || slot > 7) {
            return null;
        }
        Line attackLine = this.npc.advanced.attackLines.lines.get(slot);
        if (attackLine == null) {
            return null;
        }
        return attackLine.text;
    }

    public void setAttackLine(int slot, String text) {
        if (slot < 0 || slot > 7) {
            return;
        }
        Line attackLine = this.npc.advanced.attackLines.lines.get(slot);
        if (attackLine == null) {
            attackLine = new Line(text);
            this.npc.advanced.attackLines.lines.put(slot, attackLine);
        } else {
            attackLine.text = text;
        }
    }

    public String getAttackLineSound(int slot) {
        if (slot < 0 || slot > 7) {
            return null;
        }
        Line attackLine = this.npc.advanced.attackLines.lines.get(slot);
        if (attackLine == null) {
            return null;
        }
        return attackLine.sound;
    }

    public void setAttackLineSound(int slot, String sound) {
        if (slot < 0 || slot > 7) {
            return;
        }
        Line line = this.npc.advanced.attackLines.lines.get(slot);
        if (line == null) {
            line = new Line();
            this.npc.advanced.attackLines.lines.put(slot, line);
        }
        line.sound = sound;
    }

    public String getKilledLine(int slot) {
        if (slot < 0 || slot > 7) {
            return null;
        }
        Line killedLine = this.npc.advanced.killedLines.lines.get(slot);
        if (killedLine == null) {
            return null;
        }
        return killedLine.text;
    }

    public void setKilledLine(int slot, String text) {
        if (slot < 0 || slot > 7) {
            return;
        }
        Line killedLine = this.npc.advanced.killedLines.lines.get(slot);
        if (killedLine == null) {
            killedLine = new Line(text);
            this.npc.advanced.killedLines.lines.put(slot, killedLine);
        } else {
            killedLine.text = text;
        }
    }

    public String getKilledLineSound(int slot) {
        if (slot < 0 || slot > 7) {
            return null;
        }
        Line killedLine = this.npc.advanced.killedLines.lines.get(slot);
        if (killedLine == null) {
            return null;
        }
        return killedLine.sound;
    }

    public void setKilledLineSound(int slot, String sound) {
        if (slot < 0 || slot > 7) {
            return;
        }
        Line line = this.npc.advanced.killedLines.lines.get(slot);
        if (line == null) {
            line = new Line();
            this.npc.advanced.killedLines.lines.put(slot, line);
        }
        line.sound = sound;
    }

    public String getKillLine(int slot) {
        if (slot < 0 || slot > 7) {
            return null;
        }
        Line killLine = this.npc.advanced.killLines.lines.get(slot);
        if (killLine == null) {
            return null;
        }
        return killLine.text;
    }

    public void setKillLine(int slot, String text) {
        if (slot < 0 || slot > 7) {
            return;
        }
        Line killLine = this.npc.advanced.killLines.lines.get(slot);
        if (killLine == null) {
            killLine = new Line(text);
            this.npc.advanced.killLines.lines.put(slot, killLine);
        } else {
            killLine.text = text;
        }
    }

    public String getKillLineSound(int slot) {
        if (slot < 0 || slot > 7) {
            return null;
        }
        Line killLine = this.npc.advanced.killLines.lines.get(slot);
        if (killLine == null) {
            return null;
        }
        return killLine.sound;
    }

    public void setKillLineSound(int slot, String sound) {
        if (slot < 0 || slot > 7) {
            return;
        }
        Line line = this.npc.advanced.killLines.lines.get(slot);
        if (line == null) {
            line = new Line();
            this.npc.advanced.killLines.lines.put(slot, line);
        }
        line.sound = sound;
    }

    public String getIdleSound() {
        return this.npc.getIdleSound();
    }

    public void setIdleSound(String sound) {
        this.npc.advanced.idleSound = sound;
    }

    public String getHurtSound() {
        return this.npc.func_70621_aR();
    }

    public void setHurtSound(String sound) {
        this.npc.advanced.hurtSound = sound;
    }

    public String getDeathSound() {
        return this.npc.func_70673_aS();
    }

    public void setDeathSound(String sound) {
        this.npc.advanced.deathSound = sound;
    }

    public String getAngrySound() {
        return this.npc.getAngrySound();
    }

    public void setAngrySound(String sound) {
        this.npc.advanced.angrySound = sound;
    }

    public String getStepSound() {
        return this.npc.getStepSound();
    }

    public void setStepSound(String sound) {
        this.npc.advanced.stepSound = sound;
    }

    public String getCapeTexture() {
        return this.npc.display.getCapeTexture();
    }

    public void setCapeTexture(String texture) {
        this.npc.display.setCapeTexture(texture);
    }

    public String getOverlay() {
        return this.npc.display.getOverlayTexture();
    }

    public void setOverlay(String texture) {
        this.npc.display.setOverlayTexture(texture);
    }

    public boolean getLivingAnimation() {
        return this.npc.display.getHasLivingAnimation();
    }

    public void setLivingAnimation(boolean livingAnimation) {
        this.npc.display.setHashLivingAnimation(livingAnimation);
    }

    public int getAggroRange() {
        return this.npc.stats.aggroRange;
    }

    public void setAggroRange(int range) {
        this.npc.stats.aggroRange = range;
        this.npc.updateClient = true;
    }

    public int getCreatureType() {
        int creatureType = 0;
        switch (this.npc.stats.creatureType) {
            case UNDEFINED: {
                creatureType = 0;
                break;
            }
            case UNDEAD: {
                creatureType = 1;
                break;
            }
            case ARTHROPOD: {
                creatureType = 2;
            }
        }
        return creatureType;
    }

    public void setCreatureType(int creatureType) {
        switch (creatureType) {
            case 0: {
                this.npc.stats.creatureType = EnumCreatureAttribute.UNDEFINED;
                break;
            }
            case 1: {
                this.npc.stats.creatureType = EnumCreatureAttribute.UNDEAD;
                break;
            }
            case 2: {
                this.npc.stats.creatureType = EnumCreatureAttribute.ARTHROPOD;
            }
        }
        this.npc.updateClient = true;
    }

    public int getRespawnType() {
        return this.npc.stats.spawnCycle;
    }

    public void setRespawnType(int type) {
        this.npc.stats.spawnCycle = type;
        this.npc.updateClient = true;
    }

    public int getRespawnTime() {
        return this.npc.stats.respawnTime;
    }

    public void setRespawnTime(int time) {
        this.npc.stats.respawnTime = time;
        this.npc.updateClient = true;
    }

    public boolean getHideDeadBody() {
        return this.npc.stats.hideKilledBody;
    }

    public void setHideDeadBody(boolean hide) {
        this.npc.stats.hideKilledBody = hide;
        this.npc.updateClient = true;
    }

    public boolean getNaturallyDespawn() {
        return this.npc.stats.canDespawn;
    }

    public void setNaturallyDespawn(boolean naturallyDespawn) {
        this.npc.stats.canDespawn = naturallyDespawn;
    }

    public int getMeleeRange() {
        return this.npc.stats.attackRange;
    }

    public void setMeleeRange(int range) {
        this.npc.stats.attackRange = range;
    }

    public int getMeleeKnockback() {
        return this.npc.stats.knockback;
    }

    public void setMeleeKnockback(int knockback) {
        this.npc.stats.knockback = knockback;
    }

    public int getMeleeEffectType() {
        int meleeEffectType = 0;
        switch (this.npc.stats.potionType) {
            case None: {
                meleeEffectType = 0;
                break;
            }
            case Fire: {
                meleeEffectType = 1;
                break;
            }
            case Poison: {
                meleeEffectType = 2;
                break;
            }
            case Hunger: {
                meleeEffectType = 3;
                break;
            }
            case Weakness: {
                meleeEffectType = 4;
                break;
            }
            case Slowness: {
                meleeEffectType = 5;
                break;
            }
            case Nausea: {
                meleeEffectType = 6;
                break;
            }
            case Blindness: {
                meleeEffectType = 7;
                break;
            }
            case Wither: {
                meleeEffectType = 8;
            }
        }
        return meleeEffectType;
    }

    public void setMeleeEffectType(int type) {
        EnumPotionType cfr_ignored_0 = this.npc.stats.potionType;
        EnumPotionType meleeEffectType = EnumPotionType.None;
        switch (type) {
            case 0: {
                EnumPotionType cfr_ignored_1 = this.npc.stats.potionType;
                meleeEffectType = EnumPotionType.None;
                break;
            }
            case 1: {
                EnumPotionType cfr_ignored_2 = this.npc.stats.potionType;
                meleeEffectType = EnumPotionType.Fire;
                break;
            }
            case 2: {
                EnumPotionType cfr_ignored_3 = this.npc.stats.potionType;
                meleeEffectType = EnumPotionType.Poison;
                break;
            }
            case 3: {
                EnumPotionType cfr_ignored_4 = this.npc.stats.potionType;
                meleeEffectType = EnumPotionType.Hunger;
                break;
            }
            case 4: {
                EnumPotionType cfr_ignored_5 = this.npc.stats.potionType;
                meleeEffectType = EnumPotionType.Weakness;
                break;
            }
            case 5: {
                EnumPotionType cfr_ignored_6 = this.npc.stats.potionType;
                meleeEffectType = EnumPotionType.Slowness;
                break;
            }
            case 6: {
                EnumPotionType cfr_ignored_7 = this.npc.stats.potionType;
                meleeEffectType = EnumPotionType.Nausea;
                break;
            }
            case 7: {
                EnumPotionType cfr_ignored_8 = this.npc.stats.potionType;
                meleeEffectType = EnumPotionType.Blindness;
                break;
            }
            case 8: {
                EnumPotionType cfr_ignored_9 = this.npc.stats.potionType;
                meleeEffectType = EnumPotionType.Wither;
            }
        }
        this.npc.stats.potionType = meleeEffectType;
    }

    public int getMeleeEffectTime() {
        return this.npc.stats.potionDuration;
    }

    public void setMeleeEffectTime(int time) {
        this.npc.stats.potionDuration = time;
    }

    public boolean getMeleeEffectAmplified() {
        return this.npc.stats.potionAmp == 1;
    }

    public void setMeleeEffectAmplified(boolean amplified) {
        this.npc.stats.potionAmp = amplified ? 1 : 0;
    }

    public int getRangedAccuracy() {
        return this.npc.stats.accuracy;
    }

    public void setRangedAccuracy(int accuracy) {
        this.npc.stats.accuracy = ValueUtil.CorrectInt(accuracy, 0, 100);
    }

    public int getRangedRange() {
        return this.npc.stats.rangedRange;
    }

    public void setRangedRange(int range) {
        this.npc.stats.rangedRange = range;
    }

    public int getRangedMinDelay() {
        return this.npc.stats.minDelay;
    }

    public void setRangedMinDelay(int delay) {
        this.npc.stats.minDelay = delay;
    }

    public int getRangedMaxDelay() {
        return this.npc.stats.maxDelay;
    }

    public void setRangedMaxDelay(int delay) {
        this.npc.stats.maxDelay = delay;
    }

    public int getRangedFireRate() {
        return this.npc.stats.fireRate;
    }

    public void setRangedFireRate(int rate) {
        this.npc.stats.fireRate = rate;
    }

    public int getRangedBurstCount() {
        return this.npc.stats.burstCount;
    }

    public void setRangedBurstCount(int burstCount) {
        this.npc.stats.burstCount = burstCount;
    }

    public String getRangedSoundFX() {
        return this.npc.stats.fireSound;
    }

    public void setRangedSoundFX(String sound) {
        this.npc.stats.fireSound = sound;
        this.npc.updateClient = true;
    }

    public int getRangedShotCount() {
        return this.npc.stats.shotCount;
    }

    public void setRangedShotCount(int shotCount) {
        this.npc.stats.shotCount = shotCount;
    }

    public boolean getRangedAimWhileShooting() {
        return this.npc.stats.aimWhileShooting;
    }

    public void setRangedAimWhileShooting(boolean aim) {
        this.npc.stats.aimWhileShooting = aim;
    }

    public boolean getImmuneToFire() {
        return this.npc.stats.immuneToFire;
    }

    public void setImmuneToFire(boolean immune) {
        this.npc.stats.immuneToFire = immune;
    }

    public boolean getCanDrown() {
        return this.npc.stats.canDrown;
    }

    public void setCanDrown(boolean canDrown) {
        this.npc.stats.canDrown = canDrown;
    }

    public boolean getBurnsInSun() {
        return this.npc.stats.burnInSun;
    }

    public void setBurnsInSun(boolean burns) {
        this.npc.stats.burnInSun = burns;
    }

    public boolean getPotionImmune() {
        return this.npc.stats.potionImmune;
    }

    public void setPotionImmune(boolean immune) {
        this.npc.stats.potionImmune = immune;
    }

    public boolean getNoFallDamage() {
        return this.npc.stats.noFallDamage;
    }

    public void setNoFallDamage(boolean noDamage) {
        this.npc.stats.noFallDamage = noDamage;
    }

    public boolean getAttackInvisible() {
        return this.npc.stats.attackInvisible;
    }

    public void setAttackInvisible(boolean attack) {
        this.npc.stats.attackInvisible = attack;
    }

    public int getMinExp() {
        return this.npc.inventory.minExp;
    }

    public void setMinExp(int exp) {
        this.npc.inventory.minExp = exp;
    }

    public int getMaxExp() {
        return this.npc.inventory.maxExp;
    }

    public void setMaxExp(int exp) {
        this.npc.inventory.maxExp = exp;
    }

    public int getProjectilePower() {
        return this.npc.stats.pDamage;
    }

    public void setProjectilePower(int power) {
        this.npc.stats.pDamage = power;
    }

    public int getProjectilePunch() {
        return this.npc.stats.pImpact;
    }

    public void setProjectilePunch(int punch) {
        this.npc.stats.pImpact = punch;
    }

    public int getProjectileSize() {
        return this.npc.stats.pSize;
    }

    public void setProjectileSize(int size) {
        this.npc.stats.pSize = size;
    }

    public int getProjectileSpeed() {
        return this.npc.stats.pSpeed;
    }

    public void setProjectileSpeed(int speed) {
        this.npc.stats.pSpeed = speed;
    }

    public boolean getProjectileRender3D() {
        return this.npc.stats.pRender3D;
    }

    public void setProjectileRender3D(boolean render3d) {
        this.npc.stats.pRender3D = render3d;
    }

    public boolean getProjectileSpins() {
        return this.npc.stats.pSpin;
    }

    public void setProjectileSpins(boolean spins) {
        this.npc.stats.pSpin = spins;
    }

    public boolean getProjectileSticks() {
        return this.npc.stats.pStick;
    }

    public void setProjectileSticks(boolean sticks) {
        this.npc.stats.pStick = sticks;
    }

    public boolean getProjectileHasGravity() {
        return this.npc.stats.pPhysics;
    }

    public void setProjectileHasGravity(boolean hasGravity) {
        this.npc.stats.pPhysics = hasGravity;
    }

    public boolean getProjectileAccelerate() {
        return this.npc.stats.pXlr8;
    }

    public void setProjectileAccelerate(boolean accelerate) {
        this.npc.stats.pXlr8 = accelerate;
    }

    public boolean getProjectileExplode() {
        return this.npc.stats.pExplode;
    }

    public void setProjectileExplode(boolean explodes) {
        this.npc.stats.pExplode = explodes;
    }

    public int getProjectileExplodeSize() {
        return this.npc.stats.pArea;
    }

    public void setProjectileExplodeSize(int size) {
        this.npc.stats.pArea = size;
    }

    public int getProjectileEffectType() {
        int projectileEffectType = 0;
        switch (this.npc.stats.pEffect) {
            case None: {
                projectileEffectType = 0;
                break;
            }
            case Fire: {
                projectileEffectType = 1;
                break;
            }
            case Poison: {
                projectileEffectType = 2;
                break;
            }
            case Hunger: {
                projectileEffectType = 3;
                break;
            }
            case Weakness: {
                projectileEffectType = 4;
                break;
            }
            case Slowness: {
                projectileEffectType = 5;
                break;
            }
            case Nausea: {
                projectileEffectType = 6;
                break;
            }
            case Blindness: {
                projectileEffectType = 7;
                break;
            }
            case Wither: {
                projectileEffectType = 8;
            }
        }
        return projectileEffectType;
    }

    public void setProjectileEffectType(int type) {
        EnumPotionType cfr_ignored_0 = this.npc.stats.potionType;
        EnumPotionType projectileEffectType = EnumPotionType.None;
        switch (type) {
            case 0: {
                EnumPotionType cfr_ignored_1 = this.npc.stats.potionType;
                projectileEffectType = EnumPotionType.None;
                break;
            }
            case 1: {
                EnumPotionType cfr_ignored_2 = this.npc.stats.potionType;
                projectileEffectType = EnumPotionType.Fire;
                break;
            }
            case 2: {
                EnumPotionType cfr_ignored_3 = this.npc.stats.potionType;
                projectileEffectType = EnumPotionType.Poison;
                break;
            }
            case 3: {
                EnumPotionType cfr_ignored_4 = this.npc.stats.potionType;
                projectileEffectType = EnumPotionType.Hunger;
                break;
            }
            case 4: {
                EnumPotionType cfr_ignored_5 = this.npc.stats.potionType;
                projectileEffectType = EnumPotionType.Weakness;
                break;
            }
            case 5: {
                EnumPotionType cfr_ignored_6 = this.npc.stats.potionType;
                projectileEffectType = EnumPotionType.Slowness;
                break;
            }
            case 6: {
                EnumPotionType cfr_ignored_7 = this.npc.stats.potionType;
                projectileEffectType = EnumPotionType.Nausea;
                break;
            }
            case 7: {
                EnumPotionType cfr_ignored_8 = this.npc.stats.potionType;
                projectileEffectType = EnumPotionType.Blindness;
                break;
            }
            case 8: {
                EnumPotionType cfr_ignored_9 = this.npc.stats.potionType;
                projectileEffectType = EnumPotionType.Wither;
            }
        }
        this.npc.stats.pEffect = projectileEffectType;
    }

    public int getProjectileEffectTime() {
        return this.npc.stats.pDur;
    }

    public void setProjectileEffectTime(int time) {
        this.npc.stats.pDur = time;
    }

    public boolean getProjectileEffectAmplified() {
        return this.npc.stats.pEffAmp == 1;
    }

    public void setProjectileEffectAmplified(boolean amplified) {
        this.npc.stats.pEffAmp = amplified ? 1 : 0;
    }

    public boolean getProjectileGlows() {
        return this.npc.stats.pGlows;
    }

    public void setProjectileGlows(boolean glows) {
        this.npc.stats.pGlows = glows;
    }

    public int getProjectileTrailType() {
        int trailType = 0;
        switch (this.npc.stats.pTrail) {
            case None: {
                trailType = 0;
                break;
            }
            case Smoke: {
                trailType = 1;
                break;
            }
            case Portal: {
                trailType = 2;
                break;
            }
            case Redstone: {
                trailType = 3;
                break;
            }
            case Lightning: {
                trailType = 4;
                break;
            }
            case LargeSmoke: {
                trailType = 5;
                break;
            }
            case Magic: {
                trailType = 6;
                break;
            }
            case Enchant: {
                trailType = 7;
                break;
            }
            case Crit: {
                trailType = 8;
            }
        }
        return trailType;
    }

    public void setProjectileTrailType(int particleType) {
        EnumParticleType trailType = EnumParticleType.None;
        switch (particleType) {
            case 0: {
                trailType = EnumParticleType.None;
                break;
            }
            case 1: {
                trailType = EnumParticleType.Smoke;
                break;
            }
            case 2: {
                trailType = EnumParticleType.Portal;
                break;
            }
            case 3: {
                trailType = EnumParticleType.Redstone;
                break;
            }
            case 4: {
                trailType = EnumParticleType.Lightning;
                break;
            }
            case 5: {
                trailType = EnumParticleType.LargeSmoke;
                break;
            }
            case 6: {
                trailType = EnumParticleType.Magic;
                break;
            }
            case 7: {
                trailType = EnumParticleType.Enchant;
                break;
            }
            case 8: {
                trailType = EnumParticleType.Crit;
            }
        }
        this.npc.stats.pTrail = trailType;
    }
}

