/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.io.File;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockVine;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import noppes.npcs.CommonProxy;
import noppes.npcs.CustomItems;
import noppes.npcs.LogWriter;
import noppes.npcs.ServerEventsHandler;
import noppes.npcs.ServerTickHandler;
import noppes.npcs.api.wrapper.WrapperEntityData;
import noppes.npcs.command.CommandNoppes;
import noppes.npcs.config.ConfigLoader;
import noppes.npcs.config.ConfigProp;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.ChunkController;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.GlobalDataController;
import noppes.npcs.controllers.LinkedNpcController;
import noppes.npcs.controllers.MassBlockController;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.SpawnController;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.enchants.EnchantInterface;
import noppes.npcs.entity.EntityChairMount;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPC64x32;
import noppes.npcs.entity.EntityNPCGolem;
import noppes.npcs.entity.EntityNpcCrystal;
import noppes.npcs.entity.EntityNpcDragon;
import noppes.npcs.entity.EntityNpcPony;
import noppes.npcs.entity.EntityNpcSlime;
import noppes.npcs.entity.EntityProjectile;
import noppes.npcs.entity.old.EntityNPCDwarfFemale;
import noppes.npcs.entity.old.EntityNPCDwarfMale;
import noppes.npcs.entity.old.EntityNPCElfFemale;
import noppes.npcs.entity.old.EntityNPCElfMale;
import noppes.npcs.entity.old.EntityNPCEnderman;
import noppes.npcs.entity.old.EntityNPCFurryFemale;
import noppes.npcs.entity.old.EntityNPCFurryMale;
import noppes.npcs.entity.old.EntityNPCHumanFemale;
import noppes.npcs.entity.old.EntityNPCHumanMale;
import noppes.npcs.entity.old.EntityNPCOrcFemale;
import noppes.npcs.entity.old.EntityNPCOrcMale;
import noppes.npcs.entity.old.EntityNPCVillager;
import noppes.npcs.entity.old.EntityNpcEnderchibi;
import noppes.npcs.entity.old.EntityNpcMonsterFemale;
import noppes.npcs.entity.old.EntityNpcMonsterMale;
import noppes.npcs.entity.old.EntityNpcNagaFemale;
import noppes.npcs.entity.old.EntityNpcNagaMale;
import noppes.npcs.entity.old.EntityNpcSkeleton;

@Mod(modid="customnpcs", name="CustomNpcs", version="1.9.4", dependencies="required-after:Forge@[12.17.0.1976,);", acceptedMinecraftVersions="[1.9.4]")
public class CustomNpcs {
    @ConfigProp(info="Disable Chat Bubbles")
    public static boolean EnableChatBubbles = true;
    private static int NewEntityStartId = 0;
    @ConfigProp(info="Navigation search range for NPCs. Not recommended to increase if you have a slow pc or on a server")
    public static int NpcNavRange = 32;
    @ConfigProp(info="Set to true if you want the dialog command option to be able to use op commands like tp etc")
    public static boolean NpcUseOpCommands = false;
    @ConfigProp
    public static boolean InventoryGuiEnabled = true;
    @ConfigProp
    public static boolean DisableExtraItems = false;
    @ConfigProp
    public static boolean DisableExtraBlock = false;
    @ConfigProp
    public static boolean SceneButtonsEnabled = true;
    public static long ticks;
    @SidedProxy(clientSide="noppes.npcs.client.ClientProxy", serverSide="noppes.npcs.CommonProxy")
    public static CommonProxy proxy;
    @ConfigProp(info="Enables CustomNpcs startup update message")
    public static boolean EnableUpdateChecker;
    public static CustomNpcs instance;
    public static boolean FreezeNPCs;
    @ConfigProp(info="Only ops can create and edit npcs")
    public static boolean OpsOnly;
    @ConfigProp(info="Default interact line. Leave empty to not have one")
    public static String DefaultInteractLine;
    @ConfigProp
    public static boolean DisableEnchants;
    @ConfigProp(info="Number of chunk loading npcs that can be active at the same time")
    public static int ChuckLoaders;
    public static File Dir;
    @ConfigProp(info="Set to false if you want to disable guns")
    public static boolean GunsEnabled;
    @ConfigProp(info="Enables leaves decay")
    public static boolean LeavesDecayEnabled;
    @ConfigProp(info="Enables Vine Growth")
    public static boolean VineGrowthEnabled;
    @ConfigProp(info="Enables Ice Melting")
    public static boolean IceMeltsEnabled;
    @ConfigProp(info="Normal players can use soulstone on animals")
    public static boolean SoulStoneAnimals;
    @ConfigProp(info="Type 0 = Normal, Type 1 = Solid")
    public static int HeadWearType;
    @ConfigProp(info="When set to Minecraft it will use minecrafts font, when Default it will use OpenSans. Can only use fonts installed on your PC")
    public static String FontType;
    @ConfigProp(info="Font size for custom fonts (doesn't work with minecrafts font)")
    public static int FontSize;
    public static FMLEventChannel Channel;
    public static FMLEventChannel ChannelPlayer;
    public static ConfigLoader Config;
    public static CommandNoppes NoppesCommand;
    public static MinecraftServer Server;

    public CustomNpcs() {
        instance = this;
    }

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent ev) {
        Channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("CustomNPCs");
        ChannelPlayer = NetworkRegistry.INSTANCE.newEventDrivenChannel("CustomNPCsPlayer");
        Dir = new File(new File(ev.getModConfigurationDirectory(), ".."), "customnpcs");
        Dir.mkdir();
        Config = new ConfigLoader(this.getClass(), ev.getModConfigurationDirectory(), "CustomNpcs");
        Config.loadConfig();
        if (NpcNavRange < 16) {
            NpcNavRange = 16;
        }
        EnchantInterface.load();
        CustomItems.load();
        CapabilityManager.INSTANCE.register(PlayerData.class, new Capability.IStorage(){

            public NBTBase writeNBT(Capability capability, Object instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability capability, Object instance, EnumFacing side, NBTBase nbt) {
            }
        }, PlayerData.class);
        CapabilityManager.INSTANCE.register(WrapperEntityData.class, new Capability.IStorage(){

            public NBTBase writeNBT(Capability capability, Object instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability capability, Object instance, EnumFacing side, NBTBase nbt) {
            }
        }, WrapperEntityData.class);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        MinecraftForge.EVENT_BUS.register((Object)new ServerEventsHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ScriptController());
        FMLCommonHandler.instance().bus().register((Object)new ServerTickHandler());
        PixelmonHelper.load();
        this.registerNpc(EntityNPCHumanMale.class, "npchumanmale");
        this.registerNpc(EntityNPCVillager.class, "npcvillager");
        this.registerNpc(EntityNpcPony.class, "npcpony");
        this.registerNpc(EntityNPCHumanFemale.class, "npchumanfemale");
        this.registerNpc(EntityNPCDwarfMale.class, "npcdwarfmale");
        this.registerNpc(EntityNPCFurryMale.class, "npcfurrymale");
        this.registerNpc(EntityNpcMonsterMale.class, "npczombiemale");
        this.registerNpc(EntityNpcMonsterFemale.class, "npczombiefemale");
        this.registerNpc(EntityNpcSkeleton.class, "npcskeleton");
        this.registerNpc(EntityNPCDwarfFemale.class, "npcdwarffemale");
        this.registerNpc(EntityNPCFurryFemale.class, "npcfurryfemale");
        this.registerNpc(EntityNPCOrcMale.class, "npcorcfmale");
        this.registerNpc(EntityNPCOrcFemale.class, "npcorcfemale");
        this.registerNpc(EntityNPCElfMale.class, "npcelfmale");
        this.registerNpc(EntityNPCElfFemale.class, "npcelffemale");
        this.registerNpc(EntityNpcCrystal.class, "npccrystal");
        this.registerNpc(EntityNpcEnderchibi.class, "npcenderchibi");
        this.registerNpc(EntityNpcNagaMale.class, "npcnagamale");
        this.registerNpc(EntityNpcNagaFemale.class, "npcnagafemale");
        this.registerNpc(EntityNpcSlime.class, "NpcSlime");
        this.registerNpc(EntityNpcDragon.class, "NpcDragon");
        this.registerNpc(EntityNPCEnderman.class, "npcEnderman");
        this.registerNpc(EntityNPCGolem.class, "npcGolem");
        this.registerNpc(EntityCustomNpc.class, "CustomNpc");
        this.registerNpc(EntityNPC64x32.class, "CustomNpc64x32");
        this.registerNewEntity(EntityChairMount.class, "CustomNpcChairMount", 64, 10, false);
        this.registerNewEntity(EntityProjectile.class, "throwableitem", 64, 3, true);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new ChunkController());
        proxy.load();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent ev) {
        ForgeModContainer.fullBoundingBoxLadders = true;
        new RecipeController();
        proxy.postload();
    }

    @Mod.EventHandler
    public void setAboutToStart(FMLServerAboutToStartEvent event) {
        Server = event.getServer();
        ChunkController.instance.clear();
        new QuestController();
        new PlayerDataController();
        new FactionController();
        new TransportController();
        new GlobalDataController();
        new SpawnController();
        new LinkedNpcController();
        new MassBlockController();
        ScriptController.Instance.loadStoredData();
        ScriptController.HasStart = false;
        Set names = Block.field_149771_c.func_148742_b();
        for (ResourceLocation name : names) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)name);
            if (block instanceof BlockLeaves) {
                block.func_149675_a(LeavesDecayEnabled);
            }
            if (block instanceof BlockVine) {
                block.func_149675_a(VineGrowthEnabled);
            }
            if (!(block instanceof BlockIce)) continue;
            block.func_149675_a(IceMeltsEnabled);
        }
    }

    @Mod.EventHandler
    public void started(FMLServerStartedEvent event) {
        RecipeController.instance.load();
        new DialogController();
        new BankController();
        QuestController.instance.load();
        ScriptController.HasStart = true;
        ServerCloneController.Instance = new ServerCloneController();
    }

    @Mod.EventHandler
    public void stopped(FMLServerStoppedEvent event) {
        ServerCloneController.Instance = null;
        Server = null;
    }

    @Mod.EventHandler
    public void serverstart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)NoppesCommand);
    }

    private void registerNpc(Class<? extends Entity> cl, String name) {
        EntityList.field_75625_b.put(name, cl);
        EntityRegistry.registerModEntity(cl, (String)name, (int)NewEntityStartId++, (Object)this, (int)64, (int)3, (boolean)true);
    }

    private void registerNewEntity(Class<? extends Entity> cl, String name, int range, int update, boolean velocity) {
        EntityRegistry.registerModEntity(cl, (String)name, (int)NewEntityStartId++, (Object)this, (int)range, (int)update, (boolean)velocity);
    }

    public static File getWorldSaveDirectory() {
        return CustomNpcs.getWorldSaveDirectory(null);
    }

    public static File getWorldSaveDirectory(String s) {
        try {
            File savedir;
            if (Server == null) {
                return null;
            }
            File saves = new File(".");
            if (!Server.func_71262_S()) {
                saves = new File(Minecraft.func_71410_x().field_71412_D, "saves");
            }
            if (!(savedir = new File(new File(saves, Server.func_71270_I()), "customnpcs")).exists()) {
                savedir.mkdir();
            }
            if (s != null && !(savedir = new File(savedir, s)).exists()) {
                savedir.mkdir();
            }
            return savedir;
        }
        catch (Exception e) {
            LogWriter.error("Error getting worldsave", e);
            return null;
        }
    }

    static {
        EnableUpdateChecker = true;
        FreezeNPCs = false;
        OpsOnly = false;
        DefaultInteractLine = "Hello @p";
        DisableEnchants = false;
        ChuckLoaders = 20;
        GunsEnabled = true;
        LeavesDecayEnabled = true;
        VineGrowthEnabled = true;
        IceMeltsEnabled = true;
        SoulStoneAnimals = true;
        HeadWearType = 1;
        FontType = "Default";
        FontSize = 18;
        NoppesCommand = new CommandNoppes();
    }
}

