/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.item.ItemWrittenBook;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.api.event.RoleEvent;
import noppes.npcs.blocks.tiles.TileBigSign;
import noppes.npcs.blocks.tiles.TileBook;
import noppes.npcs.constants.EnumCompanionTalent;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.containers.ContainerMail;
import noppes.npcs.containers.ContainerTradingBlock;
import noppes.npcs.controllers.BankData;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerFactionData;
import noppes.npcs.controllers.PlayerMail;
import noppes.npcs.controllers.PlayerMailData;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleCompanion;

public class PacketHandlerPlayer {
    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        final EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
        final ByteBuf buffer = event.getPacket().payload();
        player.func_184102_h().func_152344_a(new Runnable(){

            @Override
            public void run() {
                EnumPlayerPacket type = null;
                try {
                    type = EnumPlayerPacket.values()[buffer.readInt()];
                    PacketHandlerPlayer.this.player(buffer, player, type);
                }
                catch (Exception e) {
                    LogWriter.error("Error with EnumPlayerPacket." + (Object)((Object)type), e);
                }
            }
        });
    }

    private void player(ByteBuf buffer, EntityPlayerMP player, EnumPlayerPacket type) throws Exception {
        if (type == EnumPlayerPacket.CompanionTalentExp) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.role != 6 || player != npc.getOwner()) {
                return;
            }
            int id = buffer.readInt();
            int exp = buffer.readInt();
            RoleCompanion role = (RoleCompanion)npc.roleInterface;
            if (exp <= 0 || !role.canAddExp(-exp) || id < 0 || id >= EnumCompanionTalent.values().length) {
                return;
            }
            EnumCompanionTalent talent = EnumCompanionTalent.values()[id];
            role.addExp(-exp);
            role.addTalentExp(talent, exp);
        } else if (type == EnumPlayerPacket.CompanionOpenInv) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.role != 6 || player != npc.getOwner()) {
                return;
            }
            NoppesUtilServer.sendOpenGui((EntityPlayer)player, EnumGuiType.CompanionInv, npc);
        } else if (type == EnumPlayerPacket.TradeAccept) {
            if (!(player.field_71070_bA instanceof ContainerTradingBlock)) {
                return;
            }
            ContainerTradingBlock con = (ContainerTradingBlock)player.field_71070_bA;
            if (!con.tile.isFull()) {
                return;
            }
            ContainerTradingBlock con2 = (ContainerTradingBlock)con.tile.other((EntityPlayer)player).field_71070_bA;
            if (con.state == 0) {
                con.setState(2);
                con2.setState(1);
            } else if (con.state == 1 || con.state == 2) {
                con.setState(3);
                con2.setState(3);
                for (int i = 0; i < 9; ++i) {
                    ItemStack item = con.craftMatrix.func_70301_a(i);
                    con.craftMatrix.func_70299_a(i, con2.craftMatrix.func_70301_a(i));
                    con2.craftMatrix.func_70299_a(i, item);
                }
            }
        } else if (type == EnumPlayerPacket.FollowerHire) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.role != 2) {
                return;
            }
            NoppesUtilPlayer.hireFollower(player, npc);
        } else if (type == EnumPlayerPacket.FollowerExtend) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.role != 2) {
                return;
            }
            NoppesUtilPlayer.extendFollower(player, npc);
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.roleInterface.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.FollowerState) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.role != 2) {
                return;
            }
            NoppesUtilPlayer.changeFollowerState(player, npc);
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.roleInterface.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.RoleGet) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.role == 0) {
                return;
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.roleInterface.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.Transport) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.role != 4) {
                return;
            }
            NoppesUtilPlayer.transport(player, npc, Server.readString(buffer));
        } else if (type == EnumPlayerPacket.BankUpgrade) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.role != 3) {
                return;
            }
            NoppesUtilPlayer.bankUpgrade(player, npc);
        } else if (type == EnumPlayerPacket.BankUnlock) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.role != 3) {
                return;
            }
            NoppesUtilPlayer.bankUnlock(player, npc);
        } else if (type == EnumPlayerPacket.BankSlotOpen) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.role != 3) {
                return;
            }
            int slot = buffer.readInt();
            int bankId = buffer.readInt();
            BankData data = PlayerDataController.instance.getBankData((EntityPlayer)player, bankId).getBankOrDefault(bankId);
            data.openBankGui((EntityPlayer)player, npc, bankId, slot);
        } else if (type == EnumPlayerPacket.Dialog) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null) {
                return;
            }
            NoppesUtilPlayer.dialogSelected(buffer.readInt(), buffer.readInt(), player, npc);
        } else if (type == EnumPlayerPacket.CheckQuestCompletion) {
            PlayerQuestData playerdata = PlayerData.get((EntityPlayer)player).questData;
            playerdata.checkQuestCompletion((EntityPlayer)player, null);
        } else if (type == EnumPlayerPacket.QuestLog) {
            NoppesUtilPlayer.sendQuestLogData(player);
        } else if (type == EnumPlayerPacket.QuestCompletion) {
            NoppesUtilPlayer.questCompletion(player, buffer.readInt());
        } else if (type == EnumPlayerPacket.FactionsGet) {
            PlayerFactionData data = PlayerData.get((EntityPlayer)player).factionData;
            Server.sendData(player, EnumPacketClient.GUI_DATA, data.getPlayerGuiData());
        } else if (type == EnumPlayerPacket.MailGet) {
            PlayerMailData data = PlayerData.get((EntityPlayer)player).mailData;
            Server.sendData(player, EnumPacketClient.GUI_DATA, data.saveNBTData(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.MailDelete) {
            long time = buffer.readLong();
            String username = Server.readString(buffer);
            PlayerMailData data = PlayerData.get((EntityPlayer)player).mailData;
            Iterator<PlayerMail> it = data.playermail.iterator();
            while (it.hasNext()) {
                PlayerMail mail = it.next();
                if (mail.time != time || !mail.sender.equals(username)) continue;
                it.remove();
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, data.saveNBTData(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.MailSend) {
            String username = PlayerDataController.instance.hasPlayer(Server.readString(buffer));
            if (username.isEmpty()) {
                NoppesUtilServer.sendGuiError((EntityPlayer)player, 0);
                return;
            }
            PlayerMail mail = new PlayerMail();
            String s = player.getDisplayNameString();
            if (!s.equals(player.func_70005_c_())) {
                s = s + "(" + player.func_70005_c_() + ")";
            }
            mail.readNBT(Server.readNBT(buffer));
            mail.sender = s;
            mail.items = ((ContainerMail)player.field_71070_bA).mail.items;
            if (mail.subject.isEmpty()) {
                NoppesUtilServer.sendGuiError((EntityPlayer)player, 1);
                return;
            }
            NBTTagCompound comp = new NBTTagCompound();
            comp.func_74778_a("username", username);
            NoppesUtilServer.sendGuiClose(player, 1, comp);
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc != null && EventHooks.onNPCRole(npc, new RoleEvent.MailmanEvent((EntityPlayer)player, npc.wrappedNPC, mail))) {
                return;
            }
            PlayerDataController.instance.addPlayerMessage(player.func_184102_h(), username, mail);
        } else if (type == EnumPlayerPacket.MailboxOpenMail) {
            long time = buffer.readLong();
            String username = Server.readString(buffer);
            player.func_71128_l();
            PlayerMailData data = PlayerData.get((EntityPlayer)player).mailData;
            for (PlayerMail mail : data.playermail) {
                if (mail.time != time || !mail.sender.equals(username)) continue;
                ContainerMail.staticmail = mail;
                player.openGui((Object)CustomNpcs.instance, EnumGuiType.PlayerMailman.ordinal(), player.field_70170_p, 0, 0, 0);
                break;
            }
        } else if (type == EnumPlayerPacket.MailRead) {
            long time = buffer.readLong();
            String username = Server.readString(buffer);
            PlayerMailData data = PlayerData.get((EntityPlayer)player).mailData;
            for (PlayerMail mail : data.playermail) {
                if (mail.time != time || !mail.sender.equals(username)) continue;
                mail.beenRead = true;
                if (!mail.hasQuest()) continue;
                PlayerQuestController.addActiveQuest(mail.getQuest(), (EntityPlayer)player);
            }
        } else if (type == EnumPlayerPacket.SignSave) {
            BlockPos pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
            TileEntity tile = player.field_70170_p.func_175625_s(pos);
            if (tile == null || !(tile instanceof TileBigSign)) {
                return;
            }
            TileBigSign sign = (TileBigSign)tile;
            if (sign.canEdit) {
                sign.setText(Server.readString(buffer));
                sign.canEdit = false;
                tile.func_70296_d();
                IBlockState state = player.field_70170_p.func_180495_p(pos);
                player.field_70170_p.func_184138_a(pos, state, state, 3);
            }
        } else if (type == EnumPlayerPacket.SaveBook) {
            BlockPos pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
            TileEntity tileentity = player.field_70170_p.func_175625_s(pos);
            if (!(tileentity instanceof TileBook)) {
                return;
            }
            TileBook tile = (TileBook)tileentity;
            if (tile.book.func_77973_b() == Items.field_151164_bB) {
                return;
            }
            boolean sign = buffer.readBoolean();
            ItemStack book = ItemStack.func_77949_a((NBTTagCompound)Server.readNBT(buffer));
            if (book == null) {
                return;
            }
            if (book.func_77973_b() == Items.field_151099_bA && !sign && ItemWritableBook.func_150930_a((NBTTagCompound)book.func_77978_p())) {
                tile.book.func_77983_a("pages", (NBTBase)book.func_77978_p().func_150295_c("pages", 8));
            }
            if (book.func_77973_b() == Items.field_151164_bB && sign && ItemWrittenBook.func_77828_a((NBTTagCompound)book.func_77978_p())) {
                tile.book.func_77983_a("author", (NBTBase)new NBTTagString(player.func_70005_c_()));
                tile.book.func_77983_a("title", (NBTBase)new NBTTagString(book.func_77978_p().func_74779_i("title")));
                tile.book.func_77983_a("pages", (NBTBase)book.func_77978_p().func_150295_c("pages", 8));
                tile.book.func_150996_a(Items.field_151164_bB);
            }
        }
    }
}

