/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai.selector;

import com.google.common.base.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import noppes.npcs.constants.EnumCompanionJobs;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobGuard;
import noppes.npcs.roles.JobSpawner;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.companion.CompanionGuard;

public class NPCAttackSelector
implements Predicate {
    private EntityNPCInterface npc;

    public NPCAttackSelector(EntityNPCInterface npc) {
        this.npc = npc;
    }

    public boolean isEntityApplicable(EntityLivingBase entity) {
        if (!entity.func_70089_S() || entity == this.npc || !this.npc.isInRange((Entity)entity, this.npc.stats.aggroRange) || entity.func_110143_aJ() < 1.0f) {
            return false;
        }
        if (this.npc.ai.directLOS && !this.npc.func_70635_at().func_75522_a((Entity)entity)) {
            return false;
        }
        if (!this.npc.ai.attackInvisible && entity.func_70644_a(MobEffects.field_76441_p) && this.npc.isInRange((Entity)entity, 2.0)) {
            return false;
        }
        if (!this.npc.isFollower() && this.npc.ai.returnToStart) {
            int allowedDistance = this.npc.stats.aggroRange * 2;
            if (this.npc.ai.getMovingType() == 1) {
                allowedDistance += this.npc.ai.walkingRange;
            }
            double distance = entity.func_70092_e((double)this.npc.getStartXPos(), this.npc.getStartYPos(), (double)this.npc.getStartZPos());
            if (this.npc.ai.getMovingType() == 2) {
                int[] arr = this.npc.ai.getCurrentMovingPath();
                distance = entity.func_70092_e((double)arr[0], (double)arr[1], (double)arr[2]);
            }
            if (distance > (double)(allowedDistance * allowedDistance)) {
                return false;
            }
        }
        if (this.npc.advanced.job == 3 && ((JobGuard)this.npc.jobInterface).isEntityApplicable((Entity)entity)) {
            return true;
        }
        if (this.npc.advanced.role == 6) {
            RoleCompanion role = (RoleCompanion)this.npc.roleInterface;
            if (role.job == EnumCompanionJobs.GUARD && ((CompanionGuard)role.jobInterface).isEntityApplicable((Entity)entity)) {
                return true;
            }
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            if (!this.npc.faction.isAggressiveToPlayer((EntityPlayer)player) || player.field_71075_bZ.field_75102_a) {
                return false;
            }
            if (this.npc.ai.targetType == 1 && player.func_70093_af()) {
                return this.npc.isInRange((Entity)player, this.npc.ai.specialAggroRange);
            }
            if (PixelmonHelper.Enabled && this.npc.advanced.job == 6 && ((JobSpawner)this.npc.jobInterface).hasPixelmon()) {
                return PixelmonHelper.canBattle((EntityPlayerMP)entity, this.npc);
            }
            return true;
        }
        if (entity instanceof EntityNPCInterface) {
            if (((EntityNPCInterface)entity).isKilled()) {
                return false;
            }
            if (this.npc.advanced.attackOtherFactions) {
                return this.npc.faction.isAggressiveToNpc((EntityNPCInterface)entity);
            }
        }
        return false;
    }

    public boolean apply(Object ob) {
        if (!(ob instanceof EntityLivingBase)) {
            return false;
        }
        return this.isEntityApplicable((EntityLivingBase)ob);
    }
}

