/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api;

import java.io.File;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import noppes.npcs.api.CommandNoppesBase;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.handler.IFactionHandler;
import noppes.npcs.api.handler.IRecipeHandler;
import noppes.npcs.api.item.IItemStack;

public abstract class NpcAPI {
    private static NpcAPI instance = null;

    public abstract ICustomNpc createNPC(World var1);

    public abstract ICustomNpc spawnNPC(World var1, int var2, int var3, int var4);

    public abstract IEntity getIEntity(Entity var1);

    public abstract IBlock getIBlock(World var1, BlockPos var2);

    public abstract IItemStack getIItemStack(ItemStack var1);

    public abstract IFactionHandler getFactions(MinecraftServer var1);

    public abstract IRecipeHandler getRecipes(MinecraftServer var1);

    public abstract EventBus events();

    public abstract void registerCommand(CommandNoppesBase var1);

    public abstract File getGlobalDir();

    public abstract File getWorldDir();

    public static boolean IsAvailable() {
        return Loader.isModLoaded((String)"customnpcs");
    }

    public static NpcAPI Instance() {
        if (instance != null) {
            return instance;
        }
        if (!NpcAPI.IsAvailable()) {
            return null;
        }
        try {
            Class<?> c = Class.forName("noppes.npcs.api.wrapper.WrapperNpcAPI");
            instance = (NpcAPI)c.getMethod("Instance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return instance;
    }
}

