/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.blocks.BlockRotated;
import noppes.npcs.blocks.tiles.TileBigSign;
import noppes.npcs.blocks.tiles.TileColorable;
import noppes.npcs.client.renderer.ITileRenderer;
import noppes.npcs.constants.EnumGuiType;

public class BlockBigSign
extends BlockContainer
implements ITileRenderer {
    public static final AxisAlignedBB AABB0 = new AxisAlignedBB(0.0, 0.0, (double)0.87f, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB AABB1 = new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.13f, 1.0, 1.0);
    public static final AxisAlignedBB AABB2 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)0.13f);
    public static final AxisAlignedBB AABB3 = new AxisAlignedBB((double)0.87f, 0.0, 0.0, 1.0, 1.0, 1.0);
    private TileEntity renderTile;

    public BlockBigSign() {
        super(Material.field_151575_d);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public int func_176201_c(IBlockState state) {
        return this.func_180651_a(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockRotated.DAMAGE, (Comparable)Integer.valueOf(meta));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockRotated.DAMAGE});
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BlockRotated.DAMAGE);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (!(tileentity instanceof TileColorable)) {
            return super.func_185496_a(state, world, pos);
        }
        TileColorable tile = (TileColorable)tileentity;
        if (tile.rotation == 0) {
            return AABB0;
        }
        if (tile.rotation == 2) {
            return AABB2;
        }
        if (tile.rotation == 3) {
            return AABB3;
        }
        if (tile.rotation == 1) {
            return AABB1;
        }
        return super.func_185496_a(state, world, pos);
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return new AxisAlignedBB(pos, pos);
    }

    public boolean func_180639_a(World par1World, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (par1World.field_72995_K) {
            return false;
        }
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (currentItem != null && currentItem.func_77973_b() == CustomItems.wand && CustomNpcsPermissions.hasPermission(player, CustomNpcsPermissions.EDIT_BLOCKS)) {
            TileBigSign tile = (TileBigSign)par1World.func_175625_s(pos);
            tile.canEdit = true;
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.BigSign, null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)BlockRotated.DAMAGE, (Comparable)Integer.valueOf(stack.func_77952_i())), 2);
        int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        TileBigSign tile = (TileBigSign)world.func_175625_s(pos);
        tile.rotation = l %= 4;
        if (entity instanceof EntityPlayer && !world.field_72995_K) {
            NoppesUtilServer.sendOpenGui((EntityPlayer)entity, EnumGuiType.BigSign, null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileBigSign();
    }

    @Override
    public TileEntity getTile() {
        if (this.renderTile == null) {
            this.renderTile = this.func_149915_a(null, 0);
        }
        return this.renderTile;
    }
}

