/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.CustomItems;
import noppes.npcs.blocks.BlockLightable;
import noppes.npcs.blocks.tiles.TileCandle;
import noppes.npcs.blocks.tiles.TileColorable;

public class BlockCandle
extends BlockLightable {
    public static final AxisAlignedBB AABB_NORMAL = new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, 0.5, (double)0.7f);
    public static final AxisAlignedBB AABB_UP = new AxisAlignedBB((double)0.1f, (double)0.1f, (double)0.1f, (double)0.9f, (double)0.8f, (double)0.9f);
    public static final AxisAlignedBB AABB0 = new AxisAlignedBB((double)0.2f, (double)0.4f, (double)0.2f, (double)0.8f, (double)0.9f, (double)0.8f);
    public static final AxisAlignedBB AABB1 = new AxisAlignedBB((double)0.2f, (double)0.4f, (double)0.4f, (double)0.8f, (double)0.9f, 1.0);
    public static final AxisAlignedBB AABB2 = new AxisAlignedBB((double)0.2f, (double)0.4f, 0.0, (double)0.8f, (double)0.9f, (double)0.6f);
    public static final AxisAlignedBB AABB3 = new AxisAlignedBB((double)0.4f, (double)0.4f, (double)0.2f, 1.0, (double)0.9f, (double)0.8f);
    public static final AxisAlignedBB AABB4 = new AxisAlignedBB(0.0, (double)0.4f, (double)0.2f, (double)0.6f, (double)0.9f, (double)0.8f);

    public BlockCandle(boolean lit) {
        super(Blocks.field_150344_f, lit);
        this.func_149672_a(SoundType.field_185848_a);
    }

    @Override
    public int maxRotation() {
        return 8;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (!(tileentity instanceof TileColorable)) {
            return super.func_185496_a(state, world, pos);
        }
        TileColorable tile = (TileColorable)tileentity;
        if (tile.color == 2) {
            if (tile.rotation == 0) {
                return AABB1;
            }
            if (tile.rotation == 4) {
                return AABB2;
            }
            if (tile.rotation == 6) {
                return AABB3;
            }
            if (tile.rotation == 2) {
                return AABB4;
            }
            return AABB0;
        }
        if (tile.color == 1) {
            return AABB_UP;
        }
        return AABB_NORMAL;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileCandle();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this == this.unlitBlock()) {
            return;
        }
        TileCandle tile = (TileCandle)world.func_175625_s(pos);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (tile.color == 1) {
            if (tile.rotation % 2 == 0) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)x + 0.5f), (double)((float)y + 0.66f), (double)((float)z + 0.13f), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)x + 0.5f), (double)((float)y + 0.65f), (double)((float)z + 0.13f), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)x + 0.5f), (double)((float)y + 0.66f), (double)((float)z + 0.87f), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)x + 0.5f), (double)((float)y + 0.65f), (double)((float)z + 0.87f), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)x + 0.13f), (double)((float)y + 0.66f), (double)((float)z + 0.5f), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)x + 0.13f), (double)((float)y + 0.65f), (double)((float)z + 0.5f), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)x + 0.87f), (double)((float)y + 0.66f), (double)((float)z + 0.5f), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)x + 0.87f), (double)((float)y + 0.65f), (double)((float)z + 0.5f), 0.0, 0.0, 0.0, new int[0]);
            } else {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)x + 0.24f), (double)((float)y + 0.66f), (double)((float)z + 0.24f), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)x + 0.24f), (double)((float)y + 0.65f), (double)((float)z + 0.24f), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)x + 0.76f), (double)((float)y + 0.66f), (double)((float)z + 0.76f), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)x + 0.76f), (double)((float)y + 0.65f), (double)((float)z + 0.76f), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)x + 0.24f), (double)((float)y + 0.66f), (double)((float)z + 0.76f), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)x + 0.24f), (double)((float)y + 0.65f), (double)((float)z + 0.76f), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)x + 0.76f), (double)((float)y + 0.66f), (double)((float)z + 0.24f), 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)x + 0.76f), (double)((float)y + 0.65f), (double)((float)z + 0.24f), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            float xOffset = 0.5f;
            float yOffset = 0.45f;
            float zOffset = 0.5f;
            if (tile.color == 2) {
                yOffset = 1.05f;
                if (tile.rotation == 0) {
                    zOffset += 0.12f;
                }
                if (tile.rotation == 4) {
                    zOffset -= 0.12f;
                }
                if (tile.rotation == 6) {
                    xOffset += 0.12f;
                }
                if (tile.rotation == 2) {
                    xOffset -= 0.12f;
                }
            }
            double d0 = (float)x + xOffset;
            double d1 = (float)y + yOffset;
            double d2 = (float)z + zOffset;
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public Block unlitBlock() {
        return CustomItems.candle_unlit;
    }

    @Override
    public Block litBlock() {
        return CustomItems.candle;
    }
}

