/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.NpcSounds;
import noppes.npcs.constants.EnumNpcToolMaterial;
import noppes.npcs.enchants.EnchantInterface;
import noppes.npcs.entity.EntityProjectile;
import noppes.npcs.items.ItemBullet;
import noppes.npcs.items.ItemNpcInterface;
import noppes.npcs.util.IProjectileCallback;

public class ItemGun
extends ItemNpcInterface {
    private EnumNpcToolMaterial material;

    public ItemGun(int par1, EnumNpcToolMaterial material) {
        super(par1);
        this.field_77777_bU = 1;
        this.material = material;
        this.func_77656_e(material.getMaxUses());
        this.func_77637_a(CustomItems.tabWeapon);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return itemstack != null && itemstack.func_77973_b() == ItemGun.this ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public void func_77615_a(final ItemStack stack, World worldObj, EntityLivingBase entity, int par4) {
        if (worldObj.field_72995_K) {
            return;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!this.hasBullet(player, stack) || !CustomNpcs.GunsEnabled) {
                this.playSound((EntityLivingBase)player, NpcSounds.GUN_EMPTY, 1.0f, 1.0f);
                return;
            }
            int ticks = this.func_77626_a(stack) - par4;
            if (ticks < 10) {
                return;
            }
            stack.func_77972_a(1, (EntityLivingBase)player);
            if (!player.field_71075_bZ.field_75098_d && !this.hasInfinite(stack)) {
                this.consumeItem(player, this.getBullet());
            }
        }
        ItemBullet bullet = (ItemBullet)this.getBullet();
        int damage = (bullet.getBulletDamage() + this.material.getDamageVsEntity() + 1) / 2 + 5;
        damage = (int)((float)damage + (float)(damage * EnchantInterface.getLevel(EnchantInterface.Damage, stack)) * 0.5f);
        EntityProjectile projectile = new EntityProjectile(worldObj, entity, new ItemStack(this.getBullet()), false);
        projectile.damage = damage;
        projectile.callback = new IProjectileCallback(){

            @Override
            public boolean onImpact(EntityProjectile entityProjectile, BlockPos pos, Entity entity) {
                int poison;
                if (entity == null || !(entity instanceof EntityLivingBase)) {
                    return false;
                }
                EntityLivingBase living = (EntityLivingBase)entity;
                int confusion = EnchantInterface.getLevel(EnchantInterface.Confusion, stack);
                if (confusion > 0 && living.func_70681_au().nextInt(4) > confusion) {
                    living.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 100));
                }
                if ((poison = EnchantInterface.getLevel(EnchantInterface.Poison, stack)) > 0 && living.func_70681_au().nextInt(4) > poison) {
                    living.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100));
                }
                return false;
            }
        };
        projectile.setSpeed(40);
        projectile.shoot(this.material.getDamageVsEntity() + 1);
        this.playSound(entity, NpcSounds.GUN_PISTAL_SHOT, 1.0f, field_77697_d.nextFloat() * 0.3f + 0.8f);
        worldObj.func_72838_d((Entity)projectile);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        int ticks = this.func_77626_a(stack) - count;
        if (ticks == 8 && !player.field_70170_p.field_72995_K) {
            this.playSound(player, NpcSounds.GUN_PISTAL_TRIGGER, 1.0f, 1.0f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemstack, World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    private boolean hasBullet(EntityPlayer player, ItemStack stack) {
        if (player.field_71075_bZ.field_75098_d || this.hasInfinite(stack)) {
            return true;
        }
        return this.hasItem(player, this.getBullet());
    }

    private Item getBullet() {
        switch (this.material) {
            case EMERALD: {
                return CustomItems.bulletEmerald;
            }
            case DIA: {
                return CustomItems.bulletDiamond;
            }
            case IRON: {
                return CustomItems.bulletIron;
            }
            case BRONZE: {
                return CustomItems.bulletBronze;
            }
            case GOLD: {
                return CustomItems.bulletGold;
            }
            case STONE: {
                return CustomItems.bulletStone;
            }
            case WOOD: {
                return CustomItems.bulletWood;
            }
        }
        return CustomItems.bulletBlack;
    }

    public boolean hasInfinite(ItemStack stack) {
        return EnchantInterface.getLevel(EnchantInterface.Infinite, stack) > 0;
    }

    @Override
    public int func_77619_b() {
        return this.material.getEnchantability();
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }
}

