/*
 * Decompiled with CFR 0.152.
 */
package jinngine.physics.force;

import jinngine.math.Vector3;
import jinngine.physics.Body;
import jinngine.physics.force.Force;

public final class ImpulseForce
implements Force {
    private final Body body;
    private final Vector3 point = new Vector3();
    private final Vector3 direction = new Vector3();
    private double magnitude;

    public ImpulseForce(Body body, Vector3 point, Vector3 direction, double magnitude) {
        this.body = body;
        this.point.assign(point);
        this.direction.assign(direction.normalize());
        this.magnitude = magnitude;
    }

    public final void setDirection(Vector3 direction) {
        this.direction.assign(direction);
    }

    public final void setPoint(Vector3 point) {
        this.point.assign(point);
    }

    public final void setMagnitude(double magnitude) {
        this.magnitude = magnitude;
    }

    @Override
    public final void apply(double dt) {
        this.body.applyForce(this.point, this.direction.multiply(this.magnitude / dt), dt);
        this.magnitude = 0.0;
    }
}

