/*
 * Decompiled with CFR 0.152.
 */
package jinngine.physics.solver;

import java.util.List;
import jinngine.math.Vector3;
import jinngine.physics.Body;
import jinngine.physics.solver.Solver;

public class NonsmoothNonlinearConjugateGradient
implements Solver {
    int max = 10000;
    public double[] pgsiters = new double[this.max];
    public double[] errors = new double[this.max];

    @Override
    public void setMaximumIterations(int n) {
    }

    public NonsmoothNonlinearConjugateGradient(int n) {
        this.max = n;
        this.pgsiters = new double[this.max];
        this.errors = new double[this.max];
    }

    @Override
    public double solve(List<Solver.NCPConstraint> constraints, List<Body> bodies, double epsilon) {
        double rnew = 0.0;
        double rold = 0.0;
        double beta = 0.0;
        int iter = 0;
        for (Solver.NCPConstraint ci : constraints) {
            ci.Fext = ci.j1.dot(ci.body1.externaldeltavelocity) + ci.j2.dot(ci.body1.externaldeltaomega) + ci.j3.dot(ci.body2.externaldeltavelocity) + ci.j4.dot(ci.body2.externaldeltaomega);
            ci.d = 0.0;
            ci.residual = 0.0;
        }
        for (Body b : bodies) {
            b.auxDeltav.assignZero();
            b.auxDeltaOmega.assignZero();
        }
        while (true) {
            for (Body bi : bodies) {
                bi.auxDeltav2.assign(bi.deltavelocity);
                bi.auxDeltaOmega2.assign(bi.deltaomega);
            }
            rold = rnew;
            rnew = 0.0;
            for (Solver.NCPConstraint ci : constraints) {
                double alpha = beta * ci.d;
                ci.lambda += alpha;
                ci.d = alpha + ci.residual;
                double w = ci.j1.dot(ci.body1.deltavelocity) + ci.j2.dot(ci.body1.deltaomega) + ci.j3.dot(ci.body2.deltavelocity) + ci.j4.dot(ci.body2.deltaomega) + ci.lambda * ci.damper + ci.Fext;
                double deltaLambda = (-ci.b - w) / (ci.diagonal + ci.damper);
                double lambda0 = ci.lambda;
                if (ci.coupling != null) {
                    ci.lower = -Math.abs(ci.coupling.lambda) * ci.coupling.mu;
                    ci.upper = Math.abs(ci.coupling.lambda) * ci.coupling.mu;
                }
                double newlambda = Math.max(ci.lower, Math.min(lambda0 + deltaLambda, ci.upper));
                deltaLambda = newlambda - lambda0;
                Vector3.multiplyAndAdd(ci.b1, deltaLambda, ci.body1.deltavelocity);
                Vector3.multiplyAndAdd(ci.b2, deltaLambda, ci.body1.deltaomega);
                Vector3.multiplyAndAdd(ci.b3, deltaLambda, ci.body2.deltavelocity);
                Vector3.multiplyAndAdd(ci.b4, deltaLambda, ci.body2.deltaomega);
                ci.lambda += deltaLambda;
                rnew += deltaLambda * deltaLambda;
                ci.residual = deltaLambda;
            }
            if (Math.abs(rnew) < epsilon || iter > this.max) break;
            beta = rnew / rold;
            if (beta > 1.0 || iter == 0) {
                beta = 0.0;
            }
            for (Body bi : bodies) {
                Vector3.minus(bi.auxDeltav2, bi.deltavelocity);
                Vector3.minus(bi.auxDeltaOmega2, bi.deltaomega);
                Vector3.multiply(bi.auxDeltav2, -1.0);
                Vector3.multiply(bi.auxDeltaOmega2, -1.0);
                Vector3.multiplyStoreAndAdd(bi.auxDeltav, beta, bi.deltavelocity);
                Vector3.multiplyStoreAndAdd(bi.auxDeltaOmega, beta, bi.deltaomega);
                Vector3.add(bi.auxDeltav, bi.auxDeltav2);
                Vector3.add(bi.auxDeltaOmega, bi.auxDeltaOmega2);
            }
            ++iter;
        }
        return 0.0;
    }

    public static final double merit(List<Solver.NCPConstraint> constraints, List<Body> bodies, boolean onlyfrictions) {
        double value = 0.0;
        for (Body bi : bodies) {
            bi.auxDeltav.assign(bi.deltavelocity);
            bi.auxDeltaOmega.assign(bi.deltaomega);
        }
        for (Solver.NCPConstraint ci : constraints) {
            ci.s = ci.lambda;
        }
        for (Solver.NCPConstraint ci : constraints) {
            double w = ci.j1.dot(ci.body1.auxDeltav) + ci.j2.dot(ci.body1.auxDeltaOmega) + ci.j3.dot(ci.body2.auxDeltav) + ci.j4.dot(ci.body2.auxDeltaOmega) + ci.s * ci.damper;
            double deltaLambda = (-ci.b - w) / (ci.diagonal + ci.damper);
            double lambda0 = ci.s;
            if (ci.coupling != null) {
                ci.l = -Math.abs(ci.coupling.s) * ci.coupling.mu;
                ci.u = Math.abs(ci.coupling.s) * ci.coupling.mu;
            } else {
                ci.l = ci.lower;
                ci.u = ci.upper;
            }
            double newlambda = Math.max(ci.l, Math.min(lambda0 + deltaLambda, ci.u));
            deltaLambda = newlambda - lambda0;
            Vector3.add(ci.body1.auxDeltav, ci.b1.multiply(deltaLambda));
            Vector3.add(ci.body1.auxDeltaOmega, ci.b2.multiply(deltaLambda));
            Vector3.add(ci.body2.auxDeltav, ci.b3.multiply(deltaLambda));
            Vector3.add(ci.body2.auxDeltaOmega, ci.b4.multiply(deltaLambda));
            ci.s += deltaLambda;
            value += deltaLambda * deltaLambda;
        }
        return value;
    }
}

