/*
 * Decompiled with CFR 0.152.
 */
package jinngine.physics.solver;

import java.util.List;
import jinngine.math.Vector3;
import jinngine.physics.Body;
import jinngine.physics.solver.Solver;

public class ProjectedGaussSeidel
implements Solver {
    private int maximumIterations = 35;
    private double deltaResidual = 0.0;

    public ProjectedGaussSeidel() {
    }

    public ProjectedGaussSeidel(int n) {
        this.maximumIterations = n;
    }

    @Override
    public void setMaximumIterations(int n) {
    }

    @Override
    public final double solve(List<Solver.NCPConstraint> constraints, List<Body> bodies, double epsilon) {
        double iterations = 0.0;
        for (Solver.NCPConstraint ci : constraints) {
            ci.Fext = ci.j1.dot(ci.body1.externaldeltavelocity) + ci.j2.dot(ci.body1.externaldeltaomega) + ci.j3.dot(ci.body2.externaldeltavelocity) + ci.j4.dot(ci.body2.externaldeltaomega);
        }
        for (int m = 0; m < this.maximumIterations; ++m) {
            this.deltaResidual = 0.0;
            for (Solver.NCPConstraint ci : constraints) {
                double w = ci.j1.dot(ci.body1.deltavelocity) + ci.j2.dot(ci.body1.deltaomega) + ci.j3.dot(ci.body2.deltavelocity) + ci.j4.dot(ci.body2.deltaomega) + ci.lambda * ci.damper + ci.Fext;
                double deltaLambda = (-ci.b - w) / (ci.diagonal + ci.damper);
                double lambda0 = ci.lambda;
                if (ci.coupling != null) {
                    ci.lower = -Math.abs(ci.coupling.lambda) * ci.coupling.mu;
                    ci.upper = Math.abs(ci.coupling.lambda) * ci.coupling.mu;
                }
                ci.lambda = Math.max(ci.lower, Math.min(lambda0 + deltaLambda, ci.upper));
                deltaLambda = ci.lambda - lambda0;
                this.deltaResidual += deltaLambda * deltaLambda;
                Vector3.add(ci.body1.deltavelocity, ci.b1.multiply(deltaLambda));
                Vector3.add(ci.body1.deltaomega, ci.b2.multiply(deltaLambda));
                Vector3.add(ci.body2.deltavelocity, ci.b3.multiply(deltaLambda));
                Vector3.add(ci.body2.deltaomega, ci.b4.multiply(deltaLambda));
            }
            if (this.deltaResidual < epsilon) break;
            iterations += 1.0;
        }
        return iterations;
    }
}

