/*
 * Decompiled with CFR 0.152.
 */
package jinngine.physics.solver.experimental;

import java.util.List;
import jinngine.math.Vector3;
import jinngine.physics.Body;
import jinngine.physics.solver.Solver;

public class Projection
implements Solver {
    @Override
    public final double solve(List<Solver.NCPConstraint> constraints, List<Body> bodies, double epsilon) {
        boolean projected = false;
        for (Solver.NCPConstraint ci : constraints) {
            double deltaLambda = 0.0;
            double lambda0 = ci.lambda;
            ci.lambda = Math.max(ci.lower, Math.min(lambda0 + deltaLambda, ci.upper));
            deltaLambda = ci.lambda - lambda0;
            if (deltaLambda != 0.0) {
                projected = true;
            }
            Vector3.add(ci.body1.deltavelocity, ci.b1.multiply(deltaLambda));
            Vector3.add(ci.body1.deltaomega, ci.b2.multiply(deltaLambda));
            Vector3.add(ci.body2.deltavelocity, ci.b3.multiply(deltaLambda));
            Vector3.add(ci.body2.deltaomega, ci.b4.multiply(deltaLambda));
        }
        return projected ? 1.0 : 0.0;
    }

    @Override
    public void setMaximumIterations(int n) {
    }
}

