/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client;

import com.flansmod.api.IControllable;
import com.flansmod.client.gui.GuiDriveableController;
import com.flansmod.client.model.GunAnimations;
import com.flansmod.client.teams.ClientTeamsData;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.mechas.EntityMecha;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.IScope;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.network.PacketTeamInfo;
import com.flansmod.common.teams.Team;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.vector.Vector3i;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FlansModClient
extends FlansMod {
    public static boolean doneTutorial = false;
    public static boolean controlModeMouse = true;
    public static int controlModeSwitchTimer = 20;
    public static float playerRecoil;
    public static float antiRecoil;
    public static HashMap<EntityLivingBase, GunAnimations> gunAnimationsRight;
    public static HashMap<EntityLivingBase, GunAnimations> gunAnimationsLeft;
    public static int scopeTime;
    public static IScope currentScope;
    public static float zoomProgress;
    public static float lastZoomProgress;
    public static float lastZoomLevel;
    public static float lastFOVZoomLevel;
    public static float originalMouseSensitivity;
    public static float originalFOV;
    public static int originalThirdPerson;
    public static boolean inPlane;
    public static PacketTeamInfo teamInfo;
    public static int hitMarkerTime;
    public static ArrayList<Vector3i> blockLightOverrides;
    public static int lightOverrideRefreshRate;
    public static Minecraft minecraft;

    public void load() {
        FlansModClient.log("Loading Flan's mod client side.");
    }

    public static void tick() {
        if (FlansModClient.minecraft.field_71439_g == null || FlansModClient.minecraft.field_71441_e == null) {
            return;
        }
        if (FlansModClient.minecraft.field_71439_g.field_70154_o instanceof IControllable && FlansModClient.minecraft.field_71462_r == null) {
            minecraft.func_147108_a((GuiScreen)new GuiDriveableController((IControllable)FlansModClient.minecraft.field_71439_g.field_70154_o));
        }
        if (teamInfo != null && FlansModClient.teamInfo.timeLeft > 0) {
            --FlansModClient.teamInfo.timeLeft;
        }
        ClientTeamsData.Tick();
        if (scopeTime > 0) {
            --scopeTime;
        }
        if (playerRecoil > 0.0f) {
            playerRecoil *= 0.8f;
        }
        if (hitMarkerTime > 0) {
            --hitMarkerTime;
        }
        FlansModClient.minecraft.field_71439_g.field_70125_A -= playerRecoil;
        FlansModClient.minecraft.field_71439_g.field_70125_A += (antiRecoil += playerRecoil) * 0.2f;
        antiRecoil *= 0.8f;
        for (GunAnimations g : gunAnimationsRight.values()) {
            g.update();
        }
        for (GunAnimations g : gunAnimationsLeft.values()) {
            g.update();
        }
        for (GunAnimations obj : FlansModClient.minecraft.field_71441_e.field_73010_i) {
            EntityPlayer player = (EntityPlayer)obj;
            ItemStack currentItem = player.func_71045_bC();
            if (currentItem == null || !(currentItem.func_77973_b() instanceof ItemGun)) continue;
            if (player == FlansModClient.minecraft.field_71439_g && FlansModClient.minecraft.field_71474_y.field_74320_O == 0) {
                player.func_71041_bz();
                continue;
            }
            player.func_71008_a(currentItem, 100);
        }
        Item itemInHand = null;
        ItemStack itemstackInHand = FlansModClient.minecraft.field_71439_g.field_71071_by.func_70448_g();
        if (itemstackInHand != null) {
            itemInHand = itemstackInHand.func_77973_b();
        }
        if (currentScope != null) {
            GameSettings gameSettings = FMLClientHandler.instance().getClient().field_71474_y;
            if (FMLClientHandler.instance().getClient().field_71462_r != null || itemInHand == null || !(itemInHand instanceof ItemGun) || ((ItemGun)itemInHand).GetType().getCurrentScope(itemstackInHand) != currentScope) {
                currentScope = null;
                FlansModClient.minecraft.field_71474_y.field_74334_X = originalFOV;
                FlansModClient.minecraft.field_71474_y.field_74341_c = originalMouseSensitivity;
                FlansModClient.minecraft.field_71474_y.field_74320_O = originalThirdPerson;
            }
        }
        lastZoomProgress = zoomProgress;
        zoomProgress = currentScope == null ? (zoomProgress *= 0.66f) : 1.0f - (1.0f - zoomProgress) * 0.66f;
        if (FlansModClient.minecraft.field_71439_g.field_70154_o instanceof IControllable) {
            inPlane = true;
            try {
                ObfuscationReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)FlansModClient.minecraft.field_71460_t, (Object)Float.valueOf(((IControllable)FlansModClient.minecraft.field_71439_g.field_70154_o).getCameraDistance()), (String[])new String[]{"thirdPersonDistance", "q", "field_78490_B"});
            }
            catch (Exception e) {
                FlansModClient.log("I forgot to update obfuscated reflection D:");
                throw new RuntimeException(e);
            }
        }
        if (inPlane) {
            try {
                ObfuscationReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)FlansModClient.minecraft.field_71460_t, (Object)Float.valueOf(4.0f), (String[])new String[]{"thirdPersonDistance", "q", "field_78490_B"});
            }
            catch (Exception e) {
                FlansModClient.log("I forgot to update obfuscated reflection D:");
                throw new RuntimeException(e);
            }
            inPlane = false;
        }
        if (controlModeSwitchTimer > 0) {
            --controlModeSwitchTimer;
        }
    }

    public static void SetScope(IScope scope) {
        GameSettings gameSettings = FMLClientHandler.instance().getClient().field_71474_y;
        if (scopeTime <= 0 && FMLClientHandler.instance().getClient().field_71462_r == null) {
            if (currentScope == null) {
                currentScope = scope;
                lastZoomLevel = scope.getZoomFactor();
                lastFOVZoomLevel = scope.getFOVFactor();
                float f = originalMouseSensitivity = gameSettings.field_74341_c;
                gameSettings.field_74341_c = f / (float)Math.sqrt(scope.getZoomFactor());
                originalThirdPerson = gameSettings.field_74320_O;
                gameSettings.field_74320_O = 0;
                originalFOV = gameSettings.field_74334_X;
            } else {
                currentScope = null;
                gameSettings.field_74341_c = originalMouseSensitivity;
                gameSettings.field_74320_O = originalThirdPerson;
                gameSettings.field_74334_X = originalFOV;
            }
            scopeTime = 10;
        }
    }

    public static void UpdateCameraZoom(float smoothing) {
        if (Math.abs(zoomProgress - lastZoomProgress) > 1.0E-4f) {
            float actualZoomProgress = lastZoomProgress + (zoomProgress - lastZoomProgress) * smoothing;
            float botchedZoomProgress = zoomProgress > 0.8f ? 1.0f : 0.0f;
            double zoomLevel = botchedZoomProgress * lastZoomLevel + (1.0f - botchedZoomProgress);
            float FOVZoomLevel = actualZoomProgress * lastFOVZoomLevel + (1.0f - actualZoomProgress);
            if (Math.abs(zoomLevel - 1.0) < (double)0.01f) {
                zoomLevel = 1.0;
            }
            float zoomToApply = Math.max(FOVZoomLevel, (float)zoomLevel);
            FlansModClient.minecraft.field_71474_y.field_74334_X = ((originalFOV * 40.0f + 70.0f) / zoomToApply - 70.0f) / 40.0f;
        }
    }

    private boolean checkFileExists(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                FlansMod.log("Failed to create file");
                FlansMod.log(file.getAbsolutePath());
            }
            return false;
        }
        return true;
    }

    public static boolean flipControlMode() {
        if (controlModeSwitchTimer > 0) {
            return false;
        }
        controlModeMouse = !controlModeMouse;
        FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)(controlModeMouse ? new GuiDriveableController((IControllable)FMLClientHandler.instance().getClient().field_71439_g.field_70154_o) : null));
        controlModeSwitchTimer = 40;
        return true;
    }

    public static void reloadModels(boolean reloadSkins) {
        for (InfoType type : InfoType.infoTypes.values()) {
            type.reloadModel();
        }
        if (reloadSkins) {
            proxy.forceReload();
        }
    }

    public static Team getTeam(int spawnerTeamID) {
        if (teamInfo == null) {
            return null;
        }
        return teamInfo.getTeam(spawnerTeamID);
    }

    public static boolean isCurrentMap(String map) {
        return teamInfo != null && FlansModClient.teamInfo.mapShortName != null && FlansModClient.teamInfo.mapShortName.equals(map);
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityFX getParticle(String s, World w, double x, double y, double z) {
        Minecraft mc = Minecraft.func_71410_x();
        int particleID = 0;
        int[] data = new int[]{};
        if (s.equals("hugeexplosion")) {
            particleID = EnumParticleTypes.EXPLOSION_HUGE.func_179348_c();
        } else if (s.equals("largeexplode")) {
            particleID = EnumParticleTypes.EXPLOSION_LARGE.func_179348_c();
        } else if (s.equals("explode")) {
            particleID = EnumParticleTypes.EXPLOSION_NORMAL.func_179348_c();
        } else if (s.equals("fireworksSpark")) {
            particleID = EnumParticleTypes.FIREWORKS_SPARK.func_179348_c();
        } else if (s.equals("bubble")) {
            particleID = EnumParticleTypes.WATER_BUBBLE.func_179348_c();
        } else if (s.equals("splash")) {
            particleID = EnumParticleTypes.WATER_SPLASH.func_179348_c();
        } else if (s.equals("wake")) {
            particleID = EnumParticleTypes.WATER_WAKE.func_179348_c();
        } else if (s.equals("drop")) {
            particleID = EnumParticleTypes.WATER_DROP.func_179348_c();
        } else if (s.equals("suspended")) {
            particleID = EnumParticleTypes.SUSPENDED.func_179348_c();
        } else if (s.equals("depthsuspend")) {
            particleID = EnumParticleTypes.SUSPENDED_DEPTH.func_179348_c();
        } else if (s.equals("townaura")) {
            particleID = EnumParticleTypes.TOWN_AURA.func_179348_c();
        } else if (s.equals("crit")) {
            particleID = EnumParticleTypes.CRIT.func_179348_c();
        } else if (s.equals("magicCrit")) {
            particleID = EnumParticleTypes.CRIT_MAGIC.func_179348_c();
        } else if (s.equals("smoke")) {
            particleID = EnumParticleTypes.SMOKE_NORMAL.func_179348_c();
        } else if (s.equals("largesmoke")) {
            particleID = EnumParticleTypes.SMOKE_LARGE.func_179348_c();
        } else if (s.equals("spell")) {
            particleID = EnumParticleTypes.SPELL.func_179348_c();
        } else if (s.equals("instantSpell")) {
            particleID = EnumParticleTypes.SPELL_INSTANT.func_179348_c();
        } else if (s.equals("mobSpell")) {
            particleID = EnumParticleTypes.SPELL_MOB.func_179348_c();
        } else if (s.equals("mobSpellAmbient")) {
            particleID = EnumParticleTypes.SPELL_MOB_AMBIENT.func_179348_c();
        } else if (s.equals("witchMagic")) {
            particleID = EnumParticleTypes.SPELL_WITCH.func_179348_c();
        } else if (s.equals("dripWater")) {
            particleID = EnumParticleTypes.DRIP_WATER.func_179348_c();
        } else if (s.equals("dripLava")) {
            particleID = EnumParticleTypes.DRIP_LAVA.func_179348_c();
        } else if (s.equals("angryVillager")) {
            particleID = EnumParticleTypes.VILLAGER_ANGRY.func_179348_c();
        } else if (s.equals("happyVillager")) {
            particleID = EnumParticleTypes.VILLAGER_HAPPY.func_179348_c();
        } else if (s.equals("note")) {
            particleID = EnumParticleTypes.NOTE.func_179348_c();
        } else if (s.equals("portal")) {
            particleID = EnumParticleTypes.PORTAL.func_179348_c();
        } else if (s.equals("enchantmenttable")) {
            particleID = EnumParticleTypes.ENCHANTMENT_TABLE.func_179348_c();
        } else if (s.equals("flame")) {
            particleID = EnumParticleTypes.FLAME.func_179348_c();
        } else if (s.equals("lava")) {
            particleID = EnumParticleTypes.LAVA.func_179348_c();
        } else if (s.equals("footstep")) {
            particleID = EnumParticleTypes.FOOTSTEP.func_179348_c();
        } else if (s.equals("cloud")) {
            particleID = EnumParticleTypes.CLOUD.func_179348_c();
        } else if (s.equals("reddust")) {
            particleID = EnumParticleTypes.REDSTONE.func_179348_c();
        } else if (s.equals("snowballpoof")) {
            particleID = EnumParticleTypes.SNOWBALL.func_179348_c();
        } else if (s.equals("snowshovel")) {
            particleID = EnumParticleTypes.SNOW_SHOVEL.func_179348_c();
        } else if (s.equals("slime")) {
            particleID = EnumParticleTypes.SLIME.func_179348_c();
        } else if (s.equals("heart")) {
            particleID = EnumParticleTypes.HEART.func_179348_c();
        } else if (s.equals("barrier")) {
            particleID = EnumParticleTypes.BARRIER.func_179348_c();
        } else if (s.contains("_")) {
            String[] split = s.split("_", 3);
            if (split[0].equals("iconcrack")) {
                data = new int[]{Item.func_150891_b((Item)InfoType.getRecipeElement(split[1], 0).func_77973_b())};
                particleID = EnumParticleTypes.ITEM_CRACK.func_179348_c();
            } else {
                data = new int[]{Block.func_149682_b((Block)Block.func_149634_a((Item)InfoType.getRecipeElement(split[1], 0).func_77973_b()))};
                if (split[0].equals("blockcrack")) {
                    particleID = EnumParticleTypes.BLOCK_CRACK.func_179348_c();
                } else if (split[0].equals("blockdust")) {
                    particleID = EnumParticleTypes.BLOCK_DUST.func_179348_c();
                }
            }
        }
        EntityFX fx = mc.field_71452_i.func_178927_a(particleID, x, y, z, 0.0, 0.0, 0.0, data);
        if (mc.field_71474_y.field_74347_j) {
            fx.field_70155_l = 200.0;
        }
        return fx;
    }

    public static GunAnimations getGunAnimations(EntityLivingBase living, boolean offHand) {
        GunAnimations animations = null;
        if (offHand) {
            if (gunAnimationsLeft.containsKey(living)) {
                animations = gunAnimationsLeft.get(living);
            } else {
                animations = new GunAnimations();
                gunAnimationsLeft.put(living, animations);
            }
        } else if (gunAnimationsRight.containsKey(living)) {
            animations = gunAnimationsRight.get(living);
        } else {
            animations = new GunAnimations();
            gunAnimationsRight.put(living, animations);
        }
        return animations;
    }

    public static void AddHitMarker() {
        hitMarkerTime = 20;
    }

    public static void UpdateFlashlights(Minecraft mc) {
        if (FlansMod.ticker % lightOverrideRefreshRate == 0 && mc.field_71441_e != null) {
            int i;
            lightOverrideRefreshRate = mc.field_71474_y.field_74347_j ? 10 : 20;
            for (Vector3i v : blockLightOverrides) {
                mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(v.x, v.y, v.z));
            }
            blockLightOverrides.clear();
            for (Vector3i obj : mc.field_71441_e.field_73010_i) {
                GunType type;
                AttachmentType grip;
                EntityPlayer player = (EntityPlayer)obj;
                ItemStack currentHeldItem = player.func_71045_bC();
                if (currentHeldItem == null || !(currentHeldItem.func_77973_b() instanceof ItemGun) || (grip = (type = ((ItemGun)currentHeldItem.func_77973_b()).GetType()).getGrip(currentHeldItem)) == null || !grip.flashlight) continue;
                for (i = 0; i < 2; ++i) {
                    MovingObjectPosition ray = player.func_174822_a((double)(grip.flashlightRange / 2.0f * (float)(i + 1)), 1.0f);
                    if (ray == null) continue;
                    int x = ray.func_178782_a().func_177958_n();
                    int y = ray.func_178782_a().func_177956_o();
                    int z = ray.func_178782_a().func_177952_p();
                    EnumFacing side = ray.field_178784_b;
                    switch (side) {
                        case DOWN: {
                            --y;
                            break;
                        }
                        case UP: {
                            ++y;
                            break;
                        }
                        case NORTH: {
                            --z;
                            break;
                        }
                        case SOUTH: {
                            ++z;
                            break;
                        }
                        case WEST: {
                            --x;
                            break;
                        }
                        case EAST: {
                            ++x;
                        }
                    }
                    blockLightOverrides.add(new Vector3i(x, y, z));
                    mc.field_71441_e.func_175653_a(EnumSkyBlock.BLOCK, new BlockPos(x, y, z), 12);
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y + 1, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y - 1, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x + 1, y, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x - 1, y, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y, z + 1));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y, z - 1));
                }
            }
            for (Vector3i obj : mc.field_71441_e.field_72996_f) {
                int z;
                int y;
                int x;
                if (obj instanceof EntityBullet) {
                    EntityBullet bullet = (EntityBullet)((Object)obj);
                    if (bullet.field_70128_L || !bullet.type.hasLight) continue;
                    x = MathHelper.func_76128_c((double)bullet.field_70165_t);
                    y = MathHelper.func_76128_c((double)bullet.field_70163_u);
                    z = MathHelper.func_76128_c((double)bullet.field_70161_v);
                    blockLightOverrides.add(new Vector3i(x, y, z));
                    mc.field_71441_e.func_175653_a(EnumSkyBlock.BLOCK, new BlockPos(x, y, z), 15);
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y + 1, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y - 1, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x + 1, y, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x - 1, y, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y, z + 1));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y, z - 1));
                    continue;
                }
                if (!(obj instanceof EntityMecha)) continue;
                EntityMecha mecha = (EntityMecha)((Object)obj);
                x = MathHelper.func_76128_c((double)mecha.field_70165_t);
                y = MathHelper.func_76128_c((double)mecha.field_70163_u);
                z = MathHelper.func_76128_c((double)mecha.field_70161_v);
                if (mecha.lightLevel() > 0) {
                    blockLightOverrides.add(new Vector3i(x, y, z));
                    mc.field_71441_e.func_175653_a(EnumSkyBlock.BLOCK, new BlockPos(x, y, z), Math.max(mc.field_71441_e.func_175642_b(EnumSkyBlock.BLOCK, new BlockPos(x, y, z)), mecha.lightLevel()));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y + 1, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y - 1, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x + 1, y, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x - 1, y, z));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y, z + 1));
                    mc.field_71441_e.func_175705_a(EnumSkyBlock.BLOCK, new BlockPos(x, y, z - 1));
                }
                if (!mecha.forceDark()) continue;
                for (i = -3; i <= 3; ++i) {
                    for (int j = -3; j <= 3; ++j) {
                        for (int k = -3; k <= 3; ++k) {
                            int xd = i + x;
                            int yd = j + y;
                            int zd = k + z;
                            blockLightOverrides.add(new Vector3i(xd, yd, zd));
                            mc.field_71441_e.func_175653_a(EnumSkyBlock.SKY, new BlockPos(xd, yd, zd), Math.abs(i) + Math.abs(j) + Math.abs(k));
                        }
                    }
                }
            }
        }
    }

    static {
        gunAnimationsRight = new HashMap();
        gunAnimationsLeft = new HashMap();
        currentScope = null;
        zoomProgress = 0.0f;
        lastZoomProgress = 0.0f;
        lastZoomLevel = 1.0f;
        lastFOVZoomLevel = 1.0f;
        originalMouseSensitivity = 0.5f;
        originalFOV = 90.0f;
        originalThirdPerson = 0;
        inPlane = false;
        hitMarkerTime = 0;
        blockLightOverrides = new ArrayList();
        lightOverrideRefreshRate = 5;
        minecraft = FMLClientHandler.instance().getClient();
    }
}

