/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.gui.teams;

import com.flansmod.client.FlansModResourceHandler;
import com.flansmod.client.gui.teams.GuiTeamsBase;
import com.flansmod.client.teams.ClientTeamsData;
import com.flansmod.common.FlansMod;
import com.flansmod.common.ModuloHelper;
import com.flansmod.common.guns.Paintjob;
import com.flansmod.common.teams.LoadoutPool;
import com.flansmod.common.teams.PlayerRankData;
import com.flansmod.common.teams.RewardBox;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;

public class GuiOpenRewardBox
extends GuiTeamsBase {
    private static final ResourceLocation texture = new ResourceLocation("flansmod", "gui/OpenCrates.png");
    private static final int WIDTH = 196;
    private static final int HEIGHT = 200;
    private static final int WAITING_FOR_SERVER = -1;
    private static int spinTime = 30;
    private static int slowdownTime = 130;
    private static long timeOfLastSound = 0L;
    private static Random gunScrambler = new Random();
    private float spinSpeed = 0.5555556f;
    private ArrayList<Paintjob> options = new ArrayList();
    private int target = -1;
    private EnumPageState state = EnumPageState.SPINNING;
    private int timeLeftInState = spinTime;
    private float spinner = 0.0f;
    private GuiButton doneButton;

    public void SetTarget(Paintjob paint) {
        for (int i = 0; i < this.options.size(); ++i) {
            if (this.options.get(i) != paint) continue;
            this.target = i;
            return;
        }
        FlansMod.Assert(false, "Could not find paintjob we just unlocked!");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        int w = scaledresolution.func_78326_a();
        int h = scaledresolution.func_78328_b();
        this.guiOriginX = w / 2 - 98;
        this.guiOriginY = h / 2 - 100;
        this.doneButton = new GuiButton(0, this.field_146294_l / 2 - 20, this.guiOriginY + 170, 40, 20, "Done");
        this.doneButton.field_146124_l = false;
        this.field_146292_n.add(this.doneButton);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            ClientTeamsData.OpenLandingPage();
        }
    }

    public GuiOpenRewardBox(RewardBox rewardBox) {
        this.state = EnumPageState.SPINNING;
        this.timeLeftInState = spinTime;
        ArrayList<Paintjob> temp = new ArrayList<Paintjob>();
        for (Paintjob paintjob : rewardBox.paintjobs) {
            temp.add(paintjob);
        }
        int size = rewardBox.paintjobs.size();
        for (int i = 0; i < size; ++i) {
            int random = gunScrambler.nextInt(size - i);
            this.options.add((Paintjob)temp.get(random));
            temp.remove(random);
        }
        this.spinSpeed = this.InitialVelocity();
    }

    public void func_73876_c() {
        super.func_73876_c();
        --this.timeLeftInState;
        switch (this.state) {
            case SPINNING: {
                this.SimulateSpinner();
                if (this.timeLeftInState > 0 || this.target == -1) break;
                this.SwitchToState(EnumPageState.READY_TO_SLOW_DOWN);
                this.timeLeftInState = slowdownTime;
                break;
            }
            case READY_TO_SLOW_DOWN: {
                this.SimulateSpinner();
                float difference = MathHelper.func_76135_e((float)(this.spinner - (float)this.target));
                if (!(difference < 1.0f)) break;
                this.spinner = this.target;
                this.timeLeftInState = slowdownTime;
                this.SwitchToState(EnumPageState.SLOWING_DOWN);
                break;
            }
            case SLOWING_DOWN: {
                this.spinSpeed += this.Acceleration();
                if (this.spinSpeed <= -this.Acceleration()) {
                    this.spinSpeed = 0.0f;
                    FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(FlansModResourceHandler.getSound("UnlockNotch"), 1.0f, 2.0f, (float)this.field_146297_k.field_71439_g.field_70165_t, (float)this.field_146297_k.field_71439_g.field_70163_u, (float)this.field_146297_k.field_71439_g.field_70161_v));
                    this.SwitchToState(EnumPageState.STOPPED);
                }
                int timeInState = slowdownTime - this.timeLeftInState;
                int preIndex = MathHelper.func_76141_d((float)this.spinner) % this.options.size();
                this.spinner = (float)this.target + (float)timeInState * this.InitialVelocity() + 0.5f * this.Acceleration() * (float)timeInState * (float)timeInState;
                int postIndex = MathHelper.func_76141_d((float)this.spinner) % this.options.size();
                break;
            }
            case STOPPED: {
                this.spinner = this.target;
                this.doneButton.field_146124_l = true;
                break;
            }
        }
    }

    private void SimulateSpinner() {
        int preIndex = MathHelper.func_76141_d((float)this.spinner) % this.options.size();
        this.spinner += this.spinSpeed;
        int postIndex = MathHelper.func_76141_d((float)this.spinner) % this.options.size();
        if (this.spinner > (float)this.options.size()) {
            this.spinner -= (float)this.options.size();
        }
    }

    private float InitialVelocity() {
        return 2.0f / (float)slowdownTime * (float)this.options.size();
    }

    private float Acceleration() {
        return -(this.InitialVelocity() * this.InitialVelocity()) / (float)(2 * this.options.size());
    }

    private void SwitchToState(EnumPageState newState) {
        this.state = newState;
    }

    @Override
    public void func_73863_a(int i, int j, float f) {
        Paintjob paintjob;
        int index;
        int n;
        int postIndex;
        int preIndex = MathHelper.func_76141_d((float)this.spinner) % this.options.size();
        if (preIndex != (postIndex = MathHelper.func_76141_d((float)(this.spinner + this.spinSpeed * f)) % this.options.size()) && Minecraft.func_71386_F() - timeOfLastSound >= 80L) {
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(FlansModResourceHandler.getSound("UnlockNotch"), 0.5f, 1.0f, (float)this.field_146297_k.field_71439_g.field_70165_t, (float)this.field_146297_k.field_71439_g.field_70163_u, (float)this.field_146297_k.field_71439_g.field_70161_v));
            timeOfLastSound = Minecraft.func_71386_F();
        }
        ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        int w = scaledresolution.func_78326_a();
        int h = scaledresolution.func_78328_b();
        this.func_146276_q_();
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.guiOriginX = w / 2 - 98;
        this.guiOriginY = h / 2 - 100;
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        int textureX = 512;
        int textureY = 256;
        PlayerRankData data = ClientTeamsData.theRankData;
        LoadoutPool pool = ClientTeamsData.currentPool;
        if (data == null || pool == null) {
            FlansMod.log("Problem in landing page!");
            return;
        }
        GuiOpenRewardBox.func_146110_a((int)this.guiOriginX, (int)this.guiOriginY, (float)0.0f, (float)0.0f, (int)196, (int)200, (float)textureX, (float)textureY);
        int pixelOffset = ModuloHelper.modulo(MathHelper.func_76141_d((float)(this.spinner * 18.0f)), 18) - 18;
        GuiOpenRewardBox.func_146110_a((int)(this.guiOriginX + 9), (int)(this.guiOriginY + 101), (float)(239 + pixelOffset + 10), (float)101.0f, (int)180, (int)18, (float)textureX, (float)textureY);
        this.func_73732_a(this.field_146289_q, "Reward Box", this.guiOriginX + 98, this.guiOriginY + 12, 0xFFFFFF);
        for (n = 0; n < 10; ++n) {
            index = MathHelper.func_76141_d((float)this.spinner) - 4 + n;
            paintjob = this.options.get(ModuloHelper.modulo(index, this.options.size()));
            ItemStack stack = new ItemStack(paintjob.parent.getItem(), 1, paintjob.ID);
            this.drawSlotInventory(stack, this.guiOriginX + 18 - 18 - pixelOffset + 18 * n, this.guiOriginY + 102);
        }
        for (n = 0; n < 10; ++n) {
            index = MathHelper.func_76141_d((float)this.spinner) - 4 + n;
            paintjob = this.options.get(ModuloHelper.modulo(index, this.options.size()));
            this.DrawRarityBackground(paintjob.rarity, this.guiOriginX + 18 - 18 - pixelOffset + 18 * n, this.guiOriginY + 102);
        }
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        GlStateManager.func_179097_i();
        GuiOpenRewardBox.func_146110_a((int)(this.guiOriginX + 0), (int)(this.guiOriginY + 93), (float)0.0f, (float)93.0f, (int)196, (int)34, (float)textureX, (float)textureY);
        GlStateManager.func_179126_j();
        int currentIndex = MathHelper.func_76141_d((float)this.spinner) % this.options.size();
        ItemStack gunStack = new ItemStack(this.options.get((int)currentIndex).parent.item, 1, this.options.get((int)currentIndex).ID);
        this.DrawGun(gunStack, this.guiOriginX + 98, this.guiOriginY + 65, 60.0f);
        if (this.state == EnumPageState.STOPPED) {
            this.func_73732_a(this.field_146289_q, "New paintjob unlocked!", this.guiOriginX + 98, this.guiOriginY + 130, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, this.options.get((int)this.target).parent.name, this.guiOriginX + 98, this.guiOriginY + 142, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, "\"" + this.options.get((int)this.target).iconName + "\"", this.guiOriginX + 98, this.guiOriginY + 154, 0xFFFFFF);
        }
        super.func_73863_a(i, j, f);
    }

    private static enum EnumPageState {
        SPINNING,
        READY_TO_SLOW_DOWN,
        SLOWING_DOWN,
        STOPPED;

    }
}

