/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.model;

import com.flansmod.client.ClientProxy;
import com.flansmod.client.FlansModResourceHandler;
import com.flansmod.client.model.ModelDriveable;
import com.flansmod.client.model.ModelGun;
import com.flansmod.client.model.ModelMecha;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveablePosition;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.mechas.EntityMecha;
import com.flansmod.common.driveables.mechas.EnumMechaSlotType;
import com.flansmod.common.driveables.mechas.ItemMecha;
import com.flansmod.common.driveables.mechas.ItemMechaAddon;
import com.flansmod.common.driveables.mechas.MechaItemType;
import com.flansmod.common.driveables.mechas.MechaType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.Paintjob;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderMecha
extends Render
implements IItemRenderer {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final ItemRenderer renderer = new ItemRenderer(Minecraft.func_71410_x());
    private static RenderItem renderItem;

    public RenderMecha(RenderManager manager) {
        super(manager);
        renderItem = Minecraft.func_71410_x().func_175599_af();
        this.field_76989_e = 0.5f;
    }

    public void render(EntityMecha mecha, double d, double d1, double d2, float f, float f1) {
        ItemStack holdingStack;
        ItemStack hipsSlot;
        float dRoll;
        float dPitch;
        float dYaw;
        this.func_180548_c(mecha);
        float scale = 0.0625f;
        MechaType type = mecha.getMechaType();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
        for (dYaw = mecha.axes.getYaw() - mecha.field_70126_B; dYaw > 180.0f; dYaw -= 360.0f) {
        }
        while (dYaw <= -180.0f) {
            dYaw += 360.0f;
        }
        for (dPitch = mecha.axes.getPitch() - mecha.field_70127_C; dPitch > 180.0f; dPitch -= 360.0f) {
        }
        while (dPitch <= -180.0f) {
            dPitch += 360.0f;
        }
        for (dRoll = mecha.axes.getRoll() - mecha.prevRotationRoll; dRoll > 180.0f; dRoll -= 360.0f) {
        }
        while (dRoll <= -180.0f) {
            dRoll += 360.0f;
        }
        GL11.glRotatef((float)(-mecha.field_70126_B - dYaw * f1), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(mecha.field_70127_C + dPitch * f1), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(mecha.prevRotationRoll + dRoll * f1), (float)1.0f, (float)0.0f, (float)0.0f);
        float modelScale = mecha.getMechaType().modelScale;
        ModelMecha model = (ModelMecha)type.model;
        GL11.glPushMatrix();
        GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
        if (model != null) {
            model.render(mecha, f1);
        }
        if ((hipsSlot = mecha.inventory.getStackInSlot(EnumMechaSlotType.hips)) != null && hipsSlot.func_77973_b() instanceof ItemMechaAddon) {
            MechaItemType hipsAddon = ((ItemMechaAddon)hipsSlot.func_77973_b()).type;
            if (hipsAddon.model != null) {
                GL11.glTranslatef((float)model.hipsAttachmentPoint.x, (float)model.hipsAttachmentPoint.y, (float)model.hipsAttachmentPoint.z);
                GL11.glScalef((float)type.heldItemScale, (float)type.heldItemScale, (float)type.heldItemScale);
                if (hipsAddon.texture != null) {
                    this.func_110776_a(FlansModResourceHandler.getTexture(hipsAddon));
                }
                hipsAddon.model.render(mecha, f1);
            }
        }
        GL11.glPopMatrix();
        if (mecha.isPartIntact(EnumDriveablePart.leftArm)) {
            this.func_180548_c(mecha);
            GL11.glPushMatrix();
            float smoothedPitch = 0.0f;
            if (mecha.seats[0] != null) {
                smoothedPitch = mecha.seats[0].prevLooking.getPitch() + (mecha.seats[0].looking.getPitch() - mecha.seats[0].prevLooking.getPitch()) * f1;
            }
            if (smoothedPitch > type.lowerArmLimit) {
                smoothedPitch = type.lowerArmLimit;
            }
            if (smoothedPitch < -type.upperArmLimit) {
                smoothedPitch = -type.upperArmLimit;
            }
            GL11.glTranslatef((float)type.leftArmOrigin.x, (float)mecha.getMechaType().leftArmOrigin.y, (float)mecha.getMechaType().leftArmOrigin.z);
            GL11.glRotatef((float)(90.0f - smoothedPitch), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
            model.renderLeftArm(scale, mecha, f1);
            GL11.glPopMatrix();
            GL11.glTranslatef((float)(0.0f + type.leftHandModifierY), (float)(-type.armLength - type.leftHandModifierX), (float)(0.0f + type.leftHandModifierZ));
            holdingStack = mecha.inventory.getStackInSlot(EnumMechaSlotType.leftTool);
            GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
            if (holdingStack == null) {
                model.renderLeftHand(scale, mecha, f1);
            } else {
                GL11.glScalef((float)type.heldItemScale, (float)type.heldItemScale, (float)type.heldItemScale);
                this.renderItem(mecha, holdingStack, 0, true, f1);
            }
            GL11.glPopMatrix();
        }
        if (mecha.isPartIntact(EnumDriveablePart.rightArm)) {
            this.func_180548_c(mecha);
            GL11.glPushMatrix();
            float smoothedPitch = 0.0f;
            if (mecha.seats[0] != null) {
                smoothedPitch = mecha.seats[0].prevLooking.getPitch() + (mecha.seats[0].looking.getPitch() - mecha.seats[0].prevLooking.getPitch()) * f1;
            }
            if (smoothedPitch > type.lowerArmLimit) {
                smoothedPitch = type.lowerArmLimit;
            }
            if (smoothedPitch < -type.upperArmLimit) {
                smoothedPitch = -type.upperArmLimit;
            }
            GL11.glTranslatef((float)type.rightArmOrigin.x, (float)mecha.getMechaType().rightArmOrigin.y, (float)mecha.getMechaType().rightArmOrigin.z);
            GL11.glRotatef((float)(90.0f - smoothedPitch), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
            model.renderRightArm(scale, mecha, f1);
            GL11.glPopMatrix();
            GL11.glTranslatef((float)(0.0f + type.rightHandModifierY), (float)(-type.armLength - type.rightHandModifierX), (float)(0.0f + type.rightHandModifierZ));
            GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
            holdingStack = mecha.inventory.getStackInSlot(EnumMechaSlotType.rightTool);
            if (holdingStack == null) {
                model.renderRightHand(scale, mecha, f1);
            } else {
                GL11.glScalef((float)type.heldItemScale, (float)type.heldItemScale, (float)type.heldItemScale);
                this.renderItem(mecha, holdingStack, 0, false, f1);
            }
            GL11.glPopMatrix();
        }
        if (FlansMod.DEBUG) {
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2929);
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.3f);
            for (DriveablePart part : mecha.getDriveableData().parts.values()) {
                if (part.box == null) continue;
                RenderMecha.func_76978_a((AxisAlignedBB)new AxisAlignedBB((double)(part.box.x / 16.0f), (double)(part.box.y / 16.0f), (double)(part.box.z / 16.0f), (double)((part.box.x + part.box.w) / 16.0f), (double)((part.box.y + part.box.h) / 16.0f), (double)((part.box.z + part.box.d) / 16.0f)), (double)0.0, (double)0.0, (double)0.0);
            }
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)1.0f, (float)0.3f);
            for (DriveablePosition point : type.shootPointsPrimary) {
                RenderMecha.func_76978_a((AxisAlignedBB)new AxisAlignedBB((double)(point.position.x - 0.25f), (double)(point.position.y - 0.25f), (double)(point.position.z - 0.25f), (double)(point.position.x + 0.25f), (double)(point.position.y + 0.25f), (double)(point.position.z + 0.25f)), (double)0.0, (double)0.0, (double)0.0);
            }
            GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.3f);
            for (DriveablePosition point : type.shootPointsSecondary) {
                RenderMecha.func_76978_a((AxisAlignedBB)new AxisAlignedBB((double)(point.position.x - 0.25f), (double)(point.position.y - 0.25f), (double)(point.position.z - 0.25f), (double)(point.position.x + 0.25f), (double)(point.position.y + 0.25f), (double)(point.position.z + 0.25f)), (double)0.0, (double)0.0, (double)0.0);
            }
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2929);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glPopMatrix();
        if (mecha.isPartIntact(EnumDriveablePart.hips)) {
            this.func_180548_c(mecha);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
            for (dYaw = mecha.legAxes.getYaw() - mecha.prevLegsYaw; dYaw > 180.0f; dYaw -= 360.0f) {
            }
            while (dYaw <= -180.0f) {
                dYaw += 360.0f;
            }
            GL11.glRotatef((float)(-dYaw * f1 - mecha.prevLegsYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(mecha.field_70127_C + dPitch * f1), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(mecha.prevRotationRoll + dRoll * f1), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
            if (model != null) {
                float legLength = type.legLength;
                float rearlegLength = type.RearlegLength;
                float frontlegLength = type.FrontlegLength;
                float legTrans = type.LegTrans;
                float rearlegTrans = type.RearLegTrans;
                float frontlegTrans = type.FrontLegTrans;
                float legsYaw = (float)Math.sin(((float)mecha.field_70173_aa + f1) / type.legSwingTime) * mecha.legSwing;
                float footH = (float)Math.sin(legsYaw) * legLength;
                float footV = (float)Math.cos(legsYaw) * legLength;
                float footRH = (float)Math.sin(legsYaw) * rearlegLength;
                float footRV = (float)Math.cos(legsYaw) * rearlegLength;
                float footFH = (float)Math.sin(legsYaw) * frontlegLength;
                float footFV = (float)Math.cos(legsYaw) * frontlegLength;
                model.renderHips(scale, mecha, f1);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)legTrans, (float)legLength, (float)0.0f);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)footH, (float)(-footV), (float)0.0f);
                model.renderLeftFoot(scale, mecha, f1);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(-footH), (float)(-footV), (float)0.0f);
                model.renderRightFoot(scale, mecha, f1);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glRotatef((float)(legsYaw * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)(-legLength), (float)0.0f);
                model.renderLeftLeg(scale, mecha, f1);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glRotatef((float)(-legsYaw * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)(-legLength), (float)0.0f);
                model.renderRightLeg(scale, mecha, f1);
                GL11.glPopMatrix();
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)rearlegTrans, (float)rearlegLength, (float)0.0f);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(-footRH), (float)(-footRV), (float)0.0f);
                model.renderLeftRearFoot(scale, mecha, f1);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)footRH, (float)(-footRV), (float)0.0f);
                model.renderRightRearFoot(scale, mecha, f1);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glRotatef((float)(-legsYaw * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)(-rearlegLength), (float)0.0f);
                model.renderLeftRearLeg(scale, mecha, f1);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glRotatef((float)(legsYaw * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)(-rearlegLength), (float)0.0f);
                model.renderRightRearLeg(scale, mecha, f1);
                GL11.glPopMatrix();
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)frontlegTrans, (float)frontlegLength, (float)0.0f);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(-footFH), (float)(-footFV), (float)0.0f);
                model.renderLeftFrontFoot(scale, mecha, f1);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)footFH, (float)(-footFV), (float)0.0f);
                model.renderRightFrontFoot(scale, mecha, f1);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glRotatef((float)(-legsYaw * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)(-frontlegLength), (float)0.0f);
                model.renderLeftFrontLeg(scale, mecha, f1);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glRotatef((float)(legsYaw * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)(-frontlegLength), (float)0.0f);
                model.renderRightFrontLeg(scale, mecha, f1);
                GL11.glPopMatrix();
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
    }

    public void func_76986_a(Entity entity, double d0, double d1, double d2, float f, float f1) {
        this.render((EntityMecha)entity, d0, d1, d2, f, f1);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        DriveableType type = ((EntityDriveable)entity).getDriveableType();
        Paintjob paintjob = type.getPaintjob(((EntityDriveable)entity).getDriveableData().paintjobID);
        return FlansModResourceHandler.getPaintjobTexture(paintjob);
    }

    private void renderItem(EntityMecha mecha, ItemStack stack, int par3, boolean leftHand, float dT) {
        GL11.glPushMatrix();
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        Item item = stack.func_77973_b();
        if (item instanceof ItemMechaAddon) {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
            ItemMechaAddon toolItem = (ItemMechaAddon)item;
            MechaItemType toolType = toolItem.type;
            this.func_110776_a(FlansModResourceHandler.getTexture(toolType));
            if (toolType.model != null) {
                toolType.model.render(mecha, dT);
                GL11.glPushMatrix();
                if (leftHand && mecha.leftMouseHeld || !leftHand && mecha.rightMouseHeld) {
                    GL11.glRotatef((float)(25.0f * (float)mecha.field_70173_aa), (float)1.0f, (float)0.0f, (float)0.0f);
                }
                toolType.model.renderDrill(mecha, dT);
                GL11.glPopMatrix();
                toolType.model.renderSaw(mecha, dT, leftHand && mecha.leftMouseHeld || !leftHand && mecha.rightMouseHeld);
            }
        } else if (item instanceof ItemGun && ((ItemGun)item).GetType().model != null) {
            GunType gunType = ((ItemGun)item).GetType();
            ModelGun model = gunType.model;
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            texturemanager.func_110577_a(FlansModResourceHandler.getTexture(gunType));
            ClientProxy.gunRenderer.renderGun(stack, gunType, 0.0625f, model, leftHand ? mecha.leftAnimations : mecha.rightAnimations, 0.0f);
        } else {
            GL11.glRotatef((float)-135.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.4f, (float)0.0f);
            IBakedModel ibakedmodel = renderItem.func_175037_a().func_178089_a(stack);
            renderItem.func_180454_a(stack, ibakedmodel);
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: 
            case ENTITY: {
                return Minecraft.func_71410_x().field_71474_y.field_74347_j && item != null && item.func_77973_b() instanceof ItemMecha && ((ItemMecha)item.func_77973_b()).type.model != null;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        if (item != null && item.func_77973_b() instanceof ItemMecha) {
            MechaType mechaType = ((ItemMecha)item.func_77973_b()).type;
            if (mechaType.model != null) {
                float scale = 2.0f;
                switch (type) {
                    case INVENTORY: {
                        scale = 1.0f;
                        GL11.glTranslatef((float)0.0f, (float)-0.35f, (float)0.0f);
                        break;
                    }
                    case ENTITY: {
                        scale = 1.5f;
                        break;
                    }
                    case EQUIPPED: {
                        GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)270.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
                        scale = 0.5f;
                        break;
                    }
                    case EQUIPPED_FIRST_PERSON: {
                        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glTranslatef((float)-0.5f, (float)0.5f, (float)-0.5f);
                        scale = 1.0f;
                        break;
                    }
                }
                GL11.glScalef((float)(scale / mechaType.cameraDistance), (float)(scale / mechaType.cameraDistance), (float)(scale / mechaType.cameraDistance));
                Minecraft.func_71410_x().field_71446_o.func_110577_a(FlansModResourceHandler.getTexture(mechaType));
                ModelDriveable model = mechaType.model;
                model.render(mechaType);
            }
        }
        GL11.glPopMatrix();
    }
}

