/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.tmt;

import com.flansmod.client.tmt.PositionTextureVertex;
import com.flansmod.client.tmt.TransformGroup;
import java.util.ArrayList;
import net.minecraft.util.Vec3;

public class PositionTransformVertex
extends PositionTextureVertex {
    public Vec3 neutralVector;
    public ArrayList<TransformGroup> transformGroups = new ArrayList();

    public PositionTransformVertex(float x, float y, float z, float u, float v) {
        this(new Vec3((double)x, (double)y, (double)z), u, v);
    }

    public PositionTransformVertex(PositionTextureVertex vertex, float u, float v) {
        super(vertex, u, v);
        this.neutralVector = vertex instanceof PositionTransformVertex ? ((PositionTransformVertex)vertex).neutralVector : new Vec3(vertex.field_78243_a.field_72450_a, vertex.field_78243_a.field_72448_b, vertex.field_78243_a.field_72449_c);
    }

    public PositionTransformVertex(PositionTextureVertex vertex) {
        this(vertex, vertex.field_78241_b, vertex.field_78242_c);
    }

    public PositionTransformVertex(Vec3 vector, float u, float v) {
        super(vector, u, v);
        this.neutralVector = new Vec3(vector.field_72450_a, vector.field_72448_b, vector.field_72449_c);
    }

    public void setTransformation() {
        if (this.transformGroups.size() == 0) {
            this.field_78243_a = new Vec3(this.neutralVector.field_72450_a, this.neutralVector.field_72448_b, this.neutralVector.field_72449_c);
            return;
        }
        double weight = 0.0;
        for (TransformGroup transformGroup : this.transformGroups) {
            weight += transformGroup.getWeight();
        }
        this.field_78243_a = new Vec3(0.0, 0.0, 0.0);
        for (int i = 0; i < this.transformGroups.size(); ++i) {
            TransformGroup group = this.transformGroups.get(i);
            double cWeight = group.getWeight() / weight;
            Vec3 vector = group.doTransformation(this);
            this.field_78243_a = new Vec3(this.field_78243_a.field_72450_a + cWeight * vector.field_72450_a, this.field_78243_a.field_72448_b + cWeight * vector.field_72448_b, this.field_78243_a.field_72449_c + cWeight * vector.field_72449_c);
        }
    }

    public void addGroup(TransformGroup group) {
        this.transformGroups.add(group);
    }

    public void removeGroup(TransformGroup group) {
        this.transformGroups.remove(group);
    }
}

