/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common;

import com.flansmod.common.PlayerData;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.teams.TeamsManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerHandler {
    public static Map<String, PlayerData> serverSideData = new HashMap<String, PlayerData>();
    public static Map<String, PlayerData> clientSideData = new HashMap<String, PlayerData>();
    public static ArrayList<String> clientsToRemoveAfterThisRound = new ArrayList();

    public PlayerHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onEntityHurt(LivingAttackEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (event instanceof LivingAttackEvent && (entity.field_70154_o instanceof EntityDriveable || entity.field_70154_o instanceof EntitySeat)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityKilled(LivingDeathEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity instanceof EntityPlayer) {
            PlayerHandler.getPlayerData((EntityPlayer)entity).playerKilled();
        }
    }

    public void serverTick() {
        for (WorldServer world : MinecraftServer.func_71276_C().field_71305_c) {
            for (Object player : world.field_73010_i) {
                PlayerHandler.getPlayerData((EntityPlayer)player).tick((EntityPlayer)player);
            }
        }
    }

    public void clientTick() {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            for (Object player : Minecraft.func_71410_x().field_71441_e.field_73010_i) {
                PlayerHandler.getPlayerData((EntityPlayer)player).tick((EntityPlayer)player);
            }
        }
    }

    public static PlayerData getPlayerData(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        return PlayerHandler.getPlayerData(player.func_70005_c_(), player.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER);
    }

    public static PlayerData getPlayerData(String username) {
        return PlayerHandler.getPlayerData(username, Side.SERVER);
    }

    public static PlayerData getPlayerData(EntityPlayer player, Side side) {
        if (player == null) {
            return null;
        }
        return PlayerHandler.getPlayerData(player.func_70005_c_(), side);
    }

    public static PlayerData getPlayerData(String username, Side side) {
        if (side.isClient()) {
            if (!clientSideData.containsKey(username)) {
                clientSideData.put(username, new PlayerData(username));
            }
        } else if (!serverSideData.containsKey(username)) {
            serverSideData.put(username, new PlayerData(username));
        }
        return side.isClient() ? clientSideData.get(username) : serverSideData.get(username);
    }

    @SubscribeEvent
    public void onPlayerEvent(PlayerEvent event) {
        EntityPlayer player;
        String username;
        if (event instanceof PlayerEvent.PlayerLoggedInEvent) {
            EntityPlayer player2 = event.player;
            String username2 = player2.func_70005_c_();
            PlayerData data = new PlayerData(username2);
            data.ReadFromFile();
            if (!serverSideData.containsKey(username2)) {
                serverSideData.put(username2, data);
            }
            if (clientsToRemoveAfterThisRound.contains(username2)) {
                clientsToRemoveAfterThisRound.remove(username2);
            }
        } else if (event instanceof PlayerEvent.PlayerLoggedOutEvent) {
            EntityPlayer player3 = event.player;
            String username3 = player3.func_70005_c_();
            clientsToRemoveAfterThisRound.add(username3);
            if (TeamsManager.getInstance().currentRound == null) {
                PlayerHandler.roundEnded();
            }
        } else if (event instanceof PlayerEvent.PlayerRespawnEvent && !serverSideData.containsKey(username = (player = event.player).func_70005_c_())) {
            serverSideData.put(username, new PlayerData(username));
        }
    }

    public static void roundEnded() {
        for (String username : clientsToRemoveAfterThisRound) {
            PlayerData data = serverSideData.get(username);
            if (data != null) {
                data.WriteToFile();
            }
            serverSideData.remove(username);
        }
    }
}

