/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.client.model.ModelAttachment;
import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.EnumAttachmentType;
import com.flansmod.common.guns.EnumFireMode;
import com.flansmod.common.guns.IScope;
import com.flansmod.common.guns.ItemAttachment;
import com.flansmod.common.types.PaintableType;
import com.flansmod.common.types.TypeFile;
import java.util.ArrayList;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AttachmentType
extends PaintableType
implements IScope {
    public static ArrayList<AttachmentType> attachments = new ArrayList();
    public EnumAttachmentType type = EnumAttachmentType.generic;
    public boolean silencer = false;
    public boolean flashlight = false;
    public float flashlightRange = 10.0f;
    public int flashlightStrength = 12;
    public float spreadMultiplier = 1.0f;
    public float recoilMultiplier = 1.0f;
    public float damageMultiplier = 1.0f;
    public float meleeDamageMultiplier = 1.0f;
    public float bulletSpeedMultiplier = 1.0f;
    public float reloadTimeMultiplier = 1.0f;
    public EnumFireMode modeOverride = null;
    public float zoomLevel = 1.0f;
    public float FOVZoomLevel = 1.0f;
    public String zoomOverlay;
    public boolean hasScopeOverlay = false;
    @SideOnly(value=Side.CLIENT)
    public ModelAttachment model;
    public int maxStackSize = 1;

    public AttachmentType(TypeFile file) {
        super(file);
        attachments.add(this);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            if (split[0].equals("AttachmentType")) {
                this.type = EnumAttachmentType.get(split[1]);
            } else if (FMLCommonHandler.instance().getSide().isClient() && split[0].equals("Model")) {
                this.model = FlansMod.proxy.loadModel(split[1], this.shortName, ModelAttachment.class);
            } else if (split[0].equals("Silencer")) {
                this.silencer = Boolean.parseBoolean(split[1].toLowerCase());
            } else if (split[0].equals("Flashlight")) {
                this.flashlight = Boolean.parseBoolean(split[1].toLowerCase());
            } else if (split[0].equals("FlashlightRange")) {
                this.flashlightRange = Float.parseFloat(split[1]);
            } else if (split[0].equals("FlashlightStrength")) {
                this.flashlightStrength = Integer.parseInt(split[1]);
            } else if (split[0].equals("ModeOverride")) {
                this.modeOverride = EnumFireMode.getFireMode(split[1]);
            } else if (split[0].equals("MeleeDamageMultiplier")) {
                this.meleeDamageMultiplier = Float.parseFloat(split[1]);
            } else if (split[0].equals("DamageMultiplier")) {
                this.damageMultiplier = Float.parseFloat(split[1]);
            } else if (split[0].equals("SpreadMultiplier")) {
                this.spreadMultiplier = Float.parseFloat(split[1]);
            } else if (split[0].equals("RecoilMultiplier")) {
                this.recoilMultiplier = Float.parseFloat(split[1]);
            } else if (split[0].equals("BulletSpeedMultiplier")) {
                this.bulletSpeedMultiplier = Float.parseFloat(split[1]);
            } else if (split[0].equals("ReloadTimeMultiplier")) {
                this.reloadTimeMultiplier = Float.parseFloat(split[1]);
            } else if (split[0].equals("ZoomLevel")) {
                this.zoomLevel = Float.parseFloat(split[1]);
            } else if (split[0].equals("FOVZoomLevel")) {
                this.FOVZoomLevel = Float.parseFloat(split[1]);
            } else if (split[0].equals("ZoomOverlay")) {
                this.hasScopeOverlay = true;
                if (split[1].equals("None")) {
                    this.hasScopeOverlay = false;
                } else {
                    this.zoomOverlay = split[1];
                }
            }
        }
        catch (Exception e) {
            System.out.println("Reading attachment file failed.");
            e.printStackTrace();
        }
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelAttachment.class);
    }

    public static AttachmentType getFromNBT(NBTTagCompound tags) {
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tags);
        if (stack != null && stack.func_77973_b() instanceof ItemAttachment) {
            return ((ItemAttachment)stack.func_77973_b()).type;
        }
        return null;
    }

    @Override
    public float getZoomFactor() {
        return this.zoomLevel;
    }

    @Override
    public boolean hasZoomOverlay() {
        return this.hasScopeOverlay;
    }

    @Override
    public String getZoomOverlay() {
        return this.zoomOverlay;
    }

    @Override
    public float getFOVFactor() {
        return this.FOVZoomLevel;
    }

    public static AttachmentType getAttachment(String s) {
        for (AttachmentType attachment : attachments) {
            if (!attachment.shortName.equals(s)) continue;
            return attachment;
        }
        return null;
    }

    @Override
    public void preRead(TypeFile file) {
        super.preRead(file);
    }

    @Override
    public void postRead(TypeFile file) {
        super.postRead(file);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return this.model;
    }

    @Override
    public float GetRecommendedScale() {
        return 100.0f;
    }
}

