/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.guns.raytracing.FlansModRaytracer;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.vector.Vector3f;
import net.minecraft.entity.Entity;

public class ShotData {
    public int slot;
    public InfoType shotFrom;
    public ShootableType shotType;

    public ShotData(int slot, InfoType shotFrom, ShootableType shotType) {
        this.slot = slot;
        this.shotFrom = shotFrom;
        this.shotType = shotType;
    }

    public static class InstantShotData
    extends ShotData {
        public int shooterID;
        public Vector3f origin;
        public FlansModRaytracer.BulletHit hitData;
        public Vector3f hitPos;
        public float damage;
        public boolean isExtraBullet;
        public boolean silenced;

        public InstantShotData(int slot, InfoType shotFrom, ShootableType shotType, int shooterID, Vector3f origin, FlansModRaytracer.BulletHit hitData, Vector3f hit, float damage, boolean isExtraBullet, boolean silenced) {
            super(slot, shotFrom, shotType);
            this.shooterID = shooterID;
            this.origin = origin;
            this.hitData = hitData;
            this.hitPos = hit;
            this.damage = damage;
            this.isExtraBullet = isExtraBullet;
            this.silenced = silenced;
        }

        public InstantShotData(int slot, InfoType shotFrom, ShootableType shotType, Entity shooter, Vector3f origin, FlansModRaytracer.BulletHit hitData, Vector3f hit, float damage, boolean isExtraBullet, boolean silenced) {
            this(slot, shotFrom, shotType, shooter.func_145782_y(), origin, hitData, hit, damage, isExtraBullet, silenced);
        }
    }

    public static class SpawnEntityShotData
    extends ShotData {
        public int shooterID;
        public Vector3f direction;

        public SpawnEntityShotData(int slot, InfoType shotFrom, ShootableType shotType, int shooterID, Vector3f direction) {
            super(slot, shotFrom, shotType);
            this.shooterID = shooterID;
            this.direction = direction;
        }

        public SpawnEntityShotData(int slot, InfoType shotFrom, ShootableType shotType, Entity shooter, Vector3f direction) {
            this(slot, shotFrom, shotType, shooter.func_145782_y(), direction);
        }
    }
}

