/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns.boxes;

import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.boxes.BlockGunBox;
import com.flansmod.common.guns.boxes.BoxType;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

public class GunBoxType
extends BoxType {
    public BlockGunBox block;
    public HashMap<String, GunBoxPage> pagesByTitle = new HashMap();
    public ArrayList<GunBoxPage> pages = new ArrayList();
    private GunBoxPage currentPage;
    public GunBoxPage defaultPage;
    private static int lastIconIndex = 2;
    public static HashMap<String, GunBoxType> gunBoxMap = new HashMap();

    public GunBoxType(TypeFile file) {
        super(file);
    }

    @Override
    public void preRead(TypeFile file) {
        super.preRead(file);
        for (String line : file.lines) {
            String[] split;
            if (line == null) break;
            if (line.startsWith("//") || (split = line.split(" ")).length < 2 || !split[0].equals("NumGuns")) continue;
            this.currentPage = new GunBoxPage("default");
            this.pagesByTitle.put("default", this.currentPage);
            this.pages.add(this.currentPage);
        }
    }

    @Override
    public void postRead(TypeFile file) {
        super.postRead(file);
        gunBoxMap.put(this.shortName, this);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            if (split[0].equals("SetPage")) {
                String pageName = split[1];
                for (int i = 2; i < split.length; ++i) {
                    pageName = pageName + " " + split[i];
                }
                if (this.pagesByTitle.get(pageName) == null) {
                    this.currentPage = new GunBoxPage(pageName);
                    this.pagesByTitle.put(pageName, this.currentPage);
                }
                this.pages.add(this.currentPage);
            } else if (split[0].equals("AddGun") || split[0].equals("AddType")) {
                this.currentPage.addNewEntry(InfoType.getType(split[1]), this.getRecipe(split));
            } else if (split[0].equals("AddAmmo") || split[0].equals("AddAltType") || split[0].equals("AddAltAmmo") || split[0].equals("AddAlternateAmmo")) {
                this.currentPage.addAmmoToCurrentEntry(InfoType.getType(split[1]), this.getRecipe(split));
            }
        }
        catch (Exception e) {
            FlansMod.log("Reading gun box file failed : " + this.shortName);
            e.printStackTrace();
        }
    }

    private List<ItemStack> getRecipe(String[] split) {
        ArrayList<ItemStack> recipe = new ArrayList<ItemStack>();
        for (int i = 0; i < (split.length - 2) / 2; ++i) {
            if (split[i * 2 + 3].contains(".")) {
                recipe.add(GunBoxType.getRecipeElement(split[i * 2 + 3].split("\\.")[0], Integer.parseInt(split[i * 2 + 2]), Integer.valueOf(split[i * 2 + 3].split("\\.")[1]), this.shortName));
                continue;
            }
            recipe.add(GunBoxType.getRecipeElement(split[i * 2 + 3], Integer.parseInt(split[i * 2 + 2]), 0, this.shortName));
        }
        return recipe;
    }

    public static GunBoxType getBox(String s) {
        return gunBoxMap.get(s);
    }

    public static GunBoxType getBox(Block block) {
        for (GunBoxType type : gunBoxMap.values()) {
            if (type.block != block) continue;
            return type;
        }
        return null;
    }

    public GunBoxEntry canCraft(InfoType type) {
        for (GunBoxPage page : this.pagesByTitle.values()) {
            for (GunBoxEntryTopLevel entry : page.entries) {
                if (entry.type == type) {
                    return entry;
                }
                for (GunBoxEntry child : entry.childEntries) {
                    if (child.type != type) continue;
                    return child;
                }
            }
        }
        return null;
    }

    public static class GunBoxEntryTopLevel
    extends GunBoxEntry {
        public List<GunBoxEntry> childEntries = new ArrayList<GunBoxEntry>();

        public GunBoxEntryTopLevel(InfoType type, List<ItemStack> requiredParts) {
            super(type, requiredParts);
        }

        public void addAmmo(InfoType type, List<ItemStack> requiredParts) {
            this.childEntries.add(new GunBoxEntry(type, requiredParts));
        }
    }

    public static class GunBoxEntry {
        public InfoType type;
        public List<ItemStack> requiredParts;

        public GunBoxEntry(InfoType type, List<ItemStack> requiredParts) {
            this.type = type;
            this.requiredParts = requiredParts;
        }

        public boolean canCraft(InventoryPlayer inv, boolean takeItems) {
            InventoryPlayer temporaryInventory = new InventoryPlayer(null);
            temporaryInventory.func_70455_b(inv);
            boolean canCraft = true;
            for (ItemStack stackNeeded : this.requiredParts) {
                int totalAmountFound = 0;
                for (int m = 0; m < temporaryInventory.func_70302_i_(); ++m) {
                    ItemStack stackInSlot = temporaryInventory.func_70301_a(m);
                    if (stackInSlot == null || stackInSlot.func_77973_b() != stackNeeded.func_77973_b() || stackInSlot.func_77952_i() != stackNeeded.func_77952_i()) continue;
                    int amountFound = Math.min(stackInSlot.field_77994_a, stackNeeded.field_77994_a - totalAmountFound);
                    stackInSlot.field_77994_a -= amountFound;
                    if (stackInSlot.field_77994_a <= 0) {
                        stackInSlot = null;
                    }
                    temporaryInventory.func_70299_a(m, stackInSlot);
                    if ((totalAmountFound += amountFound) == stackNeeded.field_77994_a) break;
                }
                if (totalAmountFound >= stackNeeded.field_77994_a) continue;
                canCraft = false;
            }
            if (canCraft && takeItems) {
                inv.func_70455_b(temporaryInventory);
            }
            return canCraft;
        }
    }

    public static class GunBoxPage {
        public List<GunBoxEntryTopLevel> entries;
        private GunBoxEntryTopLevel currentlyEditing;
        public String name;

        public GunBoxPage(String s) {
            this.name = s;
            this.entries = new ArrayList<GunBoxEntryTopLevel>();
        }

        public void addNewEntry(InfoType type, List<ItemStack> requiredParts) {
            GunBoxEntryTopLevel entry = new GunBoxEntryTopLevel(type, requiredParts);
            this.entries.add(entry);
            this.currentlyEditing = entry;
        }

        public void addAmmoToCurrentEntry(InfoType type, List<ItemStack> requiredParts) {
            this.currentlyEditing.addAmmo(type, requiredParts);
        }
    }
}

