/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.network.PacketBase;
import com.flansmod.common.network.PacketPlaySound;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketReload
extends PacketBase {
    public boolean isOffHand;
    public boolean isForced;

    public PacketReload() {
    }

    public PacketReload(boolean isOffHand, boolean isForced) {
        this.isOffHand = isOffHand;
        this.isForced = isForced;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeBoolean(this.isOffHand);
        data.writeBoolean(this.isForced);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.isOffHand = data.readBoolean();
        this.isForced = data.readBoolean();
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)playerEntity);
        ItemStack stack = playerEntity.func_71045_bC();
        int slot = playerEntity.field_71071_by.field_70461_c;
        if (this.isOffHand && data.offHandGunSlot != 0) {
            stack = playerEntity.field_71071_by.func_70301_a(data.offHandGunSlot - 1);
            slot = data.offHandGunSlot - 1;
        }
        if (data != null && stack != null && stack.func_77973_b() instanceof ItemGun) {
            GunType type = ((ItemGun)stack.func_77973_b()).GetType();
            if (((ItemGun)stack.func_77973_b()).Reload(stack, playerEntity.field_70170_p, (Entity)playerEntity, (IInventory)playerEntity.field_71071_by, this.isOffHand, data.offHandGunSlot != 0, this.isForced, playerEntity.field_71075_bZ.field_75098_d)) {
                data.shootTimeRight = data.shootTimeLeft = (float)type.reloadTime;
                if (this.isOffHand) {
                    data.reloadingLeft = true;
                } else {
                    data.reloadingRight = true;
                }
                if (type.reloadSound != null) {
                    PacketPlaySound.sendSoundPacket(playerEntity.field_70165_t, playerEntity.field_70163_u, playerEntity.field_70161_v, 50.0, playerEntity.field_71093_bK, type.reloadSound, false);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        FlansMod.log("Recieved reload packet on client!");
    }
}

