/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.boxes.BoxType;
import com.flansmod.common.teams.ArmourType;
import com.flansmod.common.teams.BlockArmourBox;
import com.flansmod.common.types.TypeFile;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.item.ItemStack;

public class ArmourBoxType
extends BoxType {
    public BlockArmourBox block;
    public ArrayList<ArmourBoxEntry> pages = new ArrayList();
    public static HashMap<String, ArmourBoxType> boxes = new HashMap();

    public ArmourBoxType(TypeFile file) {
        super(file);
    }

    @Override
    public void postRead(TypeFile file) {
        super.postRead(file);
        boxes.put(this.shortName, this);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            if (split[0].toLowerCase().equals("addarmour") || split[0].toLowerCase().equals("addarmor")) {
                String name = split[2];
                for (int i = 3; i < split.length; ++i) {
                    name = name + " " + split[i];
                }
                ArmourBoxEntry entry = new ArmourBoxEntry(split[1], name);
                for (int i = 0; i < 4; ++i) {
                    String line = null;
                    line = file.readLine();
                    if (line == null) continue;
                    if (line.startsWith("//")) {
                        --i;
                        continue;
                    }
                    String[] lineSplit = line.split(" ");
                    entry.armours[i] = ArmourType.getArmourType(lineSplit[0]);
                    for (int j = 0; j < (lineSplit.length - 1) / 2; ++j) {
                        ItemStack stack = null;
                        stack = lineSplit[j * 2 + 1].contains(".") ? ArmourBoxType.getRecipeElement(lineSplit[j * 2 + 1].split("\\.")[0], Integer.valueOf(lineSplit[j * 2 + 2]), Integer.valueOf(lineSplit[j * 2 + 1].split("\\.")[1]), this.shortName) : ArmourBoxType.getRecipeElement(lineSplit[j * 2 + 1], Integer.valueOf(lineSplit[j * 2 + 2]), 0, this.shortName);
                        if (stack == null) continue;
                        entry.requiredStacks[i].add(stack);
                    }
                }
                this.pages.add(entry);
            }
        }
        catch (Exception e) {
            FlansMod.log("Reading gun box file failed : " + this.shortName);
            e.printStackTrace();
        }
    }

    public static ArmourBoxType getBox(String boxShortName) {
        return boxes.get(boxShortName);
    }

    public class ArmourBoxEntry {
        public String shortName;
        public String name = "";
        public ArmourType[] armours;
        public ArrayList<ItemStack>[] requiredStacks;

        public ArmourBoxEntry(String s, String s1) {
            this.shortName = s;
            this.name = s1;
            this.armours = new ArmourType[4];
            this.requiredStacks = new ArrayList[4];
            for (int i = 0; i < 4; ++i) {
                this.requiredStacks[i] = new ArrayList();
            }
        }
    }
}

