/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.network.PacketBaseEdit;
import com.flansmod.common.teams.EntityConnectingLine;
import com.flansmod.common.teams.ITeamBase;
import com.flansmod.common.teams.ITeamObject;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.teams.TeamsMap;
import com.flansmod.common.types.IFlanItem;
import com.flansmod.common.types.InfoType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemOpStick
extends Item
implements IFlanItem {
    public static final String[] teamNames = new String[]{"No Team", "Spectators", "Team 1", "Team 2"};
    public static final String[] stickNames = new String[]{"opStick_ownership", "opStick_connecting", "opStick_mapping", "opStick_destruction"};

    public ItemOpStick() {
        this.func_77655_b("opStick");
        this.func_77627_a(true);
    }

    public boolean func_77629_n_() {
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }

    public void clickedEntity(World world, EntityPlayer player, Entity clicked) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        if (clicked instanceof ITeamBase) {
            this.clickedBase(world, (EntityPlayerMP)player, (ITeamBase)clicked);
        }
        if (clicked instanceof ITeamObject) {
            this.clickedObject(world, (EntityPlayerMP)player, (ITeamObject)clicked);
        }
    }

    public static void openBaseEditGUI(ITeamBase base, EntityPlayerMP player) {
        String[] maps = new String[TeamsManager.getInstance().maps.values().size()];
        if (maps.length == 0) {
            TeamsManager.messagePlayer(player, "Maps are not yet set up. Use /teams help");
            return;
        }
        int currentMapID = -1;
        int i = 0;
        for (TeamsMap map : TeamsManager.getInstance().maps.values()) {
            maps[i] = map.name;
            if (map == base.getMap()) {
                currentMapID = i;
            }
            ++i;
        }
        FlansMod.getPacketHandler().sendTo(new PacketBaseEdit(base.getBaseID(), base.getBaseName(), maps, currentMapID, base.getDefaultOwnerID()), player);
    }

    public void clickedBase(World world, EntityPlayerMP player, ITeamBase base) {
        if (!world.field_72995_K) {
            int damage = player.field_71071_by.func_70448_g().func_77952_i();
            TeamsManager teamsManager = TeamsManager.getInstance();
            switch (damage) {
                case 0: {
                    int currentOwnerID = base.getDefaultOwnerID();
                    ++currentOwnerID;
                    base.setDefaultOwnerID(currentOwnerID %= 4);
                    base.setOwnerID(currentOwnerID);
                    for (ITeamObject object : base.getObjects()) {
                        object.onBaseSet(currentOwnerID);
                    }
                    TeamsManager.messagePlayer(player, "Base owner changed to " + teamNames[currentOwnerID]);
                    break;
                }
                case 1: {
                    if (player.field_71104_cf == null) {
                        EntityConnectingLine hook = new EntityConnectingLine(world, (EntityPlayer)player, base);
                        world.func_72838_d((Entity)hook);
                        break;
                    }
                    if (!(player.field_71104_cf instanceof EntityConnectingLine)) break;
                    EntityConnectingLine line = (EntityConnectingLine)player.field_71104_cf;
                    if (line.connectedTo instanceof ITeamObject) {
                        ITeamObject object = (ITeamObject)line.connectedTo;
                        object.setBase(base);
                        base.addObject(object);
                        line.func_70106_y();
                        player.field_71104_cf = null;
                        TeamsManager.messagePlayer(player, "Successfully connected.");
                        break;
                    }
                    TeamsManager.messagePlayer(player, "Cannot connect bases to bases.");
                    break;
                }
                case 2: {
                    ItemOpStick.openBaseEditGUI(base, player);
                    break;
                }
                case 3: {
                    base.destroy();
                }
            }
        }
    }

    public void clickedObject(World world, EntityPlayerMP player, ITeamObject object) {
        int damage = player.field_71071_by.func_70448_g().func_77952_i();
        TeamsManager teamsManager = TeamsManager.getInstance();
        switch (damage) {
            case 0: {
                break;
            }
            case 1: {
                if (player.field_71104_cf == null) {
                    EntityConnectingLine hook = new EntityConnectingLine(world, (EntityPlayer)player, object);
                    world.func_72838_d((Entity)hook);
                    break;
                }
                if (!(player.field_71104_cf instanceof EntityConnectingLine)) break;
                EntityConnectingLine line = (EntityConnectingLine)player.field_71104_cf;
                if (line.connectedTo instanceof ITeamBase) {
                    ITeamBase base = (ITeamBase)line.connectedTo;
                    object.setBase(base);
                    base.addObject(object);
                    TeamsManager.messagePlayer(player, "Successfully connected.");
                    break;
                }
                TeamsManager.messagePlayer(player, "Cannot connect objects to objects.");
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                object.destroy();
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + stack.func_77952_i();
    }

    @Override
    public InfoType getInfoType() {
        return null;
    }
}

