/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.client.gui.teams.EnumLoadoutSlot;
import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.Paintjob;
import com.flansmod.common.teams.LoadoutPool;
import com.flansmod.common.teams.RewardBoxInstance;
import com.flansmod.common.teams.TeamsManagerRanked;
import com.flansmod.common.types.IFlanItem;
import com.flansmod.common.types.InfoType;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PlayerLoadout {
    public ItemStack[] slots = new ItemStack[EnumLoadoutSlot.values().length];

    public PlayerLoadout copy() {
        PlayerLoadout copy = new PlayerLoadout();
        for (int i = 0; i < EnumLoadoutSlot.values().length; ++i) {
            copy.slots[i] = this.slots[i] == null ? null : this.slots[i].func_77946_l();
        }
        return copy;
    }

    public void writeToBuf(ByteBuf data) {
        for (int i = 0; i < EnumLoadoutSlot.values().length; ++i) {
            ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)this.slots[i]);
        }
    }

    public void readFromBuf(ByteBuf data) {
        for (int i = 0; i < EnumLoadoutSlot.values().length; ++i) {
            this.slots[i] = ByteBufUtils.readItemStack((ByteBuf)data);
        }
    }

    public void readFromNBT(NBTTagCompound tags) {
        for (int i = 0; i < EnumLoadoutSlot.values().length; ++i) {
            this.slots[i] = ItemStack.func_77949_a((NBTTagCompound)tags.func_74775_l("slot_" + i));
        }
    }

    public void writeToNBT(NBTTagCompound tags) {
        for (int i = 0; i < EnumLoadoutSlot.values().length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound stackTags = new NBTTagCompound();
            this.slots[i].func_77955_b(stackTags);
            tags.func_74782_a("slot_" + i, (NBTBase)stackTags);
        }
    }

    public boolean Verify(int currentLevel, ArrayList<RewardBoxInstance> rewardBoxData) {
        LoadoutPool pool = TeamsManagerRanked.GetInstance().currentPool;
        if (pool == null) {
            return false;
        }
        block4: for (int i = 0; i < EnumLoadoutSlot.values().length; ++i) {
            ItemStack stack = this.slots[i];
            if (stack == null || !(stack.func_77973_b() instanceof IFlanItem)) continue;
            InfoType type = ((IFlanItem)stack.func_77973_b()).getInfoType();
            switch (EnumLoadoutSlot.values()[i]) {
                case primary: 
                case secondary: {
                    if (!this.VerifyType(type, pool.unlocks[i], currentLevel)) {
                        return false;
                    }
                    if (!(type instanceof GunType)) continue block4;
                    GunType gun = (GunType)type;
                    if (!this.VerifyType(gun.getBarrel(stack), pool.unlocks[i], currentLevel)) {
                        return false;
                    }
                    if (!this.VerifyType(gun.getScope(stack), pool.unlocks[i], currentLevel)) {
                        return false;
                    }
                    if (!this.VerifyType(gun.getStock(stack), pool.unlocks[i], currentLevel)) {
                        return false;
                    }
                    if (!this.VerifyType(gun.getGrip(stack), pool.unlocks[i], currentLevel)) {
                        return false;
                    }
                    if (!this.VerifyType(gun.getGeneric(stack, 0), pool.unlocks[i], currentLevel)) {
                        return false;
                    }
                    Paintjob paint = gun.getPaintjob(stack.func_77952_i());
                    if (this.VerifyPaint(paint, rewardBoxData)) continue block4;
                    return false;
                }
                case armour: 
                case melee: 
                case special: {
                    if (this.VerifyType(type, pool.unlocks[i], currentLevel)) continue block4;
                    return false;
                }
                default: {
                    FlansMod.Assert(false, "Missing case in loadout verification");
                    return false;
                }
            }
        }
        return true;
    }

    private boolean VerifyType(InfoType target, ArrayList<LoadoutPool.LoadoutEntryInfoType> list, int currentLevel) {
        if (target == null) {
            return true;
        }
        for (LoadoutPool.LoadoutEntryInfoType entry : list) {
            if (entry.type != target) continue;
            return entry.unlockLevel <= currentLevel;
        }
        FlansMod.Assert(false, "Player put invalid item in slot " + target.shortName);
        return false;
    }

    private boolean VerifyPaint(Paintjob paint, ArrayList<RewardBoxInstance> rewardBoxData) {
        if (paint.ID == 0) {
            return true;
        }
        for (RewardBoxInstance box : rewardBoxData) {
            if (box.unlockHash != paint.hashCode()) continue;
            return true;
        }
        return false;
    }
}

